/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmeter.plugins.webdriver.config.gui;

import com.googlecode.jmeter.plugins.webdriver.config.ChromeDriverConfig;
import com.googlecode.jmeter.plugins.webdriver.config.gui.WebDriverConfigGui;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kg.apc.jmeter.JMeterPluginsUtils;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;

public class ChromeDriverConfigGui
extends WebDriverConfigGui {
    private static final long serialVersionUID = 100L;
    JTextField chromeServicePath;
    JCheckBox androidEnabled;

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel("Chrome Driver Config");
    }

    public String getLabelResource() {
        return this.getClass().getCanonicalName();
    }

    @Override
    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof ChromeDriverConfig) {
            ChromeDriverConfig config = (ChromeDriverConfig)element;
            this.chromeServicePath.setText(config.getChromeDriverPath());
            this.androidEnabled.setSelected(config.isAndroidEnabled());
        }
    }

    public TestElement createTestElement() {
        ChromeDriverConfig element = new ChromeDriverConfig();
        this.modifyTestElement((TestElement)element);
        return element;
    }

    @Override
    public void modifyTestElement(TestElement element) {
        super.modifyTestElement(element);
        if (element instanceof ChromeDriverConfig) {
            ChromeDriverConfig config = (ChromeDriverConfig)element;
            config.setChromeDriverPath(this.chromeServicePath.getText());
            config.setAndroidEnabled(this.androidEnabled.isSelected());
        }
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.chromeServicePath.setText("");
        this.androidEnabled.setSelected(false);
    }

    @Override
    protected JPanel createBrowserPanel() {
        return this.createServicePanel();
    }

    @Override
    protected String browserName() {
        return "Chrome";
    }

    @Override
    protected String getWikiPage() {
        return "ChromeDriverConfig";
    }

    private JPanel createServicePanel() {
        VerticalPanel browserPanel = new VerticalPanel();
        HorizontalPanel chromeServicePanel = new HorizontalPanel();
        JLabel chromeDriverServiceLabel = new JLabel("Path to Chrome Driver");
        chromeServicePanel.add(chromeDriverServiceLabel);
        this.chromeServicePath = new JTextField();
        chromeServicePanel.add(this.chromeServicePath);
        browserPanel.add((Component)chromeServicePanel);
        this.androidEnabled = new JCheckBox("Use Chrome on Android");
        browserPanel.add(this.androidEnabled);
        return browserPanel;
    }

    @Override
    protected boolean isProxyEnabled() {
        return true;
    }

    @Override
    protected boolean isExperimentalEnabled() {
        return true;
    }
}

