/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmeter.plugins.webdriver.sampler;

import com.googlecode.jmeter.plugins.webdriver.sampler.WebDriverScriptable;
import java.net.URL;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import kg.apc.jmeter.JMeterPluginsUtils;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.openqa.selenium.WebDriver;

public class WebDriverSampler
extends AbstractSampler {
    private static final long serialVersionUID = 100L;
    public static final String SCRIPT = "WebDriverSampler.script";
    public static final String PARAMETERS = "WebDriverSampler.parameters";
    private static final Logger LOGGER = LoggingManager.getLoggerForClass();
    public static final String DEFAULT_ENGINE = "javascript";
    public static final String SCRIPT_LANGUAGE = "WebDriverSampler.language";
    private final transient ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
    private final Class<SampleResult> sampleResultClass;
    public static final String defaultScript = "WDS.sampleResult.sampleStart()\nWDS.browser.get('http://jmeter-plugins.org')\nWDS.sampleResult.sampleEnd()\n";

    public WebDriverSampler() {
        Class<Object> srClass;
        String className = JMeterUtils.getPropDefault((String)"webdriver.sampleresult_class", (String)SampleResult.class.getCanonicalName());
        try {
            srClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn("Class " + className + " not found, defaulted to " + SampleResult.class.getCanonicalName(), (Throwable)e);
            srClass = SampleResult.class;
        }
        this.sampleResultClass = srClass;
    }

    public SampleResult sample(Entry e) {
        SampleResult res;
        block8: {
            if (this.getWebDriver() == null) {
                throw new IllegalArgumentException("Browser has not been configured.  Please ensure at least 1 WebDriverConfig is created for a ThreadGroup.");
            }
            try {
                res = this.sampleResultClass.newInstance();
            }
            catch (InstantiationException e1) {
                LOGGER.warn("Class " + this.sampleResultClass + " failed to instantiate, defaulted to " + SampleResult.class.getCanonicalName(), (Throwable)e1);
                res = new SampleResult();
            }
            catch (IllegalAccessException e1) {
                LOGGER.warn("Class " + this.sampleResultClass + " failed to instantiate, defaulted to " + SampleResult.class.getCanonicalName(), (Throwable)e1);
                res = new SampleResult();
            }
            res.setSampleLabel(this.getName());
            res.setSamplerData(((Object)((Object)this)).toString());
            res.setDataType("text");
            res.setContentType("text/plain");
            res.setDataEncoding("UTF-8");
            res.setSuccessful(true);
            LOGGER.debug("Current thread name: '" + this.getThreadName() + "', has browser: '" + this.getWebDriver() + "'");
            try {
                ScriptEngine scriptEngine = this.createScriptEngineWith(res);
                scriptEngine.eval(this.getScript());
                res.setResponseData(this.getWebDriver().getPageSource(), null);
                res.setURL(new URL(this.getWebDriver().getCurrentUrl()));
                res.setResponseCode(res.isSuccessful() ? "200" : "500");
                if (res.isSuccessful()) {
                    res.setResponseMessageOK();
                }
            }
            catch (Exception ex) {
                LOGGER.error(ex.getMessage());
                res.setResponseMessage(ex.getMessage());
                res.setResponseData((ex.toString() + "\r\n" + JMeterPluginsUtils.getStackTrace(ex)).getBytes());
                res.setResponseCode("500");
                res.setSuccessful(false);
                if (res.getStartTime() == 0L) {
                    res.sampleStart();
                }
                if (res.getEndTime() != 0L) break block8;
                res.sampleEnd();
            }
        }
        return res;
    }

    public String getScript() {
        return this.getPropertyAsString(SCRIPT, defaultScript);
    }

    public void setScript(String script) {
        this.setProperty(SCRIPT, script);
    }

    public String getParameters() {
        return this.getPropertyAsString(PARAMETERS);
    }

    public void setParameters(String parameters) {
        this.setProperty(PARAMETERS, parameters);
    }

    public String getScriptLanguage() {
        return this.getPropertyAsString(SCRIPT_LANGUAGE, DEFAULT_ENGINE);
    }

    public void setScriptLanguage(String lang) {
        this.setProperty(SCRIPT_LANGUAGE, lang);
    }

    private WebDriver getWebDriver() {
        return (WebDriver)this.getThreadContext().getVariables().getObject("Browser");
    }

    ScriptEngine createScriptEngineWith(SampleResult sampleResult) {
        ScriptEngine scriptEngine = this.scriptEngineManager.getEngineByName(this.getScriptLanguage());
        SimpleBindings engineBindings = new SimpleBindings();
        WebDriverScriptable scriptable = new WebDriverScriptable();
        scriptable.setName(this.getName());
        scriptable.setParameters(this.getParameters());
        scriptable.setLog(LOGGER);
        scriptable.setSampleResult(sampleResult);
        scriptable.setBrowser(this.getWebDriver());
        engineBindings.put("WDS", (Object)scriptable);
        scriptEngine.setBindings(engineBindings, 100);
        return scriptEngine;
    }
}

