/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.hadooputilities.hdfsoperations.gui;

import com.atlantbh.jmeter.plugins.hadooputilities.hdfsoperations.HdfsOperations;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.gui.JLabeledTextField;

public class HdfsOperationsGui
extends AbstractSamplerGui {
    private static final long serialVersionUID = 1L;
    private JLabeledTextField inputFilePathTextField = null;
    private JLabeledTextField outputFilePathTextField = null;
    private JLabeledTextField nameNodeTextField = null;

    public HdfsOperationsGui() {
        this.init();
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        VerticalPanel panel = new VerticalPanel();
        panel.setBorder(BorderFactory.createEtchedBorder());
        this.nameNodeTextField = new JLabeledTextField("Namenode");
        this.inputFilePathTextField = new JLabeledTextField("Input file destination");
        this.outputFilePathTextField = new JLabeledTextField("Output destination on HDFS");
        panel.add((Component)this.nameNodeTextField);
        panel.add((Component)this.inputFilePathTextField);
        panel.add((Component)this.outputFilePathTextField);
        this.add((Component)panel, "Center");
    }

    public void clearGui() {
        super.clearGui();
        this.nameNodeTextField.setText("");
        this.inputFilePathTextField.setText("");
        this.outputFilePathTextField.setText("");
    }

    public TestElement createTestElement() {
        HdfsOperations operations = new HdfsOperations();
        this.modifyTestElement((TestElement)operations);
        return operations;
    }

    public String getLabelResource() {
        return "HDFS operations";
    }

    public String getStaticLabel() {
        return "HDFS operations";
    }

    public void modifyTestElement(TestElement element) {
        super.configureTestElement(element);
        if (element instanceof HdfsOperations) {
            HdfsOperations operations = (HdfsOperations)element;
            operations.setNameNode(this.nameNodeTextField.getText());
            operations.setInputFilePath(this.inputFilePathTextField.getText());
            operations.setOutputFilePath(this.outputFilePathTextField.getText());
        }
    }

    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof HdfsOperations) {
            HdfsOperations operations = (HdfsOperations)element;
            this.nameNodeTextField.setText(operations.getNameNode());
            this.inputFilePathTextField.setText(operations.getInputFilePath());
            this.outputFilePathTextField.setText(operations.getOutputFilePath());
        }
    }
}

