/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.hbasecomponents.samplers;

import com.atlantbh.jmeter.plugins.hbasecomponents.config.HBaseConnection;
import com.atlantbh.jmeter.plugins.hbasecomponents.config.HBaseConnectionVariable;
import com.atlantbh.jmeter.plugins.hbasecomponents.config.JMeterVarParser;
import com.atlantbh.jmeter.plugins.hbasecomponents.utils.Row2XML;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Result;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterVariables;

public class HBaseRowkeySampler
extends AbstractSampler
implements Sampler {
    private static final long serialVersionUID = 6701023631583398986L;

    public SampleResult sample(Entry entry) {
        StringBuilder response = new StringBuilder();
        JMeterVariables vars = this.getThreadContext().getVariables();
        String rowKey = JMeterVarParser.parse(this.getRowKey(), vars);
        String tableName = JMeterVarParser.parse(this.gethBaseTable(), vars);
        String conString = JMeterVarParser.parse(this.getConnectionName(), vars);
        SampleResult result = new SampleResult();
        result.setSampleLabel(this.getName());
        result.setSamplerData("Executing:\n\thost : " + conString + "\n\ttable : " + tableName + "\n\trowkey : " + rowKey);
        result.sampleStart();
        result.setDataEncoding("UTF-8");
        result.setDataType("text/xml");
        response.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        response.append("<response>\n");
        try {
            HBaseConnectionVariable hbVar = HBaseConnection.getConnection(conString);
            if (hbVar == null) {
                this.makeError(result, "There is no connection with name '" + this.getConnectionName() + "'", false);
            } else {
                HTable hTable = (HTable)hbVar.getTable(tableName);
                Result res = hTable.get(new Get(rowKey.getBytes()));
                if (this.getLatestTimestampRows() == Boolean.TRUE) {
                    response.append(Row2XML.row2xmlStringLatest(res, (JMeterVariables)(this.getOmitVars() != false ? vars : null), 0));
                } else {
                    response.append(Row2XML.row2xmlstring(res, (JMeterVariables)(this.getOmitVars() != false ? vars : null), 0));
                }
                hbVar.putTable((HTableInterface)hTable);
                response.append("</response>\n");
                result.setResponseData(response.toString(), "UTF-8");
                result.setDataType("text");
                result.setSuccessful(true);
                result.sampleEnd();
            }
        }
        catch (Exception e) {
            this.makeError(result, "Failed to access database : host:[" + conString + "] table:[" + tableName + "] rowkey:[" + rowKey + "]", false);
        }
        return result;
    }

    public String getConnectionName() {
        return this.getPropertyAsString("HB_CONNAME");
    }

    public void setConnectionName(String connectionName) {
        this.setProperty("HB_CONNAME", connectionName);
    }

    public String gethBaseTable() {
        return this.getPropertyAsString("HB_TABLE");
    }

    public void sethBaseTable(String hBaseTable) {
        this.setProperty("HB_TABLE", hBaseTable);
    }

    public String getRowKey() {
        return this.getPropertyAsString("HB_ROWKEY");
    }

    public void setRowKey(String rowKey) {
        this.setProperty("HB_ROWKEY", rowKey);
    }

    public Boolean getOmitVars() {
        return this.getPropertyAsBoolean("HB_OMITVARS");
    }

    public void setOmitVars(Boolean value) {
        this.setProperty("HB_OMITVARS", value);
    }

    public Boolean getLatestTimestampRows() {
        return this.getPropertyAsBoolean("HB_LATEST_TIMESTAMP_ROWS");
    }

    public void setLatestTimestampRows(Boolean value) {
        this.setProperty("HB_LATEST_TIMESTAMP_ROWS", value);
    }

    private void makeError(SampleResult result, String msg, Boolean throwError) {
        result.setResponseMessage(msg);
        result.setSuccessful(false);
        result.sampleEnd();
        if (throwError.booleanValue()) {
            throw new RuntimeException(msg);
        }
    }
}

