/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.hbasecrud;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;

public class HbaseCrudHelper {
    private Configuration conf = null;
    private HTable hTable = null;
    private String responseMessage = "";
    private ArrayList<String> filterColumnFamilyList = new ArrayList();
    private ArrayList<String> fullColumnNamesList = new ArrayList();

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public void setResponseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
    }

    public void setConfiguration(String hbaseZK, String hbaseTable) throws IOException {
        this.conf = HBaseConfiguration.create();
        this.conf.set("hbase.zookeeper.quorum", hbaseZK);
        this.hTable = new HTable(this.conf, hbaseTable);
    }

    public void parseColumnFamilies(String columnFamilies) {
        String[] strTokens = columnFamilies.split(",");
        for (int i = 0; i < strTokens.length; ++i) {
            this.filterColumnFamilyList.add(strTokens[i]);
        }
    }

    private void parseFullColumnNamesList(String columnNames) {
        String[] strTokens = columnNames.split(",");
        for (int i = 0; i < strTokens.length; ++i) {
            this.fullColumnNamesList.add(strTokens[i]);
        }
    }

    private long getMostRecentTimestamp(String rowKey) throws IOException {
        long maxTimestamp = Long.MIN_VALUE;
        Get get = new Get(Bytes.toBytes((String)rowKey));
        Result result = this.hTable.get(get);
        if (this.filterColumnFamilyList.isEmpty()) {
            for (KeyValue kv : result.list()) {
                if (maxTimestamp >= kv.getTimestamp()) continue;
                maxTimestamp = kv.getTimestamp();
            }
        } else {
            for (KeyValue kv : result.list()) {
                byte[] bytes = kv.getFamily();
                String str = new String(bytes);
                if (this.filterColumnFamilyList.contains(str) || maxTimestamp >= kv.getTimestamp()) continue;
                maxTimestamp = kv.getTimestamp();
            }
        }
        return maxTimestamp;
    }

    public void addOrUpdateDataToHBase(String rowKey, String columnFamilyColumnQualifiers) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>();
        Put put = new Put(Bytes.toBytes((String)rowKey));
        this.parseFullColumnNamesList(columnFamilyColumnQualifiers);
        String response = "";
        long timestamp = this.getMostRecentTimestamp(rowKey);
        String[] columnFamilyColumnValueToken = null;
        String[] columnValueToken = null;
        try {
            for (int i = 0; i < this.fullColumnNamesList.size(); ++i) {
                columnFamilyColumnValueToken = this.fullColumnNamesList.get(i).split(":");
                columnValueToken = columnFamilyColumnValueToken[1].split("=");
                put.add(Bytes.toBytes((String)columnFamilyColumnValueToken[0]), Bytes.toBytes((String)columnValueToken[0]), Long.valueOf(timestamp).longValue(), Bytes.toBytes((String)columnValueToken[1]));
                puts.add(put);
                response = response + this.fullColumnNamesList.get(i) + " ";
            }
            this.hTable.put(puts);
            this.setResponseMessage("Added to POI:" + response);
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            this.hTable.close();
        }
    }

    public void deleteDataFromHbase(String rowKey, String columnFamilyColumnQualifiers) throws IOException {
        ArrayList<Delete> deletes = new ArrayList<Delete>();
        Delete delete = new Delete(Bytes.toBytes((String)rowKey));
        this.parseFullColumnNamesList(columnFamilyColumnQualifiers);
        long timestamp = this.getMostRecentTimestamp(rowKey);
        String[] columnFamilyColumnValueToken = null;
        String response = "";
        try {
            for (int i = 0; i < this.fullColumnNamesList.size(); ++i) {
                if (this.fullColumnNamesList.get(i).contains(":")) {
                    columnFamilyColumnValueToken = this.fullColumnNamesList.get(i).split(":");
                    delete.deleteColumn(Bytes.toBytes((String)columnFamilyColumnValueToken[0]), Bytes.toBytes((String)columnFamilyColumnValueToken[1]), Long.valueOf(timestamp).longValue());
                    response = response + this.fullColumnNamesList.get(i) + " ";
                } else {
                    delete.deleteFamily(Bytes.toBytes((String)this.fullColumnNamesList.get(i)), Long.valueOf(timestamp).longValue());
                    response = response + this.fullColumnNamesList.get(i) + " ";
                }
                deletes.add(delete);
            }
            this.hTable.delete(deletes);
            this.setResponseMessage("Deleted from POI: " + response);
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            this.hTable.close();
        }
    }
}

