/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.jmstools;

import com.atlantbh.jmeter.plugins.jmstools.BinaryMessageConverter;
import com.atlantbh.jmeter.plugins.jmstools.BinaryMessagepostProcessor;
import java.util.HashMap;
import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.protocol.java.sampler.JavaSamplerClient;
import org.apache.jmeter.protocol.java.sampler.JavaSamplerContext;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.qpid.client.AMQAnyDestination;
import org.apache.qpid.client.AMQConnectionFactory;
import org.apache.qpid.url.AMQBindingURL;
import org.apache.qpid.url.BindingURL;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessagePostProcessor;
import org.springframework.jms.support.converter.MessageConverter;

public class JmsUtil
implements JavaSamplerClient {
    public Arguments getDefaultParameters() {
        Arguments args = new Arguments();
        args.addArgument("connection.url", "");
        args.addArgument("binding.url", "");
        args.addArgument("message", "");
        args.addArgument("direction", "");
        args.addArgument("header.properties", "");
        args.addArgument("header.property.reference", "");
        args.addArgument("message.selector", "");
        args.addArgument("receive.timeout", "");
        return args;
    }

    public SampleResult runTest(JavaSamplerContext ctx) {
        SampleResult result = new SampleResult();
        result.setContentType("plain/text");
        result.setDataType("text");
        result.setDataEncoding("ISO-8859-1");
        String connectionUrl = ctx.getParameter("connection.url");
        String bindingUrl = ctx.getParameter("binding.url");
        String message = ctx.getParameter("message");
        if (connectionUrl == null || "".equals(connectionUrl)) {
            result.setSuccessful(false);
            result.setResponseMessage("Connection URL cannot be empty.");
            result.setResponseCode("0xDEAD");
        } else if (bindingUrl == null || "".equals(bindingUrl)) {
            result.setSuccessful(false);
            result.setResponseMessage("Binding URL cannot be empty.");
            result.setResponseCode("0xDEAD");
        } else {
            try {
                AMQConnectionFactory connectionFactory = new AMQConnectionFactory(connectionUrl);
                AMQBindingURL burl = new AMQBindingURL(bindingUrl);
                AMQAnyDestination destinationProducer = new AMQAnyDestination((BindingURL)burl);
                JmsTemplate sender = new JmsTemplate();
                sender.setConnectionFactory((ConnectionFactory)connectionFactory);
                sender.setDefaultDestination((Destination)destinationProducer);
                BinaryMessageConverter bmc = new BinaryMessageConverter();
                sender.setMessageConverter((MessageConverter)bmc);
                BinaryMessagepostProcessor postProcessor = new BinaryMessagepostProcessor();
                sender.setDeliveryMode(2);
                int rt = 30000;
                try {
                    rt = Integer.valueOf(ctx.getParameter("receive.timeout"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                sender.setReceiveTimeout((long)rt);
                String direction = ctx.getParameter("direction");
                if (direction == null || "".equals(direction)) {
                    direction = "send";
                }
                if (direction.toLowerCase().equals("send")) {
                    Map<String, String> mp = this.getMessageProperties(ctx.getParameter("header.properties"));
                    postProcessor.setMessageProperties(mp);
                    sender.convertAndSend((Object)message, (MessagePostProcessor)postProcessor);
                    result.setSuccessful(true);
                    result.setResponseMessage("Message sent.");
                } else if (direction.toLowerCase().equals("receive")) {
                    System.out.println("Receive");
                    String messageSelector = ctx.getParameter("message.selector");
                    System.out.println("Selector: " + messageSelector);
                    Object obj = null;
                    obj = messageSelector != null && !"".equals(messageSelector) ? sender.receiveSelectedAndConvert(messageSelector) : sender.receiveAndConvert();
                    if (obj != null) {
                        result.setSuccessful(true);
                        result.setResponseData(obj.toString().getBytes());
                        String paramName = ctx.getParameter("header.property.reference");
                        if (paramName != null && !"".equals(paramName)) {
                            JMeterUtils.setProperty((String)paramName, (String)this.concatProperties(bmc.getMessageProperties()));
                        }
                    } else {
                        result.setSuccessful(false);
                        result.setResponseData("Conection timeout".getBytes());
                    }
                } else {
                    result.setSuccessful(false);
                    result.setResponseMessage("Unknown direction.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                result.setSuccessful(false);
                result.setResponseMessage("Exception");
                result.setResponseData(e.getMessage().getBytes());
            }
        }
        return result;
    }

    private String concatProperties(Map<String, String> messageProperties) {
        String ret = "";
        if (messageProperties != null) {
            for (String key : messageProperties.keySet()) {
                ret = ret + key + "=" + messageProperties.get(key) + "&&";
            }
        }
        return ret;
    }

    private Map<String, String> getMessageProperties(String parameter) {
        if (parameter != null && !"".equals(parameter)) {
            String[] pairs;
            HashMap<String, String> ret = new HashMap<String, String>();
            for (String pair : pairs = parameter.split("&&")) {
                String[] parts = pair.split("=");
                if (parts.length < 2) continue;
                ret.put(parts[0], parts[1]);
            }
            return ret;
        }
        return new HashMap<String, String>();
    }

    public void setupTest(JavaSamplerContext arg0) {
    }

    public void teardownTest(JavaSamplerContext arg0) {
    }
}

