/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.oauth.gui;

import com.atlantbh.jmeter.plugins.oauth.OAuthSampler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledChoice;
import org.apache.jorphan.gui.JLabeledTextArea;
import org.apache.jorphan.gui.JLabeledTextField;

public class OAuthSamplerGui
extends AbstractSamplerGui {
    private static final long serialVersionUID = -5576774730632101012L;
    private JCheckBox useKeepAlive;
    private JCheckBox automaticRedirect;
    private JLabeledTextField consumerKey;
    private JLabeledTextField consumerSecret;
    private JLabeledTextArea body;
    private JLabeledTextArea headers;
    private JLabeledTextField hostBaseUrl;
    private JLabeledTextField resource;
    private JLabeledTextField port;
    private JLabeledChoice httpMethods;

    public OAuthSamplerGui() {
        this.init();
    }

    public String getLabelResource() {
        return "rest_sampler_title";
    }

    public String getStaticLabel() {
        return "OAuth Sampler";
    }

    public TestElement createTestElement() {
        OAuthSampler sampler = new OAuthSampler();
        this.modifyTestElement((TestElement)sampler);
        return sampler;
    }

    public void clear() {
        this.consumerKey.setText("");
        this.consumerSecret.setText("");
        this.httpMethods.setText("GET");
        this.hostBaseUrl.setText("");
        this.headers.setText("");
        this.resource.setText("");
        this.port.setText("8080");
        this.useKeepAlive.setSelected(true);
        this.automaticRedirect.setSelected(true);
        this.body.setText("");
    }

    public void modifyTestElement(TestElement s) {
        super.configureTestElement(s);
        if (s instanceof OAuthSampler) {
            OAuthSampler sampler = (OAuthSampler)s;
            sampler.setConsumerKey(this.consumerKey.getText());
            sampler.setConsumerSecret(this.consumerSecret.getText());
            sampler.setRequestBody(this.body.getText());
            sampler.setMethod(this.httpMethods.getText());
            sampler.setUseKeepAlive(this.useKeepAlive.isSelected());
            sampler.setAutoRedirects(this.automaticRedirect.isSelected());
            sampler.setHostBaseUrl(this.hostBaseUrl.getText());
            sampler.setResource(this.resource.getText());
            sampler.setPortNumber(this.port.getText());
            sampler.setRequestHeaders(this.headers.getText());
        }
    }

    public void clearGui() {
        super.clearGui();
        this.clear();
    }

    private JPanel getResourceConfigPanel() {
        this.consumerKey = new JLabeledTextField("Consumer Key", 25);
        this.consumerSecret = new JLabeledTextField("Consumer Secret", 25);
        this.automaticRedirect = new JCheckBox(JMeterUtils.getResString((String)"follow_redirects"));
        this.httpMethods = new JLabeledChoice("Method", new String[]{"GET", "POST", "PUT", "DELETE"});
        this.httpMethods.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JLabeledChoice c = (JLabeledChoice)e.getSource();
                String text = c.getText();
                if ("PUT".equals(text) || "POST".equals(text)) {
                    OAuthSamplerGui.this.automaticRedirect.setSelected(false);
                    OAuthSamplerGui.this.automaticRedirect.setEnabled(false);
                } else {
                    OAuthSamplerGui.this.automaticRedirect.setEnabled(true);
                }
            }
        });
        this.useKeepAlive = new JCheckBox(JMeterUtils.getResString((String)"use_keepalive"));
        this.hostBaseUrl = new JLabeledTextField("Base Url", 25);
        this.resource = new JLabeledTextField("Resource", 20);
        this.port = new JLabeledTextField("Port", 10);
        VerticalPanel resourceConfigPanel = new VerticalPanel();
        HorizontalPanel oAuthPanel = new HorizontalPanel();
        oAuthPanel.add((Component)this.consumerKey);
        oAuthPanel.add((Component)this.consumerSecret);
        HorizontalPanel panel1 = new HorizontalPanel();
        panel1.add((Component)this.httpMethods);
        panel1.add((Component)this.useKeepAlive);
        panel1.add((Component)this.automaticRedirect);
        HorizontalPanel panel2 = new HorizontalPanel();
        panel2.add((Component)this.hostBaseUrl);
        panel2.add((Component)this.port);
        HorizontalPanel panel3 = new HorizontalPanel();
        panel3.add((Component)this.resource);
        resourceConfigPanel.add((Component)panel1);
        resourceConfigPanel.add((Component)oAuthPanel);
        resourceConfigPanel.add((Component)panel2);
        resourceConfigPanel.add((Component)panel3);
        return resourceConfigPanel;
    }

    private JPanel getRequestPanel() {
        this.body = new JLabeledTextArea("Body");
        this.headers = new JLabeledTextArea("Headers");
        VerticalPanel panel = new VerticalPanel();
        panel.add((Component)this.headers, (Object)"North");
        panel.add((Component)this.body, (Object)"Center");
        return panel;
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        VerticalPanel panel = new VerticalPanel();
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.add((Component)this.getResourceConfigPanel(), (Object)"North");
        panel.add((Component)this.getRequestPanel(), (Object)"Center");
        this.add((Component)panel, "Center");
    }

    public void configure(TestElement el) {
        super.configure(el);
        OAuthSampler sampler = (OAuthSampler)el;
        this.consumerKey.setText(sampler.getConsumerKey());
        this.consumerSecret.setText(sampler.getConsumerSecret());
        this.body.setText(sampler.getRequestBody());
        this.headers.setText(sampler.getRequestHeaders());
        this.useKeepAlive.setSelected(sampler.getUseKeepAlive());
        this.automaticRedirect.setSelected(sampler.getAutoRedirects());
        this.httpMethods.setText(sampler.getMethod());
        this.resource.setText(sampler.getResource());
        this.port.setText(sampler.getPortNumber());
        this.hostBaseUrl.setText(sampler.getHostBaseUrl());
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }
}

