/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.MatteBorder;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.samplers.SampleSaveConfiguration;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.util.JMeterUtils;

public abstract class JMeterPluginsUtils {
    public static String PLUGINS_VERSION = "0.5.7 snapshot";
    private static String PLUGINS_PREFIX = "jp@gc - ";
    private static boolean prefixPlugins = true;
    public static final String WIKI_BASE = "http://code.google.com/p/jmeter-plugins/wiki/";

    public static String prefixLabel(String label) {
        return prefixPlugins ? PLUGINS_PREFIX + label : label;
    }

    public static String getStackTrace(Exception ex) {
        StackTraceElement[] stack = ex.getStackTrace();
        StringBuilder res = new StringBuilder();
        for (int n = 0; n < stack.length; ++n) {
            res.append("at ");
            res.append(stack[n].toString());
            res.append("\n");
        }
        return res.toString();
    }

    public static CollectionProperty tableModelRowsToCollectionProperty(PowerTableModel model, String propname) {
        CollectionProperty rows = new CollectionProperty(propname, new ArrayList());
        for (int row = 0; row < model.getRowCount(); ++row) {
            List<Object> item = JMeterPluginsUtils.getArrayListForArray(model.getRowData(row));
            rows.addItem(item);
        }
        return rows;
    }

    public static CollectionProperty tableModelRowsToCollectionPropertyEval(PowerTableModel model, String propname) {
        CollectionProperty rows = new CollectionProperty(propname, new ArrayList());
        for (int row = 0; row < model.getRowCount(); ++row) {
            List<Object> item = JMeterPluginsUtils.getArrayListForArrayEval(model.getRowData(row));
            rows.addItem(item);
        }
        return rows;
    }

    public static void collectionPropertyToTableModelRows(CollectionProperty prop, PowerTableModel model) {
        model.clearData();
        for (int rowN = 0; rowN < prop.size(); ++rowN) {
            ArrayList rowObject = (ArrayList)prop.get(rowN).getObjectValue();
            model.addRow(rowObject.toArray());
        }
        model.fireTableDataChanged();
    }

    public static void collectionPropertyToTableModelRows(CollectionProperty prop, PowerTableModel model, Class[] columnClasses) {
        model.clearData();
        for (int rowN = 0; rowN < prop.size(); ++rowN) {
            int i;
            ArrayList rowStrings = (ArrayList)prop.get(rowN).getObjectValue();
            ArrayList<Object> rowObject = new ArrayList<Object>(rowStrings.size());
            for (i = 0; i < columnClasses.length && i < rowStrings.size(); ++i) {
                rowObject.add(JMeterPluginsUtils.convertToClass((StringProperty)rowStrings.get(i), columnClasses[i]));
            }
            if (rowObject.size() < columnClasses.length) {
                for (i = rowObject.size(); i < columnClasses.length; ++i) {
                    rowObject.add(new Object());
                }
            }
            model.addRow(rowObject.toArray());
        }
        model.fireTableDataChanged();
    }

    @Deprecated
    public static CollectionProperty tableModelColsToCollectionProperty(PowerTableModel model, String propname) {
        CollectionProperty rows = new CollectionProperty(propname, new ArrayList());
        for (int colN = 0; colN < model.getColumnCount(); ++colN) {
            List item = model.getColumnData(model.getColumnName(colN));
            rows.addItem((Object)item);
        }
        return rows;
    }

    @Deprecated
    public static void collectionPropertyToTableModelCols(CollectionProperty prop, PowerTableModel model) {
        model.clearData();
        for (int colN = 0; colN < prop.size(); ++colN) {
            ArrayList rowObject = (ArrayList)prop.get(colN).getObjectValue();
            model.setColumnData(colN, (List)rowObject);
        }
        model.fireTableDataChanged();
    }

    private static List<Object> getArrayListForArray(Object[] rowData) {
        ArrayList<Object> res = new ArrayList<Object>();
        for (int n = 0; n < rowData.length; ++n) {
            res.add(rowData[n]);
        }
        return res;
    }

    private static List<Object> getArrayListForArrayEval(Object[] rowData) {
        ArrayList<Object> res = new ArrayList<Object>();
        for (int n = 0; n < rowData.length; ++n) {
            res.add(new CompoundVariable(rowData[n].toString()).execute());
        }
        return res;
    }

    public static String byteBufferToString(ByteBuffer buf) {
        byte[] dst = JMeterPluginsUtils.byteBufferToByteArray(buf);
        return new String(dst);
    }

    public static byte[] byteBufferToByteArray(ByteBuffer buf) {
        ByteBuffer str = buf.duplicate();
        str.rewind();
        byte[] dst = new byte[str.limit()];
        str.get(dst);
        return dst;
    }

    public static String replaceRNT(String str) {
        str = str.replaceAll("\\\\\\\\", "VERY BAD WAY");
        str = str.replaceAll("\\\\t", "\t");
        str = str.replaceAll("\\\\n", "\n");
        str = str.replaceAll("\\\\r", "\r");
        str = str.replaceAll("VERY BAD WAY", "\\\\");
        return str;
    }

    public static String getWikiLinkText(String wikiPage) {
        if (!Desktop.isDesktopSupported()) {
            return "Plugin help available here: http://code.google.com/p/jmeter-plugins/wiki/" + wikiPage;
        }
        return "";
    }

    private static Object convertToClass(StringProperty value, Class aClass) {
        if (Boolean.class.equals((Object)aClass)) {
            return Boolean.valueOf(value.getStringValue());
        }
        return value;
    }

    public static Component addHelpLinkToPanel(Container panel, String helpPage) {
        if (!Desktop.isDesktopSupported()) {
            return panel;
        }
        JLabel icon = new JLabel();
        icon.setIcon(new ImageIcon(JMeterPluginsUtils.class.getResource("/kg/apc/jmeter/vizualizers/information.png")));
        JLabel link = new JLabel("Help on this plugin");
        link.setForeground(Color.blue);
        link.setFont(link.getFont().deriveFont(0));
        link.setCursor(new Cursor(12));
        link.addMouseListener(new URIOpener(WIKI_BASE + helpPage + "?utm_source=jmeter&utm_medium=helplink&utm_campaign=" + helpPage));
        MatteBorder border = BorderFactory.createMatteBorder(0, 0, 1, 0, Color.blue);
        link.setBorder(border);
        JLabel version = new JLabel("v" + PLUGINS_VERSION);
        version.setFont(version.getFont().deriveFont(0).deriveFont(11.0f));
        version.setForeground(Color.GRAY);
        Container innerPanel = JMeterPluginsUtils.findComponentWithBorder((JComponent)panel, EtchedBorder.class);
        JPanel panelLink = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 0);
        panelLink.add((Component)icon, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 3, 0);
        panelLink.add((Component)link, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        panelLink.add((Component)version, gridBagConstraints);
        if (innerPanel != null) {
            innerPanel.add(panelLink);
        } else {
            panel.add(panelLink);
        }
        return panel;
    }

    private static Container findComponentWithBorder(JComponent panel, Class<?> aClass) {
        for (int n = 0; n < panel.getComponentCount(); ++n) {
            if (!(panel.getComponent(n) instanceof JComponent)) continue;
            JComponent comp = (JComponent)panel.getComponent(n);
            if (comp.getBorder() != null && aClass.isAssignableFrom(comp.getBorder().getClass())) {
                return comp;
            }
            Container con = JMeterPluginsUtils.findComponentWithBorder(comp, aClass);
            if (con == null) continue;
            return con;
        }
        return null;
    }

    public static void doBestCSVSetup(SampleSaveConfiguration conf) {
        conf.setAsXml(false);
        conf.setFieldNames(true);
        conf.setFormatter(null);
        conf.setSamplerData(false);
        conf.setRequestHeaders(false);
        conf.setFileName(false);
        conf.setIdleTime(false);
        conf.setSuccess(true);
        conf.setMessage(true);
        conf.setEncoding(false);
        conf.setThreadCounts(true);
        conf.setFieldNames(true);
        conf.setAssertions(false);
        conf.setResponseData(false);
        conf.setSubresults(false);
        conf.setLatency(true);
        conf.setLabel(true);
        conf.setThreadName(false);
        conf.setBytes(true);
        conf.setHostname(false);
        conf.setAssertionResultsFailureMessage(false);
        conf.setResponseHeaders(false);
        conf.setUrl(false);
        conf.setTime(true);
        conf.setTimestamp(true);
        conf.setCode(true);
        conf.setDataType(false);
        conf.setSampleCount(false);
    }

    public static void openInBrowser(String string) {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(new URI(string));
            }
            catch (IOException ex) {
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    public static float getFloatFromString(String stringValue, float defaultValue) {
        float ret;
        if (stringValue != null) {
            try {
                ret = Float.valueOf(stringValue).floatValue();
            }
            catch (NumberFormatException ex) {
                ret = defaultValue;
            }
        } else {
            ret = defaultValue;
        }
        return ret;
    }

    public static int getSecondsForShortString(String string) {
        int res = 0;
        string = string.trim();
        String curNum = "";
        for (int n = 0; n < string.length(); ++n) {
            int mul;
            String c = String.valueOf(string.charAt(n));
            if (c.matches("\\d")) {
                curNum = curNum + c;
                continue;
            }
            switch (c.charAt(0)) {
                case 'S': 
                case 's': {
                    mul = 1;
                    break;
                }
                case 'M': 
                case 'm': {
                    mul = 60;
                    break;
                }
                case 'H': 
                case 'h': {
                    mul = 3600;
                    break;
                }
                case 'D': 
                case 'd': {
                    mul = 86400;
                    break;
                }
                default: {
                    throw new NumberFormatException("Shorthand string does not allow using '" + c + "'");
                }
            }
            res += Integer.parseInt(curNum) * mul;
            curNum = "";
        }
        if (!curNum.isEmpty()) {
            res += Integer.parseInt(curNum);
        }
        return res;
    }

    static {
        String prefixPluginsCfg = JMeterUtils.getProperty((String)"jmeterPlugin.prefixPlugins");
        if (prefixPluginsCfg != null) {
            prefixPlugins = "true".equalsIgnoreCase(prefixPluginsCfg.trim());
        }
    }

    private static class URIOpener
    extends MouseAdapter {
        private final String uri;

        public URIOpener(String aURI) {
            this.uri = aURI;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if ((e.getModifiers() & 0x10) == 16) {
                JMeterPluginsUtils.openInBrowser(this.uri);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

