/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.config;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.config.TestCsvFileAction;
import kg.apc.jmeter.config.VariablesFromCSV;
import kg.apc.jmeter.gui.BrowseAction;
import kg.apc.jmeter.gui.GuiBuilderHelper;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.testelement.TestElement;

public class VariablesFromCSVGui
extends AbstractConfigGui {
    public static final String WIKIPAGE = "VariablesFromCSV";
    private JTextField fileName;
    private JTextField variablePrefix;
    private JTextField separator;
    private JCheckBox storeSysProp;
    private JButton browseButton;
    private JButton checkButton;
    private JTextArea checkInfo;

    public VariablesFromCSVGui() {
        this.init();
        this.initFields();
    }

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel("Variables From CSV File");
    }

    public String getLabelResource() {
        return ((Object)((Object)this)).getClass().getCanonicalName();
    }

    public void configure(TestElement element) {
        super.configure(element);
        this.fileName.setText(element.getPropertyAsString("filename"));
        this.variablePrefix.setText(element.getPropertyAsString("variablesPrefix"));
        this.separator.setText(element.getPropertyAsString("delimiter"));
        this.storeSysProp.setSelected(element.getPropertyAsBoolean("storeSysProp"));
    }

    public TestElement createTestElement() {
        VariablesFromCSV varsCsv = new VariablesFromCSV();
        this.modifyTestElement((TestElement)varsCsv);
        varsCsv.setComment(JMeterPluginsUtils.getWikiLinkText(WIKIPAGE));
        return varsCsv;
    }

    public void modifyTestElement(TestElement te) {
        this.configureTestElement(te);
        if (te instanceof VariablesFromCSV) {
            VariablesFromCSV varsCsv = (VariablesFromCSV)te;
            varsCsv.setFileName(this.fileName.getText());
            varsCsv.setVariablePrefix(this.variablePrefix.getText());
            varsCsv.setSeparator(this.separator.getText());
            varsCsv.setStoreAsSystemProperty(this.storeSysProp.isSelected());
        }
    }

    public void clearGui() {
        super.clearGui();
        this.initFields();
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(JMeterPluginsUtils.addHelpLinkToPanel(this.makeTitlePanel(), WIKIPAGE), "North");
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.anchor = 24;
        GridBagConstraints editConstraints = new GridBagConstraints();
        editConstraints.anchor = 23;
        editConstraints.weightx = 1.0;
        editConstraints.fill = 2;
        this.addToPanel(mainPanel, labelConstraints, 0, 0, new JLabel("CSV File: ", 4));
        this.fileName = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 0, this.fileName);
        this.browseButton = new JButton("Browse...");
        this.addToPanel(mainPanel, labelConstraints, 2, 0, this.browseButton);
        GuiBuilderHelper.strechItemToComponent(this.fileName, this.browseButton);
        editConstraints.insets = new Insets(2, 0, 0, 0);
        labelConstraints.insets = new Insets(2, 0, 0, 0);
        this.browseButton.addActionListener(new BrowseAction(this.fileName));
        this.addToPanel(mainPanel, labelConstraints, 0, 1, new JLabel(" Variable prefix: ", 4));
        this.variablePrefix = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 1, this.variablePrefix);
        this.addToPanel(mainPanel, labelConstraints, 0, 2, new JLabel("Separator (use '\\t' for tab): ", 4));
        this.separator = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 2, this.separator);
        this.addToPanel(mainPanel, labelConstraints, 0, 3, new JLabel("Store variables also in System Properties: ", 4));
        this.storeSysProp = new JCheckBox();
        this.addToPanel(mainPanel, editConstraints, 1, 3, this.storeSysProp);
        editConstraints.insets = new Insets(4, 0, 0, 0);
        labelConstraints.insets = new Insets(4, 0, 0, 2);
        this.checkButton = new JButton("Test CSV File");
        this.addToPanel(mainPanel, labelConstraints, 0, 4, this.checkButton);
        labelConstraints.insets = new Insets(4, 0, 0, 0);
        this.checkInfo = new JTextArea();
        this.addToPanel(mainPanel, editConstraints, 1, 4, GuiBuilderHelper.getTextAreaScrollPaneContainer(this.checkInfo, 10));
        this.checkButton.addActionListener(new TestCsvFileAction(this.fileName, this.variablePrefix, this.separator, this.checkInfo));
        this.checkInfo.setEditable(false);
        this.checkInfo.setOpaque(false);
        JPanel container = new JPanel(new BorderLayout());
        container.add((Component)mainPanel, "North");
        this.add(container, "Center");
    }

    private void addToPanel(JPanel panel, GridBagConstraints constraints, int col, int row, JComponent component) {
        constraints.gridx = col;
        constraints.gridy = row;
        panel.add((Component)component, constraints);
    }

    private void initFields() {
        this.variablePrefix.setText("");
        this.fileName.setText("");
        this.checkInfo.setText("");
        this.separator.setText(";");
        this.storeSysProp.setSelected(false);
    }
}

