/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.functions;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kg.apc.jmeter.modifiers.FifoMap;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;

public class FifoPut
extends AbstractFunction {
    private static final List<String> desc = new LinkedList<String>();
    private static final String KEY = "__fifoPut";
    private Object[] values;

    public FifoPut() {
        FifoMap.getInstance().clear();
    }

    public synchronized String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        String fifoName = ((CompoundVariable)this.values[0]).execute();
        String value = ((CompoundVariable)this.values[1]).execute();
        try {
            FifoMap.getInstance().put(fifoName, value);
        }
        catch (InterruptedException ex) {
            value = "INTERRUPTED";
        }
        return value;
    }

    public synchronized void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkMinParameterCount(parameters, 2);
        this.values = parameters.toArray();
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    static {
        desc.add("Queue name to put value");
        desc.add("String value to put into FIFO queue");
    }
}

