/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.graphs;

import java.awt.Color;
import java.util.Iterator;
import java.util.concurrent.ConcurrentSkipListMap;
import kg.apc.charting.AbstractGraphPanelChartElement;
import kg.apc.charting.AbstractGraphRow;
import kg.apc.jmeter.graphs.AbstractGraphPanelVisualizer;
import org.apache.jmeter.samplers.SampleResult;

public abstract class AbstractVsThreadVisualizer
extends AbstractGraphPanelVisualizer {
    private ConcurrentSkipListMap<String, AbstractGraphRow> state = new ConcurrentSkipListMap();
    private static final int PRECISION_MS = 500;

    public AbstractVsThreadVisualizer() {
        this.graphPanel.getGraphObject().setForcedMinX(0L);
        this.graphPanel.getGraphObject().setxAxisLabel("Number of active threads");
    }

    @Override
    protected void setExtraChartSettings() {
        this.graphPanel.getGraphObject().getChartSettings().enableDrawCurrentX();
    }

    private void addCount(String tgName, int nbThread, long time) {
        AbstractGraphRow row = this.state.get(tgName);
        if (row == null) {
            row = this.getNewRow(this.state, 0, tgName, 0, false, false, false, false, Color.BLACK, false);
            this.state.put(tgName, row);
        }
        row.add(time - time % 500L, nbThread);
    }

    protected int getCurrentThreadCount(SampleResult res) {
        int ret;
        if (this.state.size() > 1) {
            ret = 0;
            Iterator<AbstractGraphRow> iter = this.state.values().iterator();
            while (iter.hasNext()) {
                AbstractGraphPanelChartElement element = iter.next().getLowerElement(res.getStartTime());
                if (element == null) continue;
                ret = (int)((double)ret + element.getValue());
            }
        } else {
            ret = res.getGroupThreads();
        }
        return ret;
    }

    public void add(SampleResult res) {
        String threadName = res.getThreadName();
        threadName = threadName.lastIndexOf(" ") >= 0 ? threadName.substring(0, threadName.lastIndexOf(" ")) : threadName;
        this.addCount(threadName, res.getGroupThreads(), res.getStartTime());
    }

    @Override
    public void clearData() {
        super.clearData();
        this.state.clear();
    }
}

