/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.modifiers;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.processor.PreProcessor;
import org.apache.jmeter.protocol.http.parser.HtmlParsingUtils;
import org.apache.jmeter.protocol.http.sampler.HTTPSampleResult;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.util.ConversionUtils;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AnchorModifier
extends AbstractTestElement
implements PreProcessor,
Serializable {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final Random rand = new Random();
    private static final Boolean visited = true;
    private static final Boolean notvisited = false;
    List<String> marks = new LinkedList<String>();
    private HashMap<String, HTTPSamplerBase> URLs = new HashMap();
    private String baseDomain;

    public void process() {
        JMeterContext context = this.getThreadContext();
        Sampler sam = context.getCurrentSampler();
        SampleResult res = context.getPreviousResult();
        if (res == null || !(sam instanceof HTTPSamplerBase) || !(res instanceof HTTPSampleResult)) {
            log.info("Can't apply HTML Link Parser when the previous sampler run is not an HTTP Request.");
            return;
        }
        HTTPSamplerBase sampler = (HTTPSamplerBase)sam;
        HTTPSampleResult result = (HTTPSampleResult)res;
        String responseText = result.getResponseDataAsString();
        int index = responseText.indexOf("<");
        if (index == -1) {
            index = 0;
        }
        Document html = (Document)HtmlParsingUtils.getDOM((String)responseText.substring(index));
        this.addAnchorUrls(html, result, sampler);
        this.addFormUrls(html, result, sampler);
        this.addFramesetUrls(html, result, sampler);
        if (this.hasNotVisited()) {
            HTTPSamplerBase url = this.getNextLink();
            sampler.setDomain(url.getDomain());
            sampler.setPath(url.getPath());
            if (url.getMethod().equals("POST")) {
                PropertyIterator iter = sampler.getArguments().iterator();
                while (iter.hasNext()) {
                    Argument arg = (Argument)iter.next().getObjectValue();
                    this.modifyArgument(arg, url.getArguments());
                }
            } else {
                sampler.setArguments(url.getArguments());
            }
            sampler.setProtocol(url.getProtocol());
        } else {
            log.info("No further matches found, stopping test");
            context.getEngine().askThreadsToStop();
        }
    }

    private void modifyArgument(Argument arg, Arguments args) {
        Argument replacementArg;
        ArrayList<Argument> possibleReplacements = new ArrayList<Argument>();
        PropertyIterator iter = args.iterator();
        while (iter.hasNext()) {
            replacementArg = (Argument)iter.next().getObjectValue();
            try {
                if (!HtmlParsingUtils.isArgumentMatched((Argument)replacementArg, (Argument)arg)) continue;
                possibleReplacements.add(replacementArg);
            }
            catch (Exception ex) {
                log.error("Problem adding Argument", (Throwable)ex);
            }
        }
        if (possibleReplacements.size() > 0) {
            replacementArg = (Argument)possibleReplacements.get(rand.nextInt(possibleReplacements.size()));
            arg.setName(replacementArg.getName());
            arg.setValue(replacementArg.getValue());
            args.removeArgument(replacementArg);
        }
    }

    private void addFormUrls(Document html, HTTPSampleResult result, HTTPSamplerBase config) {
        NodeList rootList = html.getChildNodes();
        LinkedList urls = new LinkedList();
        for (int x = 0; x < rootList.getLength(); ++x) {
            urls.addAll(HtmlParsingUtils.createURLFromForm((Node)rootList.item(x), (URL)result.getURL()));
        }
        for (HTTPSamplerBase newUrl : urls) {
            newUrl.setMethod("POST");
            if (!HtmlParsingUtils.isAnchorMatched((HTTPSamplerBase)newUrl, (HTTPSamplerBase)config)) continue;
            this.addURL(newUrl);
        }
    }

    private void addAnchorUrls(Document html, HTTPSampleResult result, HTTPSamplerBase config) {
        String base = "";
        NodeList baseList = html.getElementsByTagName("base");
        if (baseList.getLength() > 0) {
            base = baseList.item(0).getAttributes().getNamedItem("href").getNodeValue();
        }
        NodeList nodeList = html.getElementsByTagName("a");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String hrefStr;
            Node tempNode = nodeList.item(i);
            NamedNodeMap nnm = tempNode.getAttributes();
            Node namedItem = nnm.getNamedItem("href");
            if (namedItem == null || (hrefStr = namedItem.getNodeValue()).startsWith("javascript:")) continue;
            try {
                HTTPSamplerBase newUrl = HtmlParsingUtils.createUrlFromAnchor((String)hrefStr, (URL)ConversionUtils.makeRelativeURL((URL)result.getURL(), (String)base));
                newUrl.setMethod("GET");
                if (log.isDebugEnabled()) {
                    // empty if block
                }
                this.addURL(newUrl);
                continue;
            }
            catch (MalformedURLException e) {
                log.warn("Bad URL " + e);
            }
        }
    }

    private void addFramesetUrls(Document html, HTTPSampleResult result, HTTPSamplerBase config) {
        String base = "";
        NodeList baseList = html.getElementsByTagName("base");
        if (baseList.getLength() > 0) {
            base = baseList.item(0).getAttributes().getNamedItem("href").getNodeValue();
        }
        NodeList nodeList = html.getElementsByTagName("frame");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node tempNode = nodeList.item(i);
            NamedNodeMap nnm = tempNode.getAttributes();
            Node namedItem = nnm.getNamedItem("src");
            if (namedItem == null) continue;
            String hrefStr = namedItem.getNodeValue();
            try {
                HTTPSamplerBase newUrl = HtmlParsingUtils.createUrlFromAnchor((String)hrefStr, (URL)ConversionUtils.makeRelativeURL((URL)result.getURL(), (String)base));
                newUrl.setMethod("GET");
                if (!HtmlParsingUtils.isAnchorMatched((HTTPSamplerBase)newUrl, (HTTPSamplerBase)config)) continue;
                this.addURL(newUrl);
                continue;
            }
            catch (MalformedURLException e) {
                log.warn("Bad URL " + e);
            }
        }
    }

    private boolean hasNotVisited() {
        return !this.marks.isEmpty();
    }

    private HTTPSamplerBase getNextLink() {
        String key = this.marks.get(this.marks.size() - 1);
        if (log.isDebugEnabled()) {
            log.debug("Not visited key: " + key);
        }
        this.marks.remove(key);
        return this.URLs.get(key);
    }

    private void addURL(HTTPSamplerBase newUrl) {
        if (this.baseDomain == null) {
            this.baseDomain = newUrl.getDomain();
            if (log.isDebugEnabled()) {
                log.debug("Base domain: " + this.baseDomain);
            }
        }
        if (!newUrl.getDomain().equals(this.baseDomain)) {
            if (log.isDebugEnabled()) {
                // empty if block
            }
            return;
        }
        String key = this.getKeyForURL(newUrl);
        if (!this.URLs.containsKey(key)) {
            this.URLs.put(key, newUrl);
            this.marks.add(key);
            if (log.isDebugEnabled()) {
                log.debug("Put: " + newUrl.toString());
            }
        } else if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    private String getKeyForURL(HTTPSamplerBase newUrl) {
        PropertyIterator it = newUrl.propertyIterator();
        String ret = "";
        while (it.hasNext()) {
            JMeterProperty p = it.next();
            ret = ret + p.getName() + "=" + p.getStringValue() + "\t";
        }
        return ret;
    }
}

