/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.perfmon;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import kg.apc.jmeter.perfmon.AgentConnector;
import kg.apc.jmeter.perfmon.PerfMonAgentConnector;
import kg.apc.jmeter.perfmon.PerfMonSampleGenerator;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class OldAgentConnector
implements PerfMonAgentConnector {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static boolean isTranslate = false;
    AgentConnector connector;
    private boolean metricWasSet = false;

    public OldAgentConnector(String host, int port) {
        this.connector = new AgentConnector(host, port);
    }

    @Override
    public void connect() throws IOException {
        Socket sock = this.createSocket(this.connector.getHost(), this.connector.getPort());
        this.connector.connect(sock);
    }

    @Override
    public void disconnect() {
        this.connector.disconnect();
    }

    protected Socket createSocket(String host, int port) throws UnknownHostException, IOException {
        return new Socket(host, port);
    }

    private String getLabel(boolean translate) {
        String hostName = translate ? this.connector.getRemoteServerName() : this.connector.getHost();
        return hostName + " - " + AgentConnector.metrics.get(this.connector.getMetricType());
    }

    @Override
    public void generateSamples(PerfMonSampleGenerator collector) throws IOException {
        String label = this.getLabel(isTranslate);
        switch (this.connector.getMetricType()) {
            case 0: {
                collector.generateSample(100.0 * this.connector.getCpu(), label + ", %");
                break;
            }
            case 1: {
                collector.generateSample((double)this.connector.getMem() / 1048576.0, label + ", MB");
                break;
            }
            case 2: {
                collector.generate2Samples(this.connector.getSwap(), label + " page in", label + " page out");
                break;
            }
            case 3: {
                collector.generate2Samples(this.connector.getDisksIO(), label + " reads", label + " writes");
                break;
            }
            case 4: {
                collector.generate2Samples(this.connector.getNetIO(), label + " recv, KB", label + " sent, KB", 1024.0);
                break;
            }
            default: {
                throw new IOException("Unknown metric index: " + this.connector.getMetricType());
            }
        }
    }

    @Override
    public void addMetric(String metric, String params, String label) {
        if (this.metricWasSet) {
            throw new RuntimeException("Old connector don't support multiple metrics");
        }
        this.metricWasSet = true;
        this.connector.setMetricType(metric);
    }

    static {
        String cfgTranslateHostName = JMeterUtils.getProperty((String)"jmeterPlugin.perfmon.translateHostName");
        if (cfgTranslateHostName != null) {
            isTranslate = "true".equalsIgnoreCase(cfgTranslateHostName.trim());
        }
    }
}

