/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.reporters;

import java.io.PrintStream;
import java.io.Serializable;
import org.apache.jmeter.JMeter;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.util.NoThreadClone;
import org.apache.jmeter.reporters.AbstractListenerElement;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestListener;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class ConsoleStatusLogger
extends AbstractListenerElement
implements SampleListener,
Serializable,
NoThreadClone,
TestListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private PrintStream out;
    private long cur = 0L;
    private int count;
    private int threads;
    private int sumRTime;
    private int sumLatency;
    private int errors;
    private long begin;

    public synchronized void sampleOccurred(SampleEvent se) {
        long sec = System.currentTimeMillis() / 1000L;
        if (sec != this.cur && this.count > 0) {
            if (this.cur == 0L) {
                this.begin = sec;
            }
            log.debug(this.cur + " " + this.begin);
            this.flush(sec - this.begin);
            this.cur = sec;
        }
        SampleResult res = se.getResult();
        ++this.count;
        this.sumRTime = (int)((long)this.sumRTime + res.getTime());
        this.sumLatency = (int)((long)this.sumLatency + res.getLatency());
        this.errors += res.isSuccessful() ? 0 : 1;
        this.threads = res.getAllThreads();
    }

    private void flush(long sec) {
        String msg = '#' + Long.toString(sec) + '\t';
        msg = msg + "Threads: " + this.threads + '/' + JMeterContextService.getTotalThreads() + '\t';
        msg = msg + "Samples: " + this.count + '\t';
        msg = msg + "Latency: " + this.sumLatency / (this.count > 0 ? this.count : 1) + '\t';
        msg = msg + "Resp.Time: " + this.sumRTime / (this.count > 0 ? this.count : 1) + '\t';
        msg = msg + "Errors: " + this.errors;
        this.out.println(msg);
        this.count = 0;
        this.sumRTime = 0;
        this.sumLatency = 0;
        this.errors = 0;
    }

    public void sampleStarted(SampleEvent se) {
    }

    public void sampleStopped(SampleEvent se) {
    }

    public void testStarted() {
        this.out = JMeter.isNonGUI() ? System.out : new JMeterLoggerOutputStream(log);
        this.cur = 0L;
    }

    public void testStarted(String string) {
        this.testStarted();
    }

    public void testEnded() {
    }

    public void testEnded(String string) {
    }

    public void testIterationStart(LoopIterationEvent lie) {
    }

    private class JMeterLoggerOutputStream
    extends PrintStream {
        public JMeterLoggerOutputStream(Logger log) {
            super(System.out);
        }

        @Override
        public void println(String msg) {
            log.info(msg);
        }
    }
}

