/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.samplers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.gui.BrowseAction;
import kg.apc.jmeter.gui.GuiBuilderHelper;
import kg.apc.jmeter.samplers.HTTPRawSampler;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class HTTPRawSamplerGui
extends AbstractSamplerGui {
    public static final String WIKIPAGE = "RawRequest";
    private static final Logger log = LoggingManager.getLoggerForClass();
    private JTextField hostName;
    private JTextField port;
    private JTextField timeout;
    private JCheckBox keepAlive;
    private JCheckBox parseResult;
    private JTextArea requestData;
    private JTextField fileName;
    private JButton browseButton;

    public HTTPRawSamplerGui() {
        this.init();
        this.initFields();
    }

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel("HTTP Raw Request");
    }

    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof HTTPRawSampler) {
            HTTPRawSampler rawSampler = (HTTPRawSampler)element;
            this.hostName.setText(rawSampler.getHostName());
            this.port.setText(rawSampler.getPort());
            this.timeout.setText(rawSampler.getTimeout());
            this.keepAlive.setSelected(rawSampler.isUseKeepAlive());
            this.requestData.setText(rawSampler.getRequestData());
            this.parseResult.setSelected(rawSampler.isParseResult());
            this.fileName.setText(rawSampler.getFileToSend());
        }
    }

    public TestElement createTestElement() {
        HTTPRawSampler sampler = new HTTPRawSampler();
        this.modifyTestElement((TestElement)sampler);
        sampler.setComment(JMeterPluginsUtils.getWikiLinkText(WIKIPAGE));
        return sampler;
    }

    public void modifyTestElement(TestElement sampler) {
        super.configureTestElement(sampler);
        if (sampler instanceof HTTPRawSampler) {
            HTTPRawSampler rawSampler = (HTTPRawSampler)sampler;
            rawSampler.setHostName(this.hostName.getText());
            rawSampler.setPort(this.port.getText());
            rawSampler.setUseKeepAlive(this.keepAlive.isSelected());
            rawSampler.setTimeout(this.timeout.getText());
            rawSampler.setRequestData(this.transformCRLF(this.requestData.getText()));
            rawSampler.setFileToSend(this.fileName.getText());
            rawSampler.setParseResult(this.parseResult.isSelected());
        }
    }

    private String transformCRLF(String str) {
        return str.replace("\r\n", "\n").replace("\r", "").replace("\n", "\r\n");
    }

    public void clearGui() {
        super.clearGui();
        this.initFields();
    }

    public String getLabelResource() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(JMeterPluginsUtils.addHelpLinkToPanel(this.makeTitlePanel(), WIKIPAGE), "North");
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.anchor = 24;
        GridBagConstraints editConstraints = new GridBagConstraints();
        editConstraints.anchor = 23;
        editConstraints.weightx = 1.0;
        editConstraints.fill = 2;
        this.addToPanel(mainPanel, labelConstraints, 0, 1, new JLabel("Hostname: ", 4));
        this.hostName = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 1, this.hostName);
        editConstraints.insets = new Insets(2, 0, 0, 0);
        labelConstraints.insets = new Insets(2, 0, 0, 0);
        this.addToPanel(mainPanel, labelConstraints, 0, 2, new JLabel("TCP Port: ", 4));
        this.port = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 2, this.port);
        this.addToPanel(mainPanel, labelConstraints, 0, 3, new JLabel("Timeout: ", 4));
        this.timeout = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 3, this.timeout);
        this.addToPanel(mainPanel, labelConstraints, 0, 4, new JLabel("Keep connection open: ", 4));
        this.keepAlive = new JCheckBox();
        this.addToPanel(mainPanel, editConstraints, 1, 4, this.keepAlive);
        this.addToPanel(mainPanel, labelConstraints, 0, 5, new JLabel("Request Data: ", 4));
        editConstraints.fill = 1;
        this.requestData = new JTextArea();
        this.addToPanel(mainPanel, editConstraints, 1, 5, GuiBuilderHelper.getTextAreaScrollPaneContainer(this.requestData, 20));
        editConstraints.insets = new Insets(4, 0, 0, 0);
        labelConstraints.insets = new Insets(4, 0, 0, 0);
        this.addToPanel(mainPanel, labelConstraints, 0, 6, new JLabel("Data file path: ", 4));
        this.fileName = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 6, this.fileName);
        this.browseButton = new JButton("Browse...");
        this.addToPanel(mainPanel, labelConstraints, 2, 6, this.browseButton);
        GuiBuilderHelper.strechItemToComponent(this.fileName, this.browseButton);
        this.browseButton.addActionListener(new BrowseAction(this.fileName));
        editConstraints.insets = new Insets(2, 0, 0, 0);
        labelConstraints.insets = new Insets(2, 0, 0, 0);
        this.addToPanel(mainPanel, labelConstraints, 0, 7, new JLabel("Parse result as HTTP: ", 4));
        this.parseResult = new JCheckBox();
        this.addToPanel(mainPanel, editConstraints, 1, 7, this.parseResult);
        JPanel container = new JPanel(new BorderLayout());
        container.add((Component)mainPanel, "North");
        this.add(container, "Center");
    }

    private void addToPanel(JPanel panel, GridBagConstraints constraints, int col, int row, JComponent component) {
        constraints.gridx = col;
        constraints.gridy = row;
        panel.add((Component)component, constraints);
    }

    private void initFields() {
        this.hostName.setText("localhost");
        this.port.setText("80");
        this.timeout.setText("0");
        this.keepAlive.setSelected(false);
        this.requestData.setText("GET / HTTP/1.0\r\nHost: localhost\r\nConnection: close\r\n\r\n");
        this.parseResult.setSelected(true);
        this.fileName.setText("");
    }
}

