/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.vizualizers;

import kg.apc.charting.AbstractGraphRow;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.graphs.AbstractOverTimeVisualizer;
import kg.apc.jmeter.vizualizers.JSettingsPanel;
import org.apache.jmeter.samplers.SampleResult;

public class BytesThroughputOverTimeGui
extends AbstractOverTimeVisualizer {
    public BytesThroughputOverTimeGui() {
        this.setGranulation(1000);
        this.graphPanel.getGraphObject().setYAxisLabel("Bytes /sec");
    }

    private void addBytes(String threadGroupName, long time, int value) {
        AbstractGraphRow row = (AbstractGraphRow)this.model.get(threadGroupName);
        if (row == null) {
            row = this.getNewRow(this.model, 4, threadGroupName, 2, false, false, false, true, true);
        }
        if (this.getGranulation() > 0) {
            row.add(time, (double)value * 1000.0 / (double)this.getGranulation());
        }
    }

    public String getLabelResource() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel("Bytes Throughput Over Time");
    }

    @Override
    public void add(SampleResult res) {
        if (!this.isSampleIncluded(res)) {
            return;
        }
        super.add(res);
        this.addBytes("Bytes Received per Second", this.normalizeTime(res.getEndTime()), res.getBytes());
        int sentBytes = 0;
        String samplerData = res.getSamplerData();
        if (samplerData != null) {
            sentBytes = samplerData.length();
        }
        this.addBytes("Bytes Sent per Second", this.normalizeTime(res.getEndTime()), sentBytes);
        this.updateGui(null);
    }

    @Override
    protected JSettingsPanel createSettingsPanel() {
        return new JSettingsPanel(this, 2843);
    }

    @Override
    public String getWikiPage() {
        return "BytesThroughput";
    }
}

