/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.vizualizers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kg.apc.charting.AbstractGraphRow;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.graphs.CompositeNotifierInterface;
import kg.apc.jmeter.graphs.GraphRendererInterface;
import kg.apc.jmeter.vizualizers.CompositeGraphGui;
import kg.apc.jmeter.vizualizers.CompositeModel;

public class JCompositeRowsSelectorPanel
extends JPanel
implements GraphRendererInterface,
CompositeNotifierInterface {
    private CompositeModel compositeModel;
    private DefaultMutableTreeNode root1;
    private DefaultMutableTreeNode root2;
    private DefaultTreeModel model1;
    private DefaultTreeModel model2;
    private Icon folderIcon = new ImageIcon(JCompositeRowsSelectorPanel.class.getResource("folder.png"));
    private Icon folderLinkIcon = new ImageIcon(JCompositeRowsSelectorPanel.class.getResource("folderLink.png"));
    private Icon leafIcon = new ImageIcon(JCompositeRowsSelectorPanel.class.getResource("treeLeaf.png"));
    private static String tree1RootName = "Test Plan";
    private static String tree2RootName = "Composite Graph";
    private CompositeGraphGui gui;
    private JButton jButtonAdd;
    private JButton jButtonRemove;
    private JLabel jLabelGraph1;
    private JLabel jLabelGraph2;
    private JLabel jLabelLogo;
    private JLabel jLabelPreview;
    private JPanel jPanel1;
    private JPanel jPanelButtons;
    private JPanel jPanelGraphPreview;
    private JPanel jPanelLogo;
    private JPanel jPanelMain;
    private JPanel jPanelRowsTable;
    private JScrollPane jScrollPaneGraph;
    private JScrollPane jScrollPaneGraph1;
    private JTree jTreeGraph1;
    private JTree jTreeGraph2;

    public JCompositeRowsSelectorPanel(CompositeModel compositeModel, CompositeGraphGui gui) {
        this.compositeModel = compositeModel;
        this.gui = gui;
        this.initComponents();
        this.root1 = new DefaultMutableTreeNode(tree1RootName, true);
        this.model1 = new DefaultTreeModel(this.root1);
        this.root2 = new DefaultMutableTreeNode(tree2RootName, true);
        this.model2 = new DefaultTreeModel(this.root2);
        this.jTreeGraph1.setModel(this.model1);
        this.jTreeGraph2.setModel(this.model2);
        DefaultTreeCellRenderer renderer1 = new DefaultTreeCellRenderer();
        renderer1.setOpenIcon(this.folderIcon);
        renderer1.setClosedIcon(this.folderIcon);
        renderer1.setLeafIcon(this.leafIcon);
        this.jTreeGraph1.setCellRenderer(renderer1);
        DefaultTreeCellRenderer renderer2 = new DefaultTreeCellRenderer();
        renderer2.setOpenIcon(this.folderLinkIcon);
        renderer2.setClosedIcon(this.folderLinkIcon);
        renderer2.setLeafIcon(this.leafIcon);
        this.jTreeGraph2.setCellRenderer(renderer2);
    }

    public void updateGraph() {
        this.gui.updateGui();
    }

    public Iterator<String[]> getItems() {
        ConcurrentLinkedQueue<String[]> tmp = new ConcurrentLinkedQueue<String[]>();
        for (int i = 0; i < this.root2.getChildCount(); ++i) {
            TreeNode nodeChart = this.root2.getChildAt(i);
            String chart = nodeChart.toString();
            for (int j = 0; j < nodeChart.getChildCount(); ++j) {
                String[] item = new String[]{chart, nodeChart.getChildAt(j).toString()};
                tmp.add(item);
            }
        }
        return tmp.iterator();
    }

    private void expandAll(JTree tree, boolean expand) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        this.expandAll(tree, new TreePath(root), expand);
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    private boolean isNodeContained(String nodeName, DefaultMutableTreeNode root) {
        Enumeration<TreeNode> children = root.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            if (!nodeName.equals(child.toString())) continue;
            return true;
        }
        return false;
    }

    private DefaultMutableTreeNode getNode(String nodeName, DefaultMutableTreeNode root) {
        if (root != null) {
            Enumeration<TreeNode> children = root.children();
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                if (!nodeName.equals(child.toString())) continue;
                return child;
            }
        }
        return null;
    }

    public void clearData() {
        this.gui.updateGui();
    }

    private synchronized void updateTree() {
        TreePath selection = this.jTreeGraph1.getSelectionPath();
        boolean chartsUpdated = false;
        for (int i = 0; i < this.root1.getChildCount(); ++i) {
            TreeNode node = this.root1.getChildAt(i);
            if (this.compositeModel.containsVisualizer(node.toString())) continue;
            chartsUpdated = true;
            this.model1.removeNodeFromParent((MutableTreeNode)node);
            --i;
        }
        Iterator<String> chartsIter = this.compositeModel.getVizualizerNamesIterator();
        while (chartsIter.hasNext()) {
            String chartName = chartsIter.next();
            if (!this.isNodeContained(chartName, this.root1)) {
                chartsUpdated = true;
                DefaultMutableTreeNode node1 = new DefaultMutableTreeNode(chartName, true);
                this.root1.add(node1);
                Iterator<AbstractGraphRow> rowsIter = this.compositeModel.getRowsIterator(chartName);
                while (rowsIter.hasNext()) {
                    AbstractGraphRow row = rowsIter.next();
                    node1.add(new DefaultMutableTreeNode(row.getLabel(), false));
                }
                continue;
            }
            Iterator<AbstractGraphRow> rowsIter = this.compositeModel.getRowsIterator(chartName);
            DefaultMutableTreeNode chartNode1 = this.getNode(chartName, this.root1);
            while (rowsIter.hasNext()) {
                String rowName = rowsIter.next().getLabel();
                if (this.isNodeContained(rowName, chartNode1)) continue;
                chartsUpdated = true;
                chartNode1.add(new DefaultMutableTreeNode(rowName, false));
            }
        }
        if (chartsUpdated) {
            this.model1.nodeStructureChanged(this.root1);
            this.expandAll(this.jTreeGraph1, true);
            this.jTreeGraph1.setSelectionPath(selection);
        }
    }

    private void initComponents() {
        this.jPanelLogo = new JPanel();
        this.jLabelLogo = new JLabel();
        this.jPanel1 = new JPanel();
        this.jPanelMain = new JPanel();
        this.jPanelRowsTable = new JPanel();
        this.jLabelGraph1 = new JLabel();
        this.jLabelGraph2 = new JLabel();
        this.jScrollPaneGraph1 = new JScrollPane();
        this.jTreeGraph1 = new JTree();
        this.jScrollPaneGraph = new JScrollPane();
        this.jTreeGraph2 = new JTree();
        this.jPanelButtons = new JPanel();
        this.jButtonAdd = new JButton();
        this.jButtonRemove = new JButton();
        this.jPanelGraphPreview = new JPanel();
        this.jLabelPreview = new JLabel();
        this.setBorder(BorderFactory.createBevelBorder(1));
        this.setLayout(new BorderLayout());
        this.jPanelLogo.setLayout(new GridBagLayout());
        this.jLabelLogo.setHorizontalAlignment(4);
        this.jLabelLogo.setIcon(new ImageIcon(this.getClass().getResource("/kg/apc/jmeter/vizualizers/logoSimple.png")));
        this.jLabelLogo.setCursor(new Cursor(12));
        this.jLabelLogo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JCompositeRowsSelectorPanel.this.jLabelLogoMouseClicked(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.jPanelLogo.add((Component)this.jLabelLogo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanelLogo.add((Component)this.jPanel1, gridBagConstraints);
        this.add((Component)this.jPanelLogo, "Last");
        this.jPanelMain.setLayout(new GridBagLayout());
        this.jPanelRowsTable.setMaximumSize(new Dimension(206, 23));
        this.jPanelRowsTable.setPreferredSize(new Dimension(206, 23));
        this.jPanelRowsTable.setLayout(new GridBagLayout());
        this.jLabelGraph1.setText("Available Sources:");
        this.jLabelGraph1.setMaximumSize(new Dimension(120, 14));
        this.jLabelGraph1.setMinimumSize(new Dimension(120, 14));
        this.jLabelGraph1.setPreferredSize(new Dimension(120, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanelRowsTable.add((Component)this.jLabelGraph1, gridBagConstraints);
        this.jLabelGraph2.setText("Composed Graph:");
        this.jLabelGraph2.setMaximumSize(new Dimension(120, 14));
        this.jLabelGraph2.setMinimumSize(new Dimension(120, 14));
        this.jLabelGraph2.setPreferredSize(new Dimension(120, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.jPanelRowsTable.add((Component)this.jLabelGraph2, gridBagConstraints);
        this.jScrollPaneGraph1.setMaximumSize(new Dimension(72, 64));
        this.jScrollPaneGraph1.setMinimumSize(new Dimension(72, 64));
        this.jScrollPaneGraph1.setPreferredSize(new Dimension(72, 64));
        this.jTreeGraph1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JCompositeRowsSelectorPanel.this.jTreeGraph1MouseClicked(evt);
            }
        });
        this.jScrollPaneGraph1.setViewportView(this.jTreeGraph1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanelRowsTable.add((Component)this.jScrollPaneGraph1, gridBagConstraints);
        this.jTreeGraph2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JCompositeRowsSelectorPanel.this.jTreeGraph2MouseClicked(evt);
            }
        });
        this.jScrollPaneGraph.setViewportView(this.jTreeGraph2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.jPanelRowsTable.add((Component)this.jScrollPaneGraph, gridBagConstraints);
        this.jPanelButtons.setFocusable(false);
        this.jPanelButtons.setLayout(new GridLayout(0, 1, 0, 6));
        this.jButtonAdd.setIcon(new ImageIcon(this.getClass().getResource("/kg/apc/jmeter/vizualizers/rightArrow.png")));
        this.jButtonAdd.setFocusable(false);
        this.jButtonAdd.setMaximumSize(new Dimension(30, 25));
        this.jButtonAdd.setMinimumSize(new Dimension(30, 25));
        this.jButtonAdd.setPreferredSize(new Dimension(30, 25));
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCompositeRowsSelectorPanel.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jPanelButtons.add(this.jButtonAdd);
        this.jButtonRemove.setIcon(new ImageIcon(this.getClass().getResource("/kg/apc/jmeter/vizualizers/leftArrow.png")));
        this.jButtonRemove.setFocusable(false);
        this.jButtonRemove.setMaximumSize(new Dimension(30, 25));
        this.jButtonRemove.setMinimumSize(new Dimension(30, 25));
        this.jButtonRemove.setPreferredSize(new Dimension(30, 25));
        this.jButtonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCompositeRowsSelectorPanel.this.jButtonRemoveActionPerformed(evt);
            }
        });
        this.jPanelButtons.add(this.jButtonRemove);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.jPanelRowsTable.add((Component)this.jPanelButtons, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelMain.add((Component)this.jPanelRowsTable, gridBagConstraints);
        this.jPanelGraphPreview.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanelMain.add((Component)this.jPanelGraphPreview, gridBagConstraints);
        this.jLabelPreview.setText("Preview:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanelMain.add((Component)this.jLabelPreview, gridBagConstraints);
        this.add((Component)this.jPanelMain, "Center");
    }

    public void addItemsToComposite(String testplan, String row) {
        Object[] path = new String[]{tree2RootName, testplan, row};
        TreePath[] tp = new TreePath[]{new TreePath(path)};
        this.addItemsToComposite(tp);
    }

    private void addItemsToComposite(TreePath[] paths) {
        for (int i = 0; i < paths.length; ++i) {
            DefaultMutableTreeNode chartNode;
            String chartName;
            if (paths[i].getPath().length == 1) continue;
            if (paths[i].getPath().length == 2) {
                DefaultMutableTreeNode chartNode2;
                chartName = paths[i].getPath()[1].toString();
                chartNode = this.getNode(chartName, this.root1);
                if (!this.isNodeContained(chartName, this.root2)) {
                    chartNode2 = new DefaultMutableTreeNode(chartName, true);
                    this.root2.add(chartNode2);
                } else {
                    chartNode2 = this.getNode(chartName, this.root2);
                }
                for (int n = 0; n < chartNode.getChildCount(); ++n) {
                    if (this.isNodeContained(chartNode.getChildAt(n).toString(), chartNode2)) continue;
                    chartNode2.add(new DefaultMutableTreeNode(chartNode.getChildAt(n).toString(), false));
                    this.model2.nodeStructureChanged(this.root2);
                    this.expandAll(this.jTreeGraph2, true);
                }
                continue;
            }
            if (paths[i].getPath().length != 3) continue;
            chartName = paths[i].getPath()[1].toString();
            if (!this.isNodeContained(chartName, this.root2)) {
                chartNode = new DefaultMutableTreeNode(chartName, true);
                this.root2.add(chartNode);
            } else {
                chartNode = this.getNode(chartName, this.root2);
            }
            if (this.isNodeContained(paths[i].getPath()[2].toString(), chartNode)) continue;
            chartNode.add(new DefaultMutableTreeNode(paths[i].getPath()[2].toString(), false));
            this.model2.nodeStructureChanged(this.root2);
            this.expandAll(this.jTreeGraph2, true);
        }
        this.updateGraph();
    }

    private void removeItemFromComposite(TreePath[] paths) {
        for (int i = 0; i < paths.length; ++i) {
            if (paths[i].getPath().length == 1) continue;
            if (paths[i].getPath().length == 2) {
                DefaultMutableTreeNode node = this.getNode(paths[i].getPath()[1].toString(), this.root2);
                this.model2.removeNodeFromParent(node);
                continue;
            }
            if (paths[i].getPath().length != 3) continue;
            DefaultMutableTreeNode chartNode = this.getNode(paths[i].getPath()[1].toString(), this.root2);
            DefaultMutableTreeNode rowNode = this.getNode(paths[i].getPath()[2].toString(), chartNode);
            if (rowNode != null) {
                this.model2.removeNodeFromParent(rowNode);
            }
            if (chartNode == null || chartNode.getChildCount() != 0) continue;
            this.model2.removeNodeFromParent(chartNode);
        }
        this.model2.nodeStructureChanged(this.root2);
        this.expandAll(this.jTreeGraph2, true);
        this.updateGraph();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        TreePath[] paths = this.jTreeGraph1.getSelectionPaths();
        if (paths != null) {
            this.addItemsToComposite(paths);
        }
    }

    private void jButtonRemoveActionPerformed(ActionEvent evt) {
        TreePath[] paths = this.jTreeGraph2.getSelectionPaths();
        if (paths != null) {
            this.removeItemFromComposite(paths);
        }
    }

    private void jTreeGraph1MouseClicked(MouseEvent evt) {
        TreePath[] paths;
        if (evt.getClickCount() == 2 && (paths = this.jTreeGraph1.getSelectionPaths()) != null && paths.length == 1 && paths[0].getPath().length == 3) {
            this.addItemsToComposite(paths);
        }
    }

    private void jTreeGraph2MouseClicked(MouseEvent evt) {
        TreePath[] paths;
        if (evt.getClickCount() == 2 && (paths = this.jTreeGraph2.getSelectionPaths()) != null && paths.length == 1 && paths[0].getPath().length == 3) {
            this.removeItemFromComposite(paths);
        }
    }

    private void jLabelLogoMouseClicked(MouseEvent evt) {
        if ((evt.getModifiers() & 0x10) == 16) {
            JMeterPluginsUtils.openInBrowser("http://code.google.com/p/jmeter-plugins/?utm_source=jmeter&utm_medium=logolink&utm_campaign=" + this.gui.getWikiPage());
        }
    }

    @Override
    public JPanel getGraphDisplayPanel() {
        return this.jPanelGraphPreview;
    }

    @Override
    public boolean isPreview() {
        return true;
    }

    @Override
    public void refresh() {
        this.updateTree();
    }
}

