@file:Suppress("unused")

package com.paymentpage.msdk.core

import android.content.Context
import android.content.res.Resources
import android.os.Build
import android.os.LocaleList
import androidx.startup.Initializer
import io.ktor.client.engine.*
import io.ktor.client.engine.okhttp.*
import io.ktor.util.*
import java.util.*

internal actual fun getSystemTimeInMillis(): Long = System.currentTimeMillis()

internal actual fun getDeviceId(): String? {
    return (Build.BOARD.length % 10).toString() +
            (Build.BRAND.length % 10).toString() +
            (Build.DEVICE.length % 10).toString() +
            (Build.DISPLAY.length % 10).toString() +
            (Build.HOST.length % 10).toString() +
            Build.ID +
            (Build.MANUFACTURER.length % 10).toString() +
            (Build.MODEL.length % 10).toString() +
            (Build.PRODUCT.length % 10).toString() +
            (Build.TAGS.length % 10).toString() +
            (Build.TYPE.length % 10).toString() +
            (Build.USER.length % 10).toString()
}

internal actual  fun getAppBundleId(): String? = appContext?.packageName

@OptIn(InternalAPI::class)
actual val defaultPlatformEngine: HttpClientEngine = OkHttpEngine(config = OkHttpConfig())

internal var appContext: Context? = null

internal class ContextInitializer : Initializer<Context> {
    override fun create(context: Context): Context =
        context.applicationContext.also { appContext = it }

    override fun dependencies(): List<Class<out Initializer<*>>> = emptyList()
}

internal actual fun UserAgentData?.getXUserAgent(): String {
    val version = this?.applicationInfo?.version
    return "ecommpaySDK; ${platformType().name}; ${Build.VERSION.RELEASE}; ${Build.MODEL}; mobile SDK; ${BuildKonfig.version}${if (!version.isNullOrEmpty()) ",${version}" else ""}"
}

internal actual fun UserAgentData?.getXLanguage(): String = getSystemLocale()
internal actual fun UserAgentData?.getAcceptLanguage() = acceptLanguages()


private fun getSystemLocale() =
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N)
        LocaleList.getDefault().get(0).language
    else
        Locale.getDefault().language


internal fun acceptLanguages(): String {
    return if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
        val languages = mutableListOf<String>()
        val locales = Resources.getSystem().configuration.locales
        (0 until locales.size()).forEach { i ->
            val tag = locales.get(i).toLanguageTag()
            languages.add(tag.split("-")[0])
        }

        languages.joinToString(",")
    } else
        Locale.getDefault().language
}
