/*
 * Decompiled with CFR 0.152.
 */
package com.paymentpage.msdk.core.domain.entities;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017R\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001e\u0010\f\u001a\u0004\u0018\u00010\u0006X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\r\u0010\b\"\u0004\b\u000e\u0010\nR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\bR\u0011\u0010\u0011\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\b\u00a8\u0006\u0019"}, d2={"Lcom/paymentpage/msdk/core/domain/entities/SdkExpiry;", "", "text", "", "(Ljava/lang/String;)V", "_month", "", "get_month$MsdkCore_release", "()Ljava/lang/Integer;", "set_month$MsdkCore_release", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "_year", "get_year$MsdkCore_release", "set_year$MsdkCore_release", "month", "getMonth", "stringValue", "getStringValue", "()Ljava/lang/String;", "year", "getYear", "isMoreThanNow", "", "isValid", "MsdkCore_release"})
public final class SdkExpiry {
    @Nullable
    private Integer _month;
    @Nullable
    private Integer _year;

    public SdkExpiry(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String value = StringsKt.replace$default((String)text, (String)"/", (String)"", (boolean)false, (int)4, null);
        try {
            String month = StringsKt.substring((String)value, (IntRange)new IntRange(0, Math.min(value.length() - 1, 1)));
            this._month = Integer.parseInt(month);
        }
        catch (Exception month) {
            // empty catch block
        }
        try {
            String year = "";
            if (value.length() > 2) {
                year = StringsKt.substring((String)value, (IntRange)new IntRange(2, Math.min(value.length() - 1, 3)));
            }
            this._year = Integer.parseInt(year);
        }
        catch (Exception exception) {
        }
    }

    @Nullable
    public final Integer get_month$MsdkCore_release() {
        return this._month;
    }

    public final void set_month$MsdkCore_release(@Nullable Integer n) {
        this._month = n;
    }

    @Nullable
    public final Integer get_year$MsdkCore_release() {
        return this._year;
    }

    public final void set_year$MsdkCore_release(@Nullable Integer n) {
        this._year = n;
    }

    @Nullable
    public final Integer getMonth() {
        return this._month;
    }

    @Nullable
    public final Integer getYear() {
        return this._year;
    }

    @NotNull
    public final String getStringValue() {
        Object object;
        if (this._month == null) {
            object = "";
        } else {
            Integer n = this._month;
            Intrinsics.checkNotNull((Object)n);
            object = n < 10 ? "0" + this._month : String.valueOf(this._month);
        }
        String monthString = object;
        String yearString = this._year == null ? "" : String.valueOf(this._year);
        return monthString + "/" + yearString;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isValid() {
        IntRange intRange = new IntRange(1, 12);
        Integer n = this._month;
        if (n == null) return false;
        if (!intRange.contains(n.intValue())) return false;
        boolean bl = true;
        if (!bl) return false;
        Integer n2 = this._year;
        if (n2 == null) return false;
        int n3 = n2;
        if (n3 <= 0) return false;
        return true;
    }

    public final boolean isMoreThanNow() {
        Instant currentMoment = Clock.System.INSTANCE.now();
        LocalDateTime datetimeInSystemZone = TimeZoneKt.toLocalDateTime((Instant)currentMoment, (TimeZone)TimeZone.Companion.currentSystemDefault());
        int currentTotalMonth = 12 * datetimeInSystemZone.getYear() + datetimeInSystemZone.getMonthNumber();
        Integer n = this._year;
        Integer n2 = this._month;
        int sdkTotalMonth = 12 * (2000 + (n != null ? n : 0)) + (n2 != null ? n2 : 0);
        return sdkTotalMonth >= currentTotalMonth;
    }
}

