/*
 * Decompiled with CFR 0.152.
 */
package com.paymentpage.msdk.core.domain.entities.payment;

import com.paymentpage.msdk.core.domain.entities.payment.PaymentFlow;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u0086\u0081\u0002\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001eB\u001d\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001d\u00a8\u0006\u001f"}, d2={"Lcom/paymentpage/msdk/core/domain/entities/payment/PaymentStatus;", "", "values", "", "", "isFinal", "", "(Ljava/lang/String;ILjava/util/List;Z)V", "()Z", "getValues", "()Ljava/util/List;", "groupStatus", "Lcom/paymentpage/msdk/core/domain/entities/payment/PaymentFlow;", "PROCESSING", "AWAITING_REDIRECT_RESULT", "AWAITING_3DS_RESULT", "AWAITING_CAPTURE", "CANCELED", "SUCCESS", "DECLINE", "AWAITING_CUSTOMER", "AWAITING_CLARIFICATION", "REFUND_PROCESSING", "REVERSAL_PROCESSING", "REFUND_REVERSAL_PROCESSING", "REFUNDED", "REVERSED", "PARTIALLY_REFUNDED", "AWAITING_CONFIRMATION", "UNKNOWN", "Companion", "MsdkCore_release"})
public final class PaymentStatus
extends Enum<PaymentStatus> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final List<String> values;
    private final boolean isFinal;
    public static final /* enum */ PaymentStatus PROCESSING;
    public static final /* enum */ PaymentStatus AWAITING_REDIRECT_RESULT;
    public static final /* enum */ PaymentStatus AWAITING_3DS_RESULT;
    public static final /* enum */ PaymentStatus AWAITING_CAPTURE;
    public static final /* enum */ PaymentStatus CANCELED;
    public static final /* enum */ PaymentStatus SUCCESS;
    public static final /* enum */ PaymentStatus DECLINE;
    public static final /* enum */ PaymentStatus AWAITING_CUSTOMER;
    public static final /* enum */ PaymentStatus AWAITING_CLARIFICATION;
    public static final /* enum */ PaymentStatus REFUND_PROCESSING;
    public static final /* enum */ PaymentStatus REVERSAL_PROCESSING;
    public static final /* enum */ PaymentStatus REFUND_REVERSAL_PROCESSING;
    public static final /* enum */ PaymentStatus REFUNDED;
    public static final /* enum */ PaymentStatus REVERSED;
    public static final /* enum */ PaymentStatus PARTIALLY_REFUNDED;
    public static final /* enum */ PaymentStatus AWAITING_CONFIRMATION;
    public static final /* enum */ PaymentStatus UNKNOWN;
    private static final /* synthetic */ PaymentStatus[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private PaymentStatus(List<String> values, boolean isFinal) {
        this.values = values;
        this.isFinal = isFinal;
    }

    @NotNull
    public final List<String> getValues() {
        return this.values;
    }

    public final boolean isFinal() {
        return this.isFinal;
    }

    @NotNull
    public final PaymentFlow groupStatus() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> PaymentFlow.SUCCESS;
            case 10, 11 -> PaymentFlow.PROCESSING;
            case 12 -> PaymentFlow.D3S;
            case 13 -> PaymentFlow.TRY_AGAIN;
            case 14 -> PaymentFlow.DECLINE;
            case 15 -> PaymentFlow.CLARIFICATION;
            default -> PaymentFlow.FAIL;
        };
    }

    public static PaymentStatus[] values() {
        return (PaymentStatus[])$VALUES.clone();
    }

    public static PaymentStatus valueOf(String value) {
        return Enum.valueOf(PaymentStatus.class, value);
    }

    @NotNull
    public static EnumEntries<PaymentStatus> getEntries() {
        return $ENTRIES;
    }

    static {
        Object[] objectArray = new String[]{"processing", "external processing"};
        PROCESSING = new PaymentStatus(CollectionsKt.listOf((Object[])objectArray), false);
        AWAITING_REDIRECT_RESULT = new PaymentStatus(CollectionsKt.listOf((Object)"awaiting redirect result"), false);
        AWAITING_3DS_RESULT = new PaymentStatus(CollectionsKt.listOf((Object)"awaiting 3ds result"), false);
        AWAITING_CAPTURE = new PaymentStatus(CollectionsKt.listOf((Object)"awaiting capture"), true);
        CANCELED = new PaymentStatus(CollectionsKt.listOf((Object)"canceled"), true);
        SUCCESS = new PaymentStatus(CollectionsKt.listOf((Object)"success"), true);
        DECLINE = new PaymentStatus(CollectionsKt.listOf((Object)"decline"), true);
        AWAITING_CUSTOMER = new PaymentStatus(CollectionsKt.listOf((Object)"awaiting customer"), true);
        AWAITING_CLARIFICATION = new PaymentStatus(CollectionsKt.listOf((Object)"awaiting clarification"), false);
        REFUND_PROCESSING = new PaymentStatus(CollectionsKt.listOf((Object)"refund processing"), true);
        REVERSAL_PROCESSING = new PaymentStatus(CollectionsKt.listOf((Object)"reversal processing"), true);
        REFUND_REVERSAL_PROCESSING = new PaymentStatus(CollectionsKt.listOf((Object)"refund reversal processing"), true);
        REFUNDED = new PaymentStatus(CollectionsKt.listOf((Object)"refunded"), true);
        REVERSED = new PaymentStatus(CollectionsKt.listOf((Object)"reversed"), true);
        PARTIALLY_REFUNDED = new PaymentStatus(CollectionsKt.listOf((Object)"partially refunded"), true);
        AWAITING_CONFIRMATION = new PaymentStatus(CollectionsKt.listOf((Object)"awaiting confirmation"), true);
        UNKNOWN = new PaymentStatus(CollectionsKt.emptyList(), false);
        $VALUES = paymentStatusArray = new PaymentStatus[]{PaymentStatus.PROCESSING, PaymentStatus.AWAITING_REDIRECT_RESULT, PaymentStatus.AWAITING_3DS_RESULT, PaymentStatus.AWAITING_CAPTURE, PaymentStatus.CANCELED, PaymentStatus.SUCCESS, PaymentStatus.DECLINE, PaymentStatus.AWAITING_CUSTOMER, PaymentStatus.AWAITING_CLARIFICATION, PaymentStatus.REFUND_PROCESSING, PaymentStatus.REVERSAL_PROCESSING, PaymentStatus.REFUND_REVERSAL_PROCESSING, PaymentStatus.REFUNDED, PaymentStatus.REVERSED, PaymentStatus.PARTIALLY_REFUNDED, PaymentStatus.AWAITING_CONFIRMATION, PaymentStatus.UNKNOWN};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/paymentpage/msdk/core/domain/entities/payment/PaymentStatus$Companion;", "", "()V", "from", "Lcom/paymentpage/msdk/core/domain/entities/payment/PaymentStatus;", "status", "", "MsdkCore_release"})
    @SourceDebugExtension(value={"SMAP\nPayment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Payment.kt\ncom/paymentpage/msdk/core/domain/entities/payment/PaymentStatus$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1#2:90\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final PaymentStatus from(@NotNull String status2) {
            PaymentStatus paymentStatus;
            block1: {
                Intrinsics.checkNotNullParameter((Object)status2, (String)"status");
                PaymentStatus[] paymentStatusArray = PaymentStatus.values();
                int n = paymentStatusArray.length;
                for (int i = 0; i < n; ++i) {
                    PaymentStatus paymentStatus2;
                    PaymentStatus it = paymentStatus2 = paymentStatusArray[i];
                    boolean bl = false;
                    if (!it.getValues().contains(status2)) continue;
                    paymentStatus = paymentStatus2;
                    break block1;
                }
                paymentStatus = null;
            }
            return paymentStatus;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PaymentStatus.values().length];
            try {
                nArray[PaymentStatus.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentStatus.REFUND_PROCESSING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentStatus.REVERSAL_PROCESSING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentStatus.REFUND_REVERSAL_PROCESSING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentStatus.REFUNDED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentStatus.REVERSED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentStatus.PARTIALLY_REFUNDED.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentStatus.AWAITING_CAPTURE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentStatus.AWAITING_CONFIRMATION.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentStatus.PROCESSING.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentStatus.AWAITING_REDIRECT_RESULT.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentStatus.AWAITING_3DS_RESULT.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentStatus.AWAITING_CUSTOMER.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentStatus.DECLINE.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentStatus.AWAITING_CLARIFICATION.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

