/*
 * Decompiled with CFR 0.152.
 */
package com.paymentpage.msdk.core.domain.interactors.pay.handlers;

import com.paymentpage.msdk.core.base.Request;
import com.paymentpage.msdk.core.base.Response;
import com.paymentpage.msdk.core.base.exceptions.PaymentRequestTypeNotExistException;
import com.paymentpage.msdk.core.data.repository.pay.PayRepository;
import com.paymentpage.msdk.core.data.repository.session.SessionRepository;
import com.paymentpage.msdk.core.domain.entities.customer.CustomerFieldValue;
import com.paymentpage.msdk.core.domain.entities.sale.SaleResponse;
import com.paymentpage.msdk.core.domain.interactors.pay.applePay.ApplePayAuthRequest;
import com.paymentpage.msdk.core.domain.interactors.pay.applePay.ApplePaySaleRequest;
import com.paymentpage.msdk.core.domain.interactors.pay.applePay.ApplePayVerifyRequest;
import com.paymentpage.msdk.core.domain.interactors.pay.card.auth.CardAuthRequest;
import com.paymentpage.msdk.core.domain.interactors.pay.card.auth.CardAuthTokenizeRequest;
import com.paymentpage.msdk.core.domain.interactors.pay.card.auth.SavedCardAuthRequest;
import com.paymentpage.msdk.core.domain.interactors.pay.card.sale.CardSaleTokenizeRequest;
import com.paymentpage.msdk.core.domain.interactors.pay.card.sale.NewCardSaleRequest;
import com.paymentpage.msdk.core.domain.interactors.pay.card.sale.SavedCardSaleRequest;
import com.paymentpage.msdk.core.domain.interactors.pay.card.tokenize.CardTokenizeRequest;
import com.paymentpage.msdk.core.domain.interactors.pay.card.verify.CardVerifyRequest;
import com.paymentpage.msdk.core.domain.interactors.pay.googlePay.GooglePayAuthRequest;
import com.paymentpage.msdk.core.domain.interactors.pay.googlePay.GooglePaySaleRequest;
import com.paymentpage.msdk.core.domain.interactors.pay.googlePay.GooglePayVerifyRequest;
import com.paymentpage.msdk.core.domain.interactors.pay.handlers.applePay.ApplePayAuthRequestHandler;
import com.paymentpage.msdk.core.domain.interactors.pay.handlers.applePay.ApplePaySaleRequestHandler;
import com.paymentpage.msdk.core.domain.interactors.pay.handlers.applePay.ApplePayVerifyRequestHandler;
import com.paymentpage.msdk.core.domain.interactors.pay.handlers.card.CardAuthRequestHandler;
import com.paymentpage.msdk.core.domain.interactors.pay.handlers.card.CardAuthTokenizeRequestHandler;
import com.paymentpage.msdk.core.domain.interactors.pay.handlers.card.CardSaleTokenizeRequestHandler;
import com.paymentpage.msdk.core.domain.interactors.pay.handlers.card.CardTokenizeRequestHandler;
import com.paymentpage.msdk.core.domain.interactors.pay.handlers.card.CardVerifyRequestHandler;
import com.paymentpage.msdk.core.domain.interactors.pay.handlers.card.NewCardSaleRequestHandler;
import com.paymentpage.msdk.core.domain.interactors.pay.handlers.card.SavedCardAuthRequestHandler;
import com.paymentpage.msdk.core.domain.interactors.pay.handlers.card.SavedCardSaleRequestHandler;
import com.paymentpage.msdk.core.domain.interactors.pay.handlers.googlePay.GooglePayAuthRequestHandler;
import com.paymentpage.msdk.core.domain.interactors.pay.handlers.googlePay.GooglePaySaleRequestHandler;
import com.paymentpage.msdk.core.domain.interactors.pay.handlers.googlePay.GooglePayVerifyRequestHandler;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J.\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rH\u0086@\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/paymentpage/msdk/core/domain/interactors/pay/handlers/SaleResponseHandlersFactory;", "", "payRepository", "Lcom/paymentpage/msdk/core/data/repository/pay/PayRepository;", "sessionRepository", "Lcom/paymentpage/msdk/core/data/repository/session/SessionRepository;", "(Lcom/paymentpage/msdk/core/data/repository/pay/PayRepository;Lcom/paymentpage/msdk/core/data/repository/session/SessionRepository;)V", "execute", "Lcom/paymentpage/msdk/core/base/Response;", "Lcom/paymentpage/msdk/core/domain/entities/sale/SaleResponse;", "request", "Lcom/paymentpage/msdk/core/base/Request;", "customerFields", "", "Lcom/paymentpage/msdk/core/domain/entities/customer/CustomerFieldValue;", "(Lcom/paymentpage/msdk/core/base/Request;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "MsdkCore_release"})
public final class SaleResponseHandlersFactory {
    @NotNull
    private final PayRepository payRepository;
    @NotNull
    private final SessionRepository sessionRepository;

    public SaleResponseHandlersFactory(@NotNull PayRepository payRepository, @NotNull SessionRepository sessionRepository) {
        Intrinsics.checkNotNullParameter((Object)payRepository, (String)"payRepository");
        Intrinsics.checkNotNullParameter((Object)sessionRepository, (String)"sessionRepository");
        this.payRepository = payRepository;
        this.sessionRepository = sessionRepository;
    }

    @Nullable
    public final Object execute(@Nullable Request request, @Nullable List<CustomerFieldValue> customerFields, @NotNull Continuation<? super Response<SaleResponse>> $completion) {
        Request request2 = request;
        if (request2 instanceof NewCardSaleRequest) {
            return new NewCardSaleRequestHandler(this.payRepository).execute((NewCardSaleRequest)request, customerFields, $completion);
        }
        if (request2 instanceof CardAuthRequest) {
            return new CardAuthRequestHandler(this.payRepository).execute((CardAuthRequest)request, customerFields, $completion);
        }
        if (request2 instanceof SavedCardSaleRequest) {
            return new SavedCardSaleRequestHandler(this.payRepository).execute((SavedCardSaleRequest)request, customerFields, $completion);
        }
        if (request2 instanceof SavedCardAuthRequest) {
            return new SavedCardAuthRequestHandler(this.payRepository).execute((SavedCardAuthRequest)request, customerFields, $completion);
        }
        if (request2 instanceof CardVerifyRequest) {
            return new CardVerifyRequestHandler(this.payRepository).execute((CardVerifyRequest)request, customerFields, $completion);
        }
        if (request2 instanceof CardSaleTokenizeRequest) {
            return new CardSaleTokenizeRequestHandler(this.payRepository, this.sessionRepository).execute((CardSaleTokenizeRequest)request, customerFields, $completion);
        }
        if (request2 instanceof CardAuthTokenizeRequest) {
            return new CardAuthTokenizeRequestHandler(this.payRepository, this.sessionRepository).execute((CardAuthTokenizeRequest)request, customerFields, $completion);
        }
        if (request2 instanceof CardTokenizeRequest) {
            return new CardTokenizeRequestHandler(this.payRepository, this.sessionRepository).execute((CardTokenizeRequest)request, customerFields, $completion);
        }
        if (request2 instanceof GooglePaySaleRequest) {
            return new GooglePaySaleRequestHandler(this.payRepository).execute((GooglePaySaleRequest)request, customerFields, $completion);
        }
        if (request2 instanceof GooglePayAuthRequest) {
            return new GooglePayAuthRequestHandler(this.payRepository).execute((GooglePayAuthRequest)request, customerFields, $completion);
        }
        if (request2 instanceof GooglePayVerifyRequest) {
            return new GooglePayVerifyRequestHandler(this.payRepository).execute((GooglePayVerifyRequest)request, customerFields, $completion);
        }
        if (request2 instanceof ApplePaySaleRequest) {
            return new ApplePaySaleRequestHandler(this.payRepository).execute((ApplePaySaleRequest)request, customerFields, $completion);
        }
        if (request2 instanceof ApplePayAuthRequest) {
            return new ApplePayAuthRequestHandler(this.payRepository).execute((ApplePayAuthRequest)request, customerFields, $completion);
        }
        if (request2 instanceof ApplePayVerifyRequest) {
            return new ApplePayVerifyRequestHandler(this.payRepository).execute((ApplePayVerifyRequest)request, customerFields, $completion);
        }
        throw new PaymentRequestTypeNotExistException();
    }
}

