/*
 * Decompiled with CFR 0.152.
 */
package com.paymentpage.msdk.core.domain.interactors.pay.handlers.card;

import com.paymentpage.msdk.core.base.Response;
import com.paymentpage.msdk.core.base.exceptions.PaymentTokenNotExistException;
import com.paymentpage.msdk.core.data.repository.pay.PayRepository;
import com.paymentpage.msdk.core.data.repository.session.SessionRepository;
import com.paymentpage.msdk.core.domain.entities.PaymentInfo;
import com.paymentpage.msdk.core.domain.entities.customer.CustomerFieldValue;
import com.paymentpage.msdk.core.domain.entities.sale.SaleResponse;
import com.paymentpage.msdk.core.domain.interactors.pay.card.auth.CardAuthTokenizeRequest;
import com.paymentpage.msdk.core.domain.interactors.pay.handlers.PayRequestHandler;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ,\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\u0006\u0010\u000b\u001a\u00020\u00022\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rH\u0096@\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/paymentpage/msdk/core/domain/interactors/pay/handlers/card/CardAuthTokenizeRequestHandler;", "Lcom/paymentpage/msdk/core/domain/interactors/pay/handlers/PayRequestHandler;", "Lcom/paymentpage/msdk/core/domain/interactors/pay/card/auth/CardAuthTokenizeRequest;", "Lcom/paymentpage/msdk/core/domain/entities/sale/SaleResponse;", "payRepository", "Lcom/paymentpage/msdk/core/data/repository/pay/PayRepository;", "sessionRepository", "Lcom/paymentpage/msdk/core/data/repository/session/SessionRepository;", "(Lcom/paymentpage/msdk/core/data/repository/pay/PayRepository;Lcom/paymentpage/msdk/core/data/repository/session/SessionRepository;)V", "execute", "Lcom/paymentpage/msdk/core/base/Response;", "request", "customerFields", "", "Lcom/paymentpage/msdk/core/domain/entities/customer/CustomerFieldValue;", "(Lcom/paymentpage/msdk/core/domain/interactors/pay/card/auth/CardAuthTokenizeRequest;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "MsdkCore_release"})
public final class CardAuthTokenizeRequestHandler
implements PayRequestHandler<CardAuthTokenizeRequest, SaleResponse> {
    @NotNull
    private final PayRepository payRepository;
    @NotNull
    private final SessionRepository sessionRepository;

    public CardAuthTokenizeRequestHandler(@NotNull PayRepository payRepository, @NotNull SessionRepository sessionRepository) {
        Intrinsics.checkNotNullParameter((Object)payRepository, (String)"payRepository");
        Intrinsics.checkNotNullParameter((Object)sessionRepository, (String)"sessionRepository");
        this.payRepository = payRepository;
        this.sessionRepository = sessionRepository;
    }

    @Override
    @Nullable
    public Object execute(@NotNull CardAuthTokenizeRequest request, @Nullable List<CustomerFieldValue> customerFields, @NotNull Continuation<? super Response<SaleResponse>> $completion) {
        PaymentInfo paymentInfo = this.sessionRepository.getPaymentInfo();
        CharSequence charSequence = paymentInfo != null ? paymentInfo.getToken() : null;
        if (charSequence == null || charSequence.length() == 0) {
            throw new PaymentTokenNotExistException();
        }
        PaymentInfo paymentInfo2 = this.sessionRepository.getPaymentInfo();
        return this.payRepository.cardTokenAuth(request.getCvv(), paymentInfo2 != null ? paymentInfo2.getToken() : null, customerFields, request.getRecipientInfo(), $completion);
    }
}

