/*
 * Decompiled with CFR 0.152.
 */
package com.paymentpage.msdk.core.domain.interactors.payment.restore;

import co.touchlab.stately.concurrency.AtomicReferenceKt;
import com.paymentpage.msdk.core.base.ErrorCode;
import com.paymentpage.msdk.core.base.Request;
import com.paymentpage.msdk.core.base.exceptions.PaymentNotFoundException;
import com.paymentpage.msdk.core.data.repository.session.SessionRepository;
import com.paymentpage.msdk.core.domain.entities.init.PaymentMethodType;
import com.paymentpage.msdk.core.domain.entities.payment.Payment;
import com.paymentpage.msdk.core.domain.entities.threeDSecure.Acs;
import com.paymentpage.msdk.core.domain.entities.threeDSecure.AcsReturnUrl;
import com.paymentpage.msdk.core.domain.interactors.base.BaseInteractor;
import com.paymentpage.msdk.core.domain.interactors.payment.restore.RestorePaymentRequest;
import com.paymentpage.msdk.core.domain.interactors.payment.status.PaymentStatusDelayType;
import com.paymentpage.msdk.core.domain.interactors.payment.status.PaymentStatusDelegate;
import com.paymentpage.msdk.core.domain.interactors.payment.status.PaymentStatusInteractor;
import com.paymentpage.msdk.core.domain.interactors.payment.status.PaymentStatusRequest;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0007\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B'\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\u0015\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0010\u00a2\u0006\u0002\b\u0011J\"\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00022\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0090@\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/paymentpage/msdk/core/domain/interactors/payment/restore/PaymentRestoreInteractor;", "Lcom/paymentpage/msdk/core/domain/interactors/base/BaseInteractor;", "Lcom/paymentpage/msdk/core/domain/interactors/payment/restore/RestorePaymentRequest;", "Lcom/paymentpage/msdk/core/domain/interactors/payment/status/PaymentStatusDelegate;", "paymentStatusInteractor", "Lcom/paymentpage/msdk/core/domain/interactors/payment/status/PaymentStatusInteractor;", "sessionRepository", "Lcom/paymentpage/msdk/core/data/repository/session/SessionRepository;", "bgDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "mainDispatcher", "(Lcom/paymentpage/msdk/core/domain/interactors/payment/status/PaymentStatusInteractor;Lcom/paymentpage/msdk/core/data/repository/session/SessionRepository;Lkotlinx/coroutines/CoroutineDispatcher;Lkotlinx/coroutines/CoroutineDispatcher;)V", "cancel", "", "onError", "error", "", "onError$MsdkCore_release", "run", "request", "callback", "run$MsdkCore_release", "(Lcom/paymentpage/msdk/core/domain/interactors/payment/restore/RestorePaymentRequest;Lcom/paymentpage/msdk/core/domain/interactors/payment/status/PaymentStatusDelegate;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "MsdkCore_release"})
public final class PaymentRestoreInteractor
extends BaseInteractor<RestorePaymentRequest, PaymentStatusDelegate> {
    @NotNull
    private final PaymentStatusInteractor paymentStatusInteractor;
    @NotNull
    private final SessionRepository sessionRepository;

    public PaymentRestoreInteractor(@NotNull PaymentStatusInteractor paymentStatusInteractor, @NotNull SessionRepository sessionRepository, @NotNull CoroutineDispatcher bgDispatcher, @NotNull CoroutineDispatcher mainDispatcher) {
        Intrinsics.checkNotNullParameter((Object)paymentStatusInteractor, (String)"paymentStatusInteractor");
        Intrinsics.checkNotNullParameter((Object)sessionRepository, (String)"sessionRepository");
        Intrinsics.checkNotNullParameter((Object)bgDispatcher, (String)"bgDispatcher");
        Intrinsics.checkNotNullParameter((Object)mainDispatcher, (String)"mainDispatcher");
        super(bgDispatcher, mainDispatcher);
        this.paymentStatusInteractor = paymentStatusInteractor;
        this.sessionRepository = sessionRepository;
    }

    @Override
    @Nullable
    public Object run$MsdkCore_release(@NotNull RestorePaymentRequest request, @Nullable PaymentStatusDelegate callback, @NotNull Continuation<? super Unit> $completion) {
        this.paymentStatusInteractor.cancel();
        Payment payment = this.sessionRepository.getPayment();
        if (payment == null) {
            throw new PaymentNotFoundException("Payment not received from init request");
        }
        Payment payment2 = payment;
        PaymentStatusDelayType paymentStatusDelayType = PaymentStatusDelayType.AFTER;
        boolean bl = payment2.getPaymentMethodType() == PaymentMethodType.APS;
        String string = payment2.getMethod();
        Acs acs = payment2.getAcs();
        AcsReturnUrl acsReturnUrl = new AcsReturnUrl(acs != null ? acs.getTermUrl() : null);
        this.paymentStatusInteractor.execute((Request)new PaymentStatusRequest(bl, paymentStatusDelayType, acsReturnUrl, string), callback);
        return Unit.INSTANCE;
    }

    @Override
    public void onError$MsdkCore_release(@NotNull Throwable error2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
            PaymentStatusDelegate paymentStatusDelegate = (PaymentStatusDelegate)AtomicReferenceKt.getValue(this.get_callback$MsdkCore_release());
            if (paymentStatusDelegate == null) break block1;
            ErrorCode errorCode = ErrorCode.Companion.from(error2);
            String string = error2.getMessage();
            if (string == null) {
                string = error2.toString();
            }
            paymentStatusDelegate.onError(errorCode, string);
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        this.paymentStatusInteractor.cancel();
    }
}

