/*
 * Decompiled with CFR 0.152.
 */
package com.paymentpage.msdk.core.googlePay;

import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003J\u0006\u0010\u000e\u001a\u00020\tJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\tH\u0002J\b\u0010\u0013\u001a\u00020\tH\u0002J\b\u0010\u0014\u001a\u00020\tH\u0002J\b\u0010\u0015\u001a\u00020\tH\u0002J\u0018\u0010\u0016\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/paymentpage/msdk/core/googlePay/GooglePayHelper;", "", "merchantId", "", "merchantName", "gatewayMerchantId", "countryCode", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "merchantInfo", "Lorg/json/JSONObject;", "createPaymentDataRequest", "price", "Ljava/math/BigDecimal;", "currencyCode", "createReadyToPayRequest", "getAllowedCardAuthMethods", "Lorg/json/JSONArray;", "getAllowedCardNetworks", "getBaseRequest", "getCardPaymentMethod", "getCardPaymentMethods", "getTokenSpecification", "getTransactionInfo", "Companion", "MsdkCore_release"})
public final class GooglePayHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String merchantId;
    @NotNull
    private final String merchantName;
    @NotNull
    private final String gatewayMerchantId;
    @Nullable
    private final String countryCode;
    @NotNull
    private final JSONObject merchantInfo;
    private static final int API_VERSION = 2;
    private static final int API_VERSION_MINOR = 0;
    @NotNull
    private static final String GATEWAY_NAME = "ecommpay";
    @NotNull
    private static final String GATEWAY_TYPE = "PAYMENT_GATEWAY";
    @NotNull
    private static final String PRICE_STATUS = "FINAL";

    public GooglePayHelper(@NotNull String merchantId, @NotNull String merchantName, @NotNull String gatewayMerchantId, @Nullable String countryCode) {
        Intrinsics.checkNotNullParameter((Object)merchantId, (String)"merchantId");
        Intrinsics.checkNotNullParameter((Object)merchantName, (String)"merchantName");
        Intrinsics.checkNotNullParameter((Object)gatewayMerchantId, (String)"gatewayMerchantId");
        this.merchantId = merchantId;
        this.merchantName = merchantName;
        this.gatewayMerchantId = gatewayMerchantId;
        this.countryCode = countryCode;
        JSONObject jSONObject = new JSONObject().put("merchantName", (Object)this.merchantName).put("merchantId", (Object)this.merchantId);
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"put(...)");
        this.merchantInfo = jSONObject;
    }

    public /* synthetic */ GooglePayHelper(String string, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string3 = GATEWAY_NAME;
        }
        if ((n & 8) != 0) {
            string4 = null;
        }
        this(string, string2, string3, string4);
    }

    @NotNull
    public final JSONObject createReadyToPayRequest() {
        JSONObject jSONObject = this.getBaseRequest().put("allowedPaymentMethods", (Object)new JSONArray().put((Object)this.getCardPaymentMethods()));
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"put(...)");
        return jSONObject;
    }

    @NotNull
    public final JSONObject createPaymentDataRequest(@NotNull BigDecimal price, @NotNull String currencyCode) {
        Intrinsics.checkNotNullParameter((Object)price, (String)"price");
        Intrinsics.checkNotNullParameter((Object)currencyCode, (String)"currencyCode");
        JSONObject jSONObject = this.getBaseRequest().put("allowedPaymentMethods", (Object)new JSONArray().put((Object)this.getCardPaymentMethod())).put("transactionInfo", (Object)this.getTransactionInfo(price, currencyCode)).put("merchantInfo", (Object)this.merchantInfo);
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"put(...)");
        return jSONObject;
    }

    private final JSONObject getTransactionInfo(BigDecimal price, String currencyCode) {
        String string = price.setScale(2, 6).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String formattedPrice = string;
        JSONObject jsonObj = new JSONObject().put("totalPrice", (Object)formattedPrice).put("totalPriceStatus", (Object)PRICE_STATUS).put("currencyCode", (Object)currencyCode);
        CharSequence charSequence = this.countryCode;
        if (!(charSequence == null || charSequence.length() == 0)) {
            jsonObj.put("countryCode", (Object)this.countryCode);
        }
        Intrinsics.checkNotNull((Object)jsonObj);
        return jsonObj;
    }

    private final JSONObject getCardPaymentMethod() {
        JSONObject jSONObject = this.getCardPaymentMethods().put("tokenizationSpecification", (Object)this.getTokenSpecification());
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"put(...)");
        return jSONObject;
    }

    private final JSONObject getCardPaymentMethods() {
        JSONObject jSONObject = new JSONObject().put("type", (Object)"CARD").put("parameters", (Object)new JSONObject().put("allowedAuthMethods", (Object)this.getAllowedCardAuthMethods()).put("allowedCardNetworks", (Object)this.getAllowedCardNetworks()));
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"put(...)");
        return jSONObject;
    }

    private final JSONArray getAllowedCardAuthMethods() {
        JSONArray jSONArray = new JSONArray().put((Object)"PAN_ONLY").put((Object)"CRYPTOGRAM_3DS");
        Intrinsics.checkNotNullExpressionValue((Object)jSONArray, (String)"put(...)");
        return jSONArray;
    }

    private final JSONArray getAllowedCardNetworks() {
        JSONArray jSONArray = new JSONArray().put((Object)"VISA").put((Object)"MASTERCARD").put((Object)"DISCOVER").put((Object)"AMEX").put((Object)"INTERAC").put((Object)"JCB");
        Intrinsics.checkNotNullExpressionValue((Object)jSONArray, (String)"put(...)");
        return jSONArray;
    }

    private final JSONObject getTokenSpecification() {
        JSONObject jSONObject = new JSONObject().put("type", (Object)GATEWAY_TYPE).put("parameters", (Object)new JSONObject().put("gateway", (Object)GATEWAY_NAME).put("gatewayMerchantId", (Object)this.gatewayMerchantId));
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"put(...)");
        return jSONObject;
    }

    private final JSONObject getBaseRequest() {
        JSONObject jSONObject = new JSONObject().put("apiVersion", 2).put("apiVersionMinor", 0);
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"put(...)");
        return jSONObject;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/paymentpage/msdk/core/googlePay/GooglePayHelper$Companion;", "", "()V", "API_VERSION", "", "API_VERSION_MINOR", "GATEWAY_NAME", "", "GATEWAY_TYPE", "PRICE_STATUS", "MsdkCore_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

