/*
 * Decompiled with CFR 0.152.
 */
package com.paymentpage.msdk.core.mappers.validator;

import com.paymentpage.msdk.core.mappers.Mapper;
import com.paymentpage.msdk.core.validators.Validator;
import com.paymentpage.msdk.core.validators.base.LengthValidator;
import com.paymentpage.msdk.core.validators.custom.AboveZeroValidator;
import com.paymentpage.msdk.core.validators.custom.AvsPostCodeValidator;
import com.paymentpage.msdk.core.validators.custom.AvsStreetAddressValidator;
import com.paymentpage.msdk.core.validators.custom.DateValidator;
import com.paymentpage.msdk.core.validators.custom.EmailValidator;
import com.paymentpage.msdk.core.validators.custom.FxcmAccountNumberValidator;
import com.paymentpage.msdk.core.validators.custom.MinAgeValidator;
import com.paymentpage.msdk.core.validators.custom.MonthValidator;
import com.paymentpage.msdk.core.validators.custom.PanValidator;
import com.paymentpage.msdk.core.validators.custom.PhoneNumberValidator;
import com.paymentpage.msdk.core.validators.custom.PostalCodeValidator;
import com.paymentpage.msdk.core.validators.custom.YearValidator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/paymentpage/msdk/core/mappers/validator/ValidatorMapper;", "Lcom/paymentpage/msdk/core/mappers/Mapper;", "", "Lcom/paymentpage/msdk/core/validators/Validator;", "()V", "transform", "from", "MsdkCore_release"})
public final class ValidatorMapper
implements Mapper<String, Validator> {
    @Override
    @Nullable
    public Validator transform(@NotNull String from) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        return switch (from) {
            case "Email" -> new EmailValidator();
            case "Birthday" -> new DateValidator();
            case "AboveZero" -> new AboveZeroValidator();
            case "String15" -> new LengthValidator(15);
            case "String30" -> new LengthValidator(30);
            case "String100" -> new LengthValidator(100);
            case "String255" -> new LengthValidator(255);
            case "String512" -> new LengthValidator(512);
            case "Date" -> new DateValidator();
            case "FxcmAccountNumber" -> new FxcmAccountNumberValidator();
            case "MobilePhone" -> new PhoneNumberValidator();
            case "MinAge" -> new MinAgeValidator();
            case "Month" -> new MonthValidator();
            case "PostalCode" -> new PostalCodeValidator();
            case "Year" -> new YearValidator();
            case "pan" -> new PanValidator();
            case "AvsPostCode" -> new AvsPostCodeValidator();
            case "StreetAddress" -> new AvsStreetAddressValidator();
            default -> null;
        };
    }
}

