/*
 * Decompiled with CFR 0.152.
 */
package com.paymentpage.msdk.core.network;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.os.Build;
import com.paymentpage.msdk.core.CommonKt;
import com.paymentpage.msdk.core.network.ConnectivityStatus;
import com.paymentpage.msdk.core.network.ConnectivityStatusState;
import com.paymentpage.msdk.core.utils.Log;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lighthousegames.logging.KmLog;
import org.lighthousegames.logging.KmLogging;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/paymentpage/msdk/core/network/ConnectivityStatus;", "", "()V", "connectivityManager", "Landroid/net/ConnectivityManager;", "networkCallback", "com/paymentpage/msdk/core/network/ConnectivityStatus$networkCallback$1", "Lcom/paymentpage/msdk/core/network/ConnectivityStatus$networkCallback$1;", "networkState", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/paymentpage/msdk/core/network/ConnectivityStatusState;", "getNetworkState", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "MsdkCore_release"})
@SourceDebugExtension(value={"SMAP\nConnectivityStatus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectivityStatus.kt\ncom/paymentpage/msdk/core/network/ConnectivityStatus\n+ 2 Log.kt\ncom/paymentpage/msdk/core/utils/Log\n+ 3 KmLog.kt\norg/lighthousegames/logging/KmLog\n*L\n1#1,81:1\n11#2:82\n12#2:86\n11#2:87\n12#2:91\n11#2:92\n12#2:96\n19#2:97\n20#2:101\n34#3,3:83\n34#3,3:88\n34#3,3:93\n64#3,3:98\n*S KotlinDebug\n*F\n+ 1 ConnectivityStatus.kt\ncom/paymentpage/msdk/core/network/ConnectivityStatus\n*L\n44#1:82\n44#1:86\n67#1:87\n67#1:91\n71#1:92\n71#1:96\n72#1:97\n72#1:101\n44#1:83,3\n67#1:88,3\n71#1:93,3\n72#1:98,3\n*E\n"})
public final class ConnectivityStatus {
    @NotNull
    private final MutableStateFlow<ConnectivityStatusState> networkState = StateFlowKt.MutableStateFlow((Object)((Object)ConnectivityStatusState.UNKNOWN));
    @Nullable
    private final ConnectivityManager connectivityManager;
    @NotNull
    private final networkCallback.1 networkCallback = new ConnectivityManager.NetworkCallback(this){
        final /* synthetic */ ConnectivityStatus this$0;
        {
            this.this$0 = $receiver;
        }

        /*
         * WARNING - void declaration
         */
        public void onAvailable(@NotNull Network network) {
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)network, (String)"network");
            Log log = Log.INSTANCE;
            String tag$iv = "ConnectivityStatus";
            boolean $i$f$d = false;
            KmLog this_$iv$iv = this_$iv.getLog();
            boolean $i$f$d2 = false;
            if (KmLogging.INSTANCE.isLoggingDebug()) {
                String string = tag$iv;
                KmLog kmLog = this_$iv$iv;
                boolean bl = false;
                String string2 = "Connected";
                kmLog.debugApi(string, String.valueOf(string2));
            }
            this.this$0.getNetworkState().setValue((Object)((Object)ConnectivityStatusState.CONNECTED));
        }

        /*
         * WARNING - void declaration
         */
        public void onLost(@NotNull Network network) {
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)network, (String)"network");
            Log log = Log.INSTANCE;
            String tag$iv = "ConnectivityStatus";
            boolean $i$f$d = false;
            KmLog this_$iv$iv = this_$iv.getLog();
            boolean $i$f$d2 = false;
            if (KmLogging.INSTANCE.isLoggingDebug()) {
                String string = tag$iv;
                KmLog kmLog = this_$iv$iv;
                boolean bl = false;
                String string2 = "Disconnected";
                kmLog.debugApi(string, String.valueOf(string2));
            }
            this.this$0.getNetworkState().setValue((Object)((Object)ConnectivityStatusState.DISCONNECTED));
        }
    };

    /*
     * WARNING - void declaration
     */
    public ConnectivityStatus() {
        try {
            Context context = CommonKt.getAppContext();
            Object object = context != null ? context.getSystemService("connectivity") : null;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
            ConnectivityManager connectivityManager = (ConnectivityManager)object;
            if (Build.VERSION.SDK_INT >= 24) {
                connectivityManager.registerDefaultNetworkCallback((ConnectivityManager.NetworkCallback)this.networkCallback);
                Network currentNetwork = connectivityManager.getActiveNetwork();
                if (currentNetwork == null) {
                    void this_$iv;
                    this.networkState.setValue((Object)ConnectivityStatusState.DISCONNECTED);
                    Log log = Log.INSTANCE;
                    String tag$iv = "ConnectivityStatus";
                    boolean $i$f$d = false;
                    KmLog this_$iv$iv = this_$iv.getLog();
                    boolean $i$f$d2 = false;
                    if (KmLogging.INSTANCE.isLoggingDebug()) {
                        String string = tag$iv;
                        KmLog kmLog = this_$iv$iv;
                        boolean bl = false;
                        String string2 = "Disconnected";
                        kmLog.debugApi(string, String.valueOf(string2));
                    }
                }
            } else {
                NetworkRequest.Builder this_$iv;
                Object $this$_init__u24lambda_u241 = this_$iv = new NetworkRequest.Builder();
                boolean bl = false;
                $this$_init__u24lambda_u241.addCapability(12);
                $this$_init__u24lambda_u241.addCapability(13);
                if (Build.VERSION.SDK_INT >= 23) {
                    $this$_init__u24lambda_u241.addCapability(16);
                }
                NetworkRequest networkRequest = this_$iv.build();
                connectivityManager.registerNetworkCallback(networkRequest, (ConnectivityManager.NetworkCallback)this.networkCallback);
                NetworkInfo currentNetwork = connectivityManager.getActiveNetworkInfo();
                if (currentNetwork == null || currentNetwork.getType() != 9 && currentNetwork.getType() != 1 && currentNetwork.getType() != 0) {
                    void this_$iv2;
                    this.networkState.setValue((Object)ConnectivityStatusState.DISCONNECTED);
                    $this$_init__u24lambda_u241 = Log.INSTANCE;
                    String tag$iv = "ConnectivityStatus";
                    boolean $i$f$d = false;
                    KmLog this_$iv$iv = this_$iv2.getLog();
                    boolean $i$f$d3 = false;
                    if (KmLogging.INSTANCE.isLoggingDebug()) {
                        String string = tag$iv;
                        KmLog kmLog = this_$iv$iv;
                        boolean bl2 = false;
                        String string3 = "Disconnected";
                        kmLog.debugApi(string, String.valueOf(string3));
                    }
                }
            }
        }
        catch (Exception e) {
            StackTraceElement[] stackTraceElementArray;
            KmLog kmLog;
            String string;
            Log this_$iv;
            Log networkRequest = Log.INSTANCE;
            String tag$iv = "ConnectivityStatus";
            boolean $i$f$d = false;
            KmLog this_$iv$iv = this_$iv.getLog();
            boolean $i$f$d4 = false;
            if (KmLogging.INSTANCE.isLoggingDebug()) {
                string = tag$iv;
                kmLog = this_$iv$iv;
                boolean bl = false;
                stackTraceElementArray = "Disconnected";
                kmLog.debugApi(string, String.valueOf(stackTraceElementArray));
            }
            this_$iv = Log.INSTANCE;
            tag$iv = "ConnectivityStatus";
            boolean $i$f$w = false;
            this_$iv$iv = this_$iv.getLog();
            Throwable err$iv$iv = null;
            boolean $i$f$w2 = false;
            if (KmLogging.INSTANCE.isLoggingWarning()) {
                string = tag$iv;
                kmLog = this_$iv$iv;
                boolean bl = false;
                stackTraceElementArray = e.getStackTrace();
                kmLog.warnApi(string, String.valueOf(stackTraceElementArray), err$iv$iv);
            }
            this.networkState.setValue((Object)ConnectivityStatusState.DISCONNECTED);
        }
    }

    @NotNull
    public final MutableStateFlow<ConnectivityStatusState> getNetworkState() {
        return this.networkState;
    }
}

