/*
 * Decompiled with CFR 0.152.
 */
package com.paymentpage.msdk.core.network.networkConfiguration;

import com.paymentpage.msdk.core.base.Response;
import com.paymentpage.msdk.core.base.exceptions.NetworkException;
import com.paymentpage.msdk.core.base.exceptions.NetworkIsNotAvailableException;
import com.paymentpage.msdk.core.base.exceptions.NetworkTimeoutException;
import com.paymentpage.msdk.core.base.exceptions.ServerApiException;
import com.paymentpage.msdk.core.base.exceptions.ServerContentParsingException;
import com.paymentpage.msdk.core.base.exceptions.ServerMethodNotFoundException;
import com.paymentpage.msdk.core.base.exceptions.ServerUnauthorizedException;
import com.paymentpage.msdk.core.network.ApiNetworkClient;
import com.paymentpage.msdk.core.network.ConnectivityStatusState;
import com.paymentpage.msdk.core.network.NetworkErrorsKt;
import io.ktor.client.plugins.HttpRequestTimeoutException;
import io.ktor.client.plugins.ResponseException;
import io.ktor.client.statement.HttpResponse;
import io.ktor.client.statement.HttpResponseKt;
import io.ktor.http.HttpStatusCode;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.serialization.SerializationException;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a6\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0006\b\u0000\u0010\u0002\u0018\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0007H\u0080H\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"getResponse", "Lcom/paymentpage/msdk/core/base/Response;", "T", "Lcom/paymentpage/msdk/core/network/ApiNetworkClient;", "path", "", "request", "Lkotlin/Function0;", "(Lcom/paymentpage/msdk/core/network/ApiNetworkClient;Ljava/lang/String;Lkotlin/jvm/functions/Function0;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "MsdkCore_release"})
public final class NetworkClientExtensionsKt {
    public static final /* synthetic */ <T> Object getResponse(ApiNetworkClient $this$getResponse, String path, Function0<? extends T> request, Continuation<? super Response<? extends T>> $completion) {
        Response response;
        boolean $i$f$getResponse = false;
        try {
            response = new Response.Success<Object>(request.invoke());
        }
        catch (ResponseException e) {
            Response.Error.Network network;
            HttpStatusCode httpStatusCode = e.getResponse().getStatus();
            if (Intrinsics.areEqual((Object)httpStatusCode, (Object)HttpStatusCode.Companion.getUnauthorized())) {
                network = NetworkErrorsKt.networkError(new ServerUnauthorizedException(HttpResponseKt.getRequest((HttpResponse)e.getResponse()).getUrl().getEncodedPath()));
            } else if (Intrinsics.areEqual((Object)httpStatusCode, (Object)HttpStatusCode.Companion.getForbidden())) {
                network = NetworkErrorsKt.networkError(new ServerUnauthorizedException(HttpResponseKt.getRequest((HttpResponse)e.getResponse()).getUrl().getEncodedPath()));
            } else if (Intrinsics.areEqual((Object)httpStatusCode, (Object)HttpStatusCode.Companion.getNotFound())) {
                network = NetworkErrorsKt.networkError(new ServerMethodNotFoundException(HttpResponseKt.getRequest((HttpResponse)e.getResponse()).getUrl().getEncodedPath()));
            } else {
                HttpResponse httpResponse = e.getResponse();
                InlineMarker.mark((int)0);
                Object object = HttpResponseKt.bodyAsText((HttpResponse)httpResponse, (Charset)Charsets.UTF_8, $completion);
                InlineMarker.mark((int)1);
                Object object2 = object;
                Throwable throwable = e;
                String string = (String)object2;
                network = NetworkErrorsKt.networkError(new ServerApiException(string, throwable));
            }
            response = network;
        }
        catch (SerializationException e) {
            response = NetworkErrorsKt.networkError(new ServerContentParsingException(path, e));
        }
        catch (HttpRequestTimeoutException e) {
            response = NetworkErrorsKt.networkError(new NetworkTimeoutException(path, e));
        }
        catch (Exception e) {
            ConnectivityStatusState connectivityStatusState = $this$getResponse.getConnectivityStatusState();
            int n = WhenMappings.$EnumSwitchMapping$0[connectivityStatusState.ordinal()];
            response = n == 1 ? NetworkErrorsKt.networkError(new NetworkIsNotAvailableException()) : NetworkErrorsKt.networkError(new NetworkException(e));
        }
        return response;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=176)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConnectivityStatusState.values().length];
            try {
                nArray[ConnectivityStatusState.DISCONNECTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

