/*
 * Decompiled with CFR 0.152.
 */
package com.paymentpage.msdk.core.validators.custom;

import com.paymentpage.msdk.core.validators.BaseValidator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/paymentpage/msdk/core/validators/custom/NetellerAccountNumberValidator;", "Lcom/paymentpage/msdk/core/validators/BaseValidator;", "()V", "EMAIL_REGEX", "", "PHONE_REGEX", "validate", "", "value", "MsdkCore_release"})
public final class NetellerAccountNumberValidator
extends BaseValidator {
    @NotNull
    private final String PHONE_REGEX;
    @NotNull
    private final String EMAIL_REGEX;

    public NetellerAccountNumberValidator() {
        this.PHONE_REGEX = "^[0-9]{12}$";
        this.EMAIL_REGEX = "^[a-zA-Z0-9!#$%&'*+\\\\=?^_`{|}~-]+(?:\\.[a-zA-Z0-9!#$%&'*+\\\\=?^_`{|}~-]+)*@(?:[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?\\.)+[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?$";
    }

    @Override
    public boolean validate(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Regex phoneRegex = new Regex(this.PHONE_REGEX);
        Regex emailRegex = new Regex(this.EMAIL_REGEX);
        return (phoneRegex.matches((CharSequence)value) || emailRegex.matches((CharSequence)value)) && value.length() <= 100 && value.length() >= 4;
    }
}

