/*
 * Decompiled with CFR 0.152.
 */
package com.paymentpage.msdk.ui.cardScanning;

import android.content.Context;
import android.content.Intent;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.compose.runtime.internal.StabilityInferred;
import com.paymentpage.msdk.ui.utils.extensions.core.SdkExpiryExtensionsKt;
import io.card.payment.CardIOActivity;
import io.card.payment.CreditCard;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u001a\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/paymentpage/msdk/ui/cardScanning/CardScanningActivityContract;", "Landroidx/activity/result/contract/ActivityResultContract;", "Lcom/paymentpage/msdk/ui/cardScanning/CardScanningActivityContract$Config;", "Lcom/paymentpage/msdk/ui/cardScanning/CardScanningActivityContract$Result;", "()V", "createIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "input", "parseResult", "resultCode", "", "intent", "Config", "Result", "mobile-sdk-android-ui_prodRelease"})
@StabilityInferred(parameters=1)
public final class CardScanningActivityContract
extends ActivityResultContract<Config, Result> {
    public static final int $stable;

    @NotNull
    public Intent createIntent(@NotNull Context context, @NotNull Config input) {
        Intent intent;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intent $this$createIntent_u24lambda_u240 = intent = new Intent(context, CardIOActivity.class);
        boolean bl = false;
        $this$createIntent_u24lambda_u240.putExtra("io.card.payment.noCamera", false);
        $this$createIntent_u24lambda_u240.putExtra("io.card.payment.requireCardholderName", false);
        $this$createIntent_u24lambda_u240.putExtra("io.card.payment.scanExpiry", true);
        $this$createIntent_u24lambda_u240.putExtra("io.card.payment.requireExpiry", false);
        $this$createIntent_u24lambda_u240.putExtra("io.card.payment.hideLogo", true);
        $this$createIntent_u24lambda_u240.putExtra("io.card.payment.intentSenderIsPayPal", false);
        $this$createIntent_u24lambda_u240.putExtra("io.card.payment.keepApplicationTheme", false);
        $this$createIntent_u24lambda_u240.putExtra("io.card.payment.suppressConfirmation", true);
        $this$createIntent_u24lambda_u240.putExtra("io.card.payment.suppressManual", true);
        $this$createIntent_u24lambda_u240.putExtra("io.card.payment.guideColor", input.getBrandColor());
        return intent;
    }

    @NotNull
    public Result parseResult(int resultCode, @Nullable Intent intent) {
        CreditCard result = null;
        if (intent != null && intent.hasExtra("io.card.payment.scanResult")) {
            result = (CreditCard)intent.getParcelableExtra("io.card.payment.scanResult");
        }
        CreditCard creditCard = result;
        String expiryMonth = SdkExpiryExtensionsKt.oneDigitMonthToTwoDigitMonth(creditCard != null ? Integer.valueOf(creditCard.expiryMonth) : null);
        CreditCard creditCard2 = result;
        Integer expiryYear = SdkExpiryExtensionsKt.fourDigitYearToTwoDigitYear(creditCard2 != null ? Integer.valueOf(creditCard2.expiryYear) : null);
        boolean isValidExpiry = expiryMonth != null && expiryYear != null;
        CreditCard creditCard3 = result;
        CreditCard creditCard4 = result;
        return new Result(creditCard3 != null ? creditCard3.cardNumber : null, creditCard4 != null ? creditCard4.cardholderName : null, isValidExpiry ? expiryMonth + "/" + expiryYear : null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/paymentpage/msdk/ui/cardScanning/CardScanningActivityContract$Config;", "", "brandColor", "", "(I)V", "getBrandColor", "()I", "mobile-sdk-android-ui_prodRelease"})
    @StabilityInferred(parameters=1)
    public static final class Config {
        private final int brandColor;
        public static final int $stable;

        public Config(int brandColor) {
            this.brandColor = brandColor;
        }

        public final int getBrandColor() {
            return this.brandColor;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B)\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J-\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/paymentpage/msdk/ui/cardScanning/CardScanningActivityContract$Result;", "", "pan", "", "cardHolderName", "expiry", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getCardHolderName", "()Ljava/lang/String;", "getExpiry", "getPan", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "mobile-sdk-android-ui_prodRelease"})
    @StabilityInferred(parameters=1)
    public static final class Result {
        @Nullable
        private final String pan;
        @Nullable
        private final String cardHolderName;
        @Nullable
        private final String expiry;
        public static final int $stable;

        public Result(@Nullable String pan, @Nullable String cardHolderName, @Nullable String expiry) {
            this.pan = pan;
            this.cardHolderName = cardHolderName;
            this.expiry = expiry;
        }

        public /* synthetic */ Result(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            this(string, string2, string3);
        }

        @Nullable
        public final String getPan() {
            return this.pan;
        }

        @Nullable
        public final String getCardHolderName() {
            return this.cardHolderName;
        }

        @Nullable
        public final String getExpiry() {
            return this.expiry;
        }

        @Nullable
        public final String component1() {
            return this.pan;
        }

        @Nullable
        public final String component2() {
            return this.cardHolderName;
        }

        @Nullable
        public final String component3() {
            return this.expiry;
        }

        @NotNull
        public final Result copy(@Nullable String pan, @Nullable String cardHolderName, @Nullable String expiry) {
            return new Result(pan, cardHolderName, expiry);
        }

        public static /* synthetic */ Result copy$default(Result result, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = result.pan;
            }
            if ((n & 2) != 0) {
                string2 = result.cardHolderName;
            }
            if ((n & 4) != 0) {
                string3 = result.expiry;
            }
            return result.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "Result(pan=" + this.pan + ", cardHolderName=" + this.cardHolderName + ", expiry=" + this.expiry + ")";
        }

        public int hashCode() {
            int result = this.pan == null ? 0 : this.pan.hashCode();
            result = result * 31 + (this.cardHolderName == null ? 0 : this.cardHolderName.hashCode());
            result = result * 31 + (this.expiry == null ? 0 : this.expiry.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result = (Result)other;
            if (!Intrinsics.areEqual((Object)this.pan, (Object)result.pan)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.cardHolderName, (Object)result.cardHolderName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.expiry, (Object)result.expiry);
        }

        public Result() {
            this(null, null, null, 7, null);
        }
    }
}

