package kg.paymentpage.msdk.ui.views.customerFields.type

import androidx.compose.foundation.Image
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.size
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.KeyboardArrowDown
import androidx.compose.runtime.*
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.ColorFilter
import androidx.compose.ui.unit.dp
import com.paymentpage.msdk.core.domain.entities.customer.CustomerField
import kg.paymentpage.msdk.ui.TestTagsConstants
import kg.paymentpage.msdk.ui.theme.SDKTheme
import kg.paymentpage.msdk.ui.views.common.CustomTextField
import kg.paymentpage.msdk.ui.views.common.SelectItemsDialog

@Composable
internal fun SelectableCustomerField(
    items: Map<String?, String?>,
    initialValue: String? = null,
    onValueChanged: (CustomerField, String, Boolean) -> Unit,
    customerField: CustomerField,
) {
    var selectedText by remember { mutableStateOf(initialValue ?: "") }

    var dialogState by remember { mutableStateOf(false) }
    CustomTextField(
        initialValue = initialValue,
        pastedValue = selectedText,
        onValueChanged = null,
        isEditable = false,
        label = customerField.label,
        placeholder = customerField.placeholder ?: customerField.hint,
        isRequired = customerField.isRequired,
        trailingIcon = {
            Image(
                modifier = Modifier
                    .clickable {
                        dialogState = true
                    },
                imageVector = Icons.Default.KeyboardArrowDown,
                colorFilter = ColorFilter.tint(SDKTheme.colors.neutral),
                contentDescription = items.keys.first(),
            )
        },
        testTag = "${
            customerField.label.uppercase()
        }${
            TestTagsConstants.POSTFIX_CUSTOMER_FIELD
        }"
    )
    if (dialogState)
        SelectItemsDialog(
            modifier = Modifier.size(width = 400.dp, height = 300.dp),
            items = items,
            onDismissRequest = { dialogState = false }
        ) { countryName ->
            selectedText = if (!items[countryName].isNullOrEmpty()) countryName else ""
            onValueChanged(
                customerField,
                //Country code
                items[countryName] ?: "",

                //validation
                if (customerField.isRequired)
                    selectedText.isNotEmpty()
                else true

            )
            dialogState = false
        }
}