/*
 * Decompiled with CFR 0.152.
 */
package kg.paymentpage.msdk.ui.googlePay;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import androidx.appcompat.app.AppCompatActivity;
import androidx.compose.runtime.internal.StabilityInferred;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.wallet.AutoResolveHelper;
import com.google.android.gms.wallet.IsReadyToPayRequest;
import com.google.android.gms.wallet.PaymentData;
import com.google.android.gms.wallet.PaymentDataRequest;
import com.google.android.gms.wallet.PaymentsClient;
import com.google.android.gms.wallet.Wallet;
import com.paymentpage.msdk.core.domain.interactors.pay.googlePay.GooglePayEnvironment;
import com.paymentpage.msdk.core.googlePay.GooglePayHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import kg.paymentpage.msdk.ui.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J\u0012\u0010\u000e\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0015J \u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lkg/paymentpage/msdk/ui/googlePay/GooglePayActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "googlePayClient", "Lcom/google/android/gms/wallet/PaymentsClient;", "googlePayHelper", "Lcom/paymentpage/msdk/core/googlePay/GooglePayHelper;", "onActivityResult", "", "requestCode", "", "resultCode", "data", "Landroid/content/Intent;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "setGooglePayAvailable", "available", "", "amount", "", "currency", "", "mobile-sdk-android-ui_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nGooglePayActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GooglePayActivity.kt\nkg/paymentpage/msdk/ui/googlePay/GooglePayActivity\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,115:1\n1310#2,2:116\n*S KotlinDebug\n*F\n+ 1 GooglePayActivity.kt\nkg/paymentpage/msdk/ui/googlePay/GooglePayActivity\n*L\n36#1:116,2\n*E\n"})
public final class GooglePayActivity
extends AppCompatActivity {
    private GooglePayHelper googlePayHelper;
    private PaymentsClient googlePayClient;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"ResourceAsColor"})
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        CharSequence charSequence;
        ArrayList allowedCardNetworks;
        this.supportRequestWindowFeature(1);
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_google_pay);
        Bundle bundle = this.getIntent().getExtras();
        Long amount = bundle != null ? Long.valueOf(bundle.getLong("amount")) : null;
        Bundle bundle2 = this.getIntent().getExtras();
        String currency = bundle2 != null ? bundle2.getString("currency") : null;
        Bundle bundle3 = this.getIntent().getExtras();
        String merchantName = bundle3 != null ? bundle3.getString("merchant_name") : null;
        Bundle bundle4 = this.getIntent().getExtras();
        String merchantId = bundle4 != null ? bundle4.getString("merchant_id") : null;
        Bundle bundle5 = this.getIntent().getExtras();
        String envName = bundle5 != null ? bundle5.getString("environment") : null;
        Bundle bundle6 = this.getIntent().getExtras();
        ArrayList arrayList = allowedCardNetworks = bundle6 != null ? bundle6.getStringArrayList("extra_allowed_card_networks") : null;
        if (!(amount == null || (charSequence = (CharSequence)currency) == null || charSequence.length() == 0 || (charSequence = (CharSequence)merchantName) == null || charSequence.length() == 0 || (charSequence = (CharSequence)merchantId) == null || charSequence.length() == 0 || (charSequence = (CharSequence)envName) == null || charSequence.length() == 0)) {
            GooglePayEnvironment googlePayEnvironment;
            GooglePayEnvironment googlePayEnvironment2;
            block6: {
                void $this$firstOrNull$iv;
                GooglePayEnvironment[] googlePayEnvironmentArray = GooglePayEnvironment.values();
                boolean $i$f$firstOrNull = false;
                int n = ((void)$this$firstOrNull$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv;
                    void it = element$iv = $this$firstOrNull$iv[i];
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.name(), (Object)envName)) continue;
                    googlePayEnvironment2 = element$iv;
                    break block6;
                }
                googlePayEnvironment2 = googlePayEnvironment = null;
            }
            if (googlePayEnvironment2 == null) {
                googlePayEnvironment = GooglePayEnvironment.TEST;
            }
            GooglePayEnvironment env = googlePayEnvironment;
            this.googlePayHelper = new GooglePayHelper(merchantId, merchantName, null, null, allowedCardNetworks, 12, null);
            PaymentsClient paymentsClient = Wallet.getPaymentsClient((Activity)((Activity)this), (Wallet.WalletOptions)new Wallet.WalletOptions.Builder().setEnvironment(env == GooglePayEnvironment.TEST ? 3 : 1).build());
            Intrinsics.checkNotNullExpressionValue((Object)paymentsClient, (String)"getPaymentsClient(...)");
            this.googlePayClient = paymentsClient;
            GooglePayHelper googlePayHelper = this.googlePayHelper;
            if (googlePayHelper == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"googlePayHelper");
                googlePayHelper = null;
            }
            IsReadyToPayRequest isReadyToPayRequest = IsReadyToPayRequest.fromJson((String)googlePayHelper.createReadyToPayRequest().toString());
            Intrinsics.checkNotNullExpressionValue((Object)isReadyToPayRequest, (String)"fromJson(...)");
            IsReadyToPayRequest request = isReadyToPayRequest;
            PaymentsClient paymentsClient2 = this.googlePayClient;
            if (paymentsClient2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"googlePayClient");
                paymentsClient2 = null;
            }
            paymentsClient2.isReadyToPay(request).addOnCompleteListener(arg_0 -> GooglePayActivity.onCreate$lambda$1(this, amount, currency, arg_0));
        } else {
            this.setResult(0);
            this.finish();
        }
    }

    private final void setGooglePayAvailable(boolean available, long amount, String currency) {
        if (available) {
            GooglePayHelper googlePayHelper = this.googlePayHelper;
            if (googlePayHelper == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"googlePayHelper");
                googlePayHelper = null;
            }
            BigDecimal bigDecimal = BigDecimal.valueOf((double)amount / 100.0);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
            String string = googlePayHelper.createPaymentDataRequest(bigDecimal, currency).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String googleJson = string;
            PaymentDataRequest paymentDataRequest = PaymentDataRequest.fromJson((String)googleJson);
            Intrinsics.checkNotNullExpressionValue((Object)paymentDataRequest, (String)"fromJson(...)");
            PaymentDataRequest gpayRequest = paymentDataRequest;
            PaymentsClient paymentsClient = this.googlePayClient;
            if (paymentsClient == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"googlePayClient");
                paymentsClient = null;
            }
            AutoResolveHelper.resolveTask((Task)paymentsClient.loadPaymentData(gpayRequest), (Activity)((Activity)this), (int)991);
        } else {
            this.setResult(0);
            this.finish();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (resultCode) {
            case -1: {
                Intent intent = data;
                if (intent != null) {
                    Intent intent2;
                    Intent intent3 = intent;
                    boolean bl = false;
                    PaymentData paymentData = PaymentData.getFromIntent((Intent)intent3);
                    Object object = paymentData;
                    if (object == null || (object = object.toJson()) == null) {
                        return;
                    }
                    Object object2 = object;
                    Intrinsics.checkNotNull((Object)object2);
                    Object paymentInformation = object2;
                    JSONObject jSONObject = new JSONObject((String)paymentInformation).getJSONObject("paymentMethodData");
                    Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"getJSONObject(...)");
                    JSONObject paymentMethodData = jSONObject;
                    String token = paymentMethodData.getJSONObject("tokenizationData").getString("token");
                    Intent it = intent2 = new Intent();
                    boolean bl2 = false;
                    it.putExtra("token", token);
                    Intent dataIntent = intent2;
                    this.setResult(-1, dataIntent);
                    this.finish();
                }
                break;
            }
            case 0: {
                this.setResult(0);
                this.finish();
                break;
            }
            case 1: {
                Status status = AutoResolveHelper.getStatusFromIntent((Intent)data);
                Intent dataIntent = new Intent();
                Object object = status;
                if (object != null && (object = object.getStatusMessage()) != null) {
                    Object it = object;
                    boolean bl = false;
                    dataIntent.putExtra("error_message", (String)it);
                }
                this.setResult(0, dataIntent);
                this.finish();
            }
        }
    }

    private static final void onCreate$lambda$1(GooglePayActivity this$0, Long $amount, String $currency, Task completedTask) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)completedTask, (String)"completedTask");
        this$0.setGooglePayAvailable(completedTask.isSuccessful(), $amount, $currency);
    }
}

