/*
 * Decompiled with CFR 0.152.
 */
package kg.paymentpage.msdk.ui.utils.extensions.core;

import com.paymentpage.msdk.core.domain.entities.PaymentInfo;
import com.paymentpage.msdk.core.domain.entities.RecurrentInfo;
import java.util.Locale;
import kg.paymentpage.msdk.ui.SDKActionType;
import kg.paymentpage.msdk.ui.utils.extensions.StringExtensionsKt;
import kg.paymentpage.msdk.ui.utils.extensions.core.RecurrentPeriod;
import kg.paymentpage.msdk.ui.utils.extensions.core.RecurrentTypeUI;
import kg.paymentpage.msdk.ui.utils.extensions.core.StringResourceManagerExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0018\u0010\b\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0000\u001a\u000e\u0010\u000b\u001a\u00020\f*\u0004\u0018\u00010\u0002H\u0000\u001a\u000e\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u0002H\u0002\u001a\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0000\u001a\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0000\u001a\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u0002H\u0000\u00a8\u0006\u0013"}, d2={"amountUI", "", "Lcom/paymentpage/msdk/core/domain/entities/RecurrentInfo;", "paymentInfo", "Lcom/paymentpage/msdk/core/domain/entities/PaymentInfo;", "chargedAmountUI", "actionType", "Lkg/paymentpage/msdk/ui/SDKActionType;", "expiryDateUI", "locale", "Ljava/util/Locale;", "isShowRecurringUI", "", "period", "Lkg/paymentpage/msdk/ui/utils/extensions/core/RecurrentPeriod;", "periodUI", "startDateUI", "typeUI", "Lkg/paymentpage/msdk/ui/utils/extensions/core/RecurrentTypeUI;", "mobile-sdk-android-ui_release"})
public final class RecurrentInfoExtensionsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final RecurrentPeriod period(RecurrentInfo $this$period) {
        String string2 = $this$period.getPeriod();
        if (string2 == null) return null;
        int n = -1;
        switch (string2.hashCode()) {
            case 81: {
                if (string2.equals("Q")) {
                    n = 1;
                }
                break;
            }
            case 68: {
                if (string2.equals("D")) {
                    n = 2;
                }
                break;
            }
            case 87: {
                if (string2.equals("W")) {
                    n = 3;
                }
                break;
            }
            case 89: {
                if (string2.equals("Y")) {
                    n = 4;
                }
                break;
            }
            case 77: {
                if (string2.equals("M")) {
                    n = 5;
                }
                break;
            }
        }
        switch (n) {
            case 2: {
                RecurrentPeriod recurrentPeriod = RecurrentPeriod.DAILY;
                return recurrentPeriod;
            }
            case 3: {
                RecurrentPeriod recurrentPeriod = RecurrentPeriod.WEEKLY;
                return recurrentPeriod;
            }
            case 5: {
                RecurrentPeriod recurrentPeriod = RecurrentPeriod.MONTHLY;
                return recurrentPeriod;
            }
            case 1: {
                RecurrentPeriod recurrentPeriod = RecurrentPeriod.QUARTERLY;
                return recurrentPeriod;
            }
            case 4: {
                RecurrentPeriod recurrentPeriod = RecurrentPeriod.ANNUALLY;
                return recurrentPeriod;
            }
            default: {
                return null;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final String periodUI(@NotNull RecurrentInfo $this$periodUI) {
        Intrinsics.checkNotNullParameter((Object)$this$periodUI, (String)"<this>");
        if (RecurrentInfoExtensionsKt.period($this$periodUI) == null) return null;
        if ($this$periodUI.getInterval() != null) {
            Integer n = $this$periodUI.getInterval();
            int n2 = 1;
            if (n == null) return null;
            if (n != n2) return null;
        }
        RecurrentPeriod recurrentPeriod = RecurrentInfoExtensionsKt.period($this$periodUI);
        switch (recurrentPeriod == null ? -1 : WhenMappings.$EnumSwitchMapping$0[recurrentPeriod.ordinal()]) {
            case 1: {
                String string2 = StringResourceManagerExtensionsKt.getStringOverride("recurring_period_daily");
                return string2;
            }
            case 2: {
                String string2 = StringResourceManagerExtensionsKt.getStringOverride("recurring_period_weekly");
                return string2;
            }
            case 3: {
                String string2 = StringResourceManagerExtensionsKt.getStringOverride("recurring_period_monthly");
                return string2;
            }
            case 4: {
                String string2 = StringResourceManagerExtensionsKt.getStringOverride("recurring_period_quarterly");
                return string2;
            }
            case 5: {
                String string2 = StringResourceManagerExtensionsKt.getStringOverride("recurring_period_annually");
                return string2;
            }
            default: {
                return null;
            }
        }
    }

    @NotNull
    public static final String amountUI(@NotNull RecurrentInfo $this$amountUI, @NotNull PaymentInfo paymentInfo) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$amountUI, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)paymentInfo, (String)"paymentInfo");
        if ($this$amountUI.getAmount() == null) {
            String string3 = StringExtensionsKt.amountToCoins(paymentInfo.getPaymentAmount());
            String string4 = paymentInfo.getPaymentCurrency().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
            string2 = string3 + " " + string4;
        } else {
            String string5 = StringExtensionsKt.amountToCoins($this$amountUI.getAmount());
            String string6 = paymentInfo.getPaymentCurrency().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toUpperCase(...)");
            string2 = string5 + " " + string6;
        }
        return string2;
    }

    @Nullable
    public static final String chargedAmountUI(@NotNull RecurrentInfo $this$chargedAmountUI, @NotNull SDKActionType actionType, @NotNull PaymentInfo paymentInfo) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$chargedAmountUI, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)actionType), (String)"actionType");
        Intrinsics.checkNotNullParameter((Object)paymentInfo, (String)"paymentInfo");
        if (RecurrentInfoExtensionsKt.typeUI($this$chargedAmountUI) == RecurrentTypeUI.REGULAR && actionType == SDKActionType.Verify && RecurrentInfoExtensionsKt.periodUI($this$chargedAmountUI) != null) {
            String string3 = paymentInfo.getPaymentCurrency().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
            string2 = "0.00 " + string3;
        } else {
            string2 = null;
        }
        return string2;
    }

    /*
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final RecurrentTypeUI typeUI(@NotNull RecurrentInfo $this$typeUI) {
        RecurrentTypeUI recurrentTypeUI;
        block11: {
            block12: {
                block13: {
                    String string2;
                    Intrinsics.checkNotNullParameter((Object)$this$typeUI, (String)"<this>");
                    String string3 = string2 = $this$typeUI.getType();
                    if (string3 == null) break block11;
                    switch (string3.hashCode()) {
                        case 0: {
                            if (!string2.equals("")) {
                                return null;
                            }
                            break block12;
                        }
                        case 82: {
                            if (string2.equals("R")) break;
                            return null;
                        }
                        case 67: {
                            if (!string2.equals("C")) {
                                return null;
                            }
                            break block13;
                        }
                        case 85: {
                            if (!string2.equals("U")) {
                                return null;
                            }
                            break block13;
                        }
                        case 73: {
                            if (!string2.equals("I")) {
                                return null;
                            }
                            break block13;
                        }
                    }
                    recurrentTypeUI = RecurrentTypeUI.REGULAR;
                    return recurrentTypeUI;
                }
                recurrentTypeUI = RecurrentTypeUI.EXPRESS;
                return recurrentTypeUI;
            }
            recurrentTypeUI = RecurrentTypeUI.EXPRESS;
            return recurrentTypeUI;
        }
        recurrentTypeUI = RecurrentTypeUI.EXPRESS;
        return recurrentTypeUI;
        return null;
    }

    @Nullable
    public static final String expiryDateUI(@NotNull RecurrentInfo $this$expiryDateUI, @Nullable Locale locale) {
        Intrinsics.checkNotNullParameter((Object)$this$expiryDateUI, (String)"<this>");
        if ($this$expiryDateUI.getExpiryDay() == null || $this$expiryDateUI.getExpiryMonth() == null || $this$expiryDateUI.getExpiryYear() == null) {
            return null;
        }
        return StringExtensionsKt.patternDateToPatternDate($this$expiryDateUI.getExpiryDay() + "-" + $this$expiryDateUI.getExpiryMonth() + "-" + $this$expiryDateUI.getExpiryYear(), "dd-MM-yyyy", "MMMM dd, yyyy", locale);
    }

    @Nullable
    public static final String startDateUI(@NotNull RecurrentInfo $this$startDateUI, @Nullable Locale locale) {
        Intrinsics.checkNotNullParameter((Object)$this$startDateUI, (String)"<this>");
        String startDate = $this$startDateUI.getStartDate();
        if (startDate == null) {
            return null;
        }
        return StringExtensionsKt.patternDateToPatternDate(startDate, "dd-MM-yyyy", "MMMM dd, yyyy", locale);
    }

    public static final boolean isShowRecurringUI(@Nullable RecurrentInfo $this$isShowRecurringUI) {
        RecurrentInfo recurrentInfo = $this$isShowRecurringUI;
        if (recurrentInfo == null) {
            return false;
        }
        RecurrentInfo recurringInfo = recurrentInfo;
        return recurringInfo.getRegister();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RecurrentPeriod.values().length];
            try {
                nArray[RecurrentPeriod.DAILY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecurrentPeriod.WEEKLY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecurrentPeriod.MONTHLY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecurrentPeriod.QUARTERLY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecurrentPeriod.ANNUALLY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

