package kh.org.nbc.bakong_khqr.core;

import kh.org.nbc.bakong_khqr.utils.StringUtils;

public class TagLengthString implements TLV<String, String> {

    private String tag;

    private String value;

    public TagLengthString() {
        super();
    }

    public TagLengthString(final String tag, final String value) {
        this.tag = tag;
        this.value = value;
    }

    @Override
    public String getTag() {
        return tag;
    }

    @Override
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {

        if (StringUtils.isBlank(value)) {
            return StringUtils.EMPTY;
        }

        return String.format("%s%02d%s", tag, value.length(), value);
    }

}