package kh.org.nbc.bakong_khqr.model;

import kh.org.nbc.bakong_khqr.core.TagLengthString;
import kh.org.nbc.bakong_khqr.utils.StringUtils;
import kh.org.nbc.bakong_khqr.utils.BakongKHQRUtils;

import java.io.Serializable;

import static kh.org.nbc.bakong_khqr.model.KHQRMerchantPresentedCodes.*;

public class AdditionalDataField implements Serializable {

    private TagLengthString billNumber;
    private TagLengthString storeLabel;
    private TagLengthString terminalLabel;
    private TagLengthString mobileNumber;

    public final void setStoreLabel(final String storeLabel) {
        this.storeLabel = new TagLengthString(ADDITIONAL_DATA_FIELD_STORE_LABEL, storeLabel);
    }

    public final void setMobileNumber(final String mobileNumber) {
        this.mobileNumber = new TagLengthString(ADDITIONAL_DATA_FIELD_MOBILE_NUMBER, mobileNumber);
    }
    public final void setBillNumber(final String billNumber) {
        this.billNumber = new TagLengthString(ADDITIONAL_DATA_FIELD_BILL_NUMBER, billNumber);
    }

    public final void setTerminalLabel(final String terminalLabel) {
        this.terminalLabel = new TagLengthString(ADDITIONAL_DATA_FIELD_TERMINAL_LABEL, terminalLabel);
    }

    @Override
    public String toString() {

        final StringBuilder sb = new StringBuilder();

        sb.append(BakongKHQRUtils.ofNullable(billNumber));
        sb.append(BakongKHQRUtils.ofNullable(mobileNumber));
        sb.append(BakongKHQRUtils.ofNullable(storeLabel));
        sb.append(BakongKHQRUtils.ofNullable(terminalLabel));

        String string = sb.toString();
        if (StringUtils.isBlank(string)) {
            return StringUtils.EMPTY;
        }

        return string;
    }

}