package kh.org.nbc.bakong_khqr.model;


import kh.org.nbc.bakong_khqr.core.TLV;
import kh.org.nbc.bakong_khqr.utils.StringUtils;


public class AdditionalDataFieldTemplate implements TLV<String, AdditionalDataField> {

    private AdditionalDataField value;

    @Override
    public String getTag() {
        return KHQRMerchantPresentedCodes.ADDITIONAL_DATA_FIELD_TEMPLATE;
    }

    @Override
    public AdditionalDataField getValue() {
        return value;
    }

    @Override
    public String toString() {

        if (value == null) {
            return StringUtils.EMPTY;
        }

        final String string = value.toString();

        if (StringUtils.isBlank(string)) {
            return StringUtils.EMPTY;
        }

        return String.format("%s%02d%s", getTag(), string.length(), string);
    }

    public void setValue(AdditionalDataField value) {
        this.value = value;
    }

}
