package kh.org.nbc.bakong_khqr.model;

import java.util.HashMap;

public class KHQRErrorCode {
    public static final int BAKONG_ACCOUNT_ID_REQUIRED = 1;
    public static final int MERCHANT_NAME_REQUIRED = 2;
    public static final int BAKONG_ACCOUNT_ID_INVALID = 3;
    public static final int TRANSACTION_AMOUNT_INVALID = 4;
    public static final int MERCHANT_TYPE_REQUIRED = 5;
    public static final int BAKONG_ACCOUNT_ID_LENGTH_INVALID = 6;
    public static final int MERCHANT_NAME_LENGHT_INVALID = 7;
    public static final int KHQR_INVALID = 8;
    public static final int CURRENCY_TYPE_REQUIRED = 9;
    public static final int BILL_NUMBER_LENGTH_INVALID = 10;
    public static final int STORE_LABEL_LENGTH_INVALID = 11;
    public static final int TERMINAL_LABEL_LENGTH_INVALID = 12;
    public static final int CONNECTION_TIMEOUT = 13;
    public static final int INVALID_DEEP_LINK_SOURCE_INFO = 14;
    public static final int INTERNAL_SERVER_ERROR = 15;
    public static final int PAYLOAD_FORMAT_INDICATOR_LENGTH_INVALID = 16;
    public static final int POINT_OF_INITIATION_METHOD_LENGTH_INVALID = 17;
    public static final int MERCHANT_CATEGORY_CODE_LENGTH_INVALID = 18;
    public static final int TRANSACTION_CURRENCY_LENGTH_INVALID = 19;
    public static final int COUNTRY_CODE_LENGTH_INVALID = 20;
    public static final int MERCHANT_CITY_LENGTH_INVALID = 21;
    public static final int CRC_LENGTH_INVALID = 22;
    public static final int PAYLOAD_FORMAT_INDICATOR_REQUIRED = 23;
    public static final int CRC_REQUIRED = 24;
    public static final int MERCHANT_CATEGORY_CODE_REQUIRED = 25;
    public static final int COUNTRY_CODE_REQUIRED = 26;
    public static final int MERCHANT_CITY_REQUIRED = 27;
    public static final int UNSUPPORTED_TRANSACTION_CURRENCY = 28;
    public static final int INVALID_DEEP_LINK_URL = 29;
    public static final int MERCHANT_ID_REQUIRED = 30;
    public static final int ACQUIRING_BANK_REQUIRED = 31;
    public static final int MERCHANT_ID_LENGTH_INVALID = 32;
    public static final int ACQUIRING_BANK_LENGTH_INVALID = 33;
    public static final int MOBILE_NUMBER_LENGTH_INVALID = 34;
    public static final int TAG_NOT_IN_ORDER = 35;
    public static final int ACCOUNT_INFORMATION_LENGTH_INVALID = 36;



    public static final HashMap<Integer, String> errorCodeMap = new HashMap<Integer, String>() {{
        put(BAKONG_ACCOUNT_ID_REQUIRED, "Bakong Account ID cannot be null or empty");
        put(MERCHANT_NAME_REQUIRED, "Merchant name cannot be null or empty");
        put(BAKONG_ACCOUNT_ID_INVALID, "Bakong Account ID is invalid");
        put(TRANSACTION_AMOUNT_INVALID, "Amount is invalid");
        put(MERCHANT_TYPE_REQUIRED, "Merchant type cannot be null or empty");
        put(BAKONG_ACCOUNT_ID_LENGTH_INVALID, "Bakong Account ID Length is invalid");
        put(MERCHANT_NAME_LENGHT_INVALID, "Merchant Name Length is invalid");
        put(KHQR_INVALID, "KHQR provided is invalid");
        put(CURRENCY_TYPE_REQUIRED, "Currency type cannot be null or empty");
        put(BILL_NUMBER_LENGTH_INVALID, "Bill Number Length is invalid");
        put(STORE_LABEL_LENGTH_INVALID, "Store Label Length is invalid");
        put(TERMINAL_LABEL_LENGTH_INVALID, "Terminal Label Length is invalid");
        put(CONNECTION_TIMEOUT, "Cannot reach Bakong Open API service. Please check internet connection");
        put(INVALID_DEEP_LINK_SOURCE_INFO, "Source Info for Deep Link is invalid");
        put(INTERNAL_SERVER_ERROR, "Internal server error");
        put(PAYLOAD_FORMAT_INDICATOR_LENGTH_INVALID, "Payload Format Indicator Length is invalid");
        put(POINT_OF_INITIATION_METHOD_LENGTH_INVALID, "Point of Initiation Length is invalid");
        put(MERCHANT_CATEGORY_CODE_LENGTH_INVALID, "Merchant Category Length is invalid");
        put(TRANSACTION_CURRENCY_LENGTH_INVALID, "Transaction Currency Length is invalid");
        put(COUNTRY_CODE_LENGTH_INVALID, "Country Code Length is invalid");
        put(MERCHANT_CITY_LENGTH_INVALID, "Merchant City Length is invalid");
        put(CRC_LENGTH_INVALID, "CRC Length is invalid");
        put(PAYLOAD_FORMAT_INDICATOR_REQUIRED, "Payload Format Indicator cannot be null or empty");
        put(CRC_REQUIRED, "CRC cannot be null or empty");
        put(MERCHANT_CATEGORY_CODE_REQUIRED, "Merchant Category cannot be null or empty");
        put(COUNTRY_CODE_REQUIRED, "Country Code cannot be null or empty");
        put(MERCHANT_CITY_REQUIRED, "Merchant City cannot be null or empty");
        put(UNSUPPORTED_TRANSACTION_CURRENCY, "Unsupported currency");
        put(INVALID_DEEP_LINK_URL, "Deep Link URL is not valid");
        put(MERCHANT_ID_REQUIRED,  "Merchant ID cannot be null or empty");
        put(ACQUIRING_BANK_REQUIRED, "Acquiring Bank cannot be null or empty");
        put(MERCHANT_ID_LENGTH_INVALID, "Merchant ID Length is invalid");
        put(ACQUIRING_BANK_LENGTH_INVALID, "Acquiring Bank Length is invalid");
        put(MOBILE_NUMBER_LENGTH_INVALID, "Mobile Number Length is invalid");
        put(TAG_NOT_IN_ORDER, "Tag is not in order");
        put(ACCOUNT_INFORMATION_LENGTH_INVALID, "Account Information Length is invalid");
    }};


}
