package kh.org.nbc.bakong_khqr.model;

import kh.org.nbc.bakong_khqr.core.TagLengthString;
import kh.org.nbc.bakong_khqr.utils.StringUtils;

import java.io.Serializable;

import static kh.org.nbc.bakong_khqr.model.KHQRMerchantPresentedCodes.*;


public class MerchantAccountInformation implements Serializable {


    // Globally Unique Identifier
    private TagLengthString globallyUniqueIdentifier;
    private TagLengthString merchantId;
    private TagLengthString accountInformation;
    private TagLengthString acquiringBank;

    public MerchantAccountInformation() {
        super();
    }

    public MerchantAccountInformation(final String globallyUniqueIdentifier) {
        this.setGloballyUniqueIdentifier(globallyUniqueIdentifier);
    }

    public MerchantAccountInformation(final String globallyUniqueIdentifier, final String tag, final String value) {
        this.setGloballyUniqueIdentifier(globallyUniqueIdentifier, tag, value);
    }

    public final void setGloballyUniqueIdentifier(final String globallyUniqueIdentifier) {
        this.globallyUniqueIdentifier = new TagLengthString(MERCHANT_ACCOUNT_INFORMATION_GLOBALLY_UNIQUE_IDENTIFIER, globallyUniqueIdentifier);
    }

    public final void setMerchantId(final String merchantId) {
        this.merchantId = new TagLengthString(MERCHANT_ACCOUNT_INFORMATION_MERCHANT_ID, merchantId);
    }

    public final void setAccountInformation(final String accountInformation) {
        this.accountInformation = new TagLengthString(MERCHANT_ACCOUNT_INFORMATION_MERCHANT_ID, accountInformation);
    }

    public final void setAcquiringBank(final String acquireBank) {
        this.acquiringBank = new TagLengthString(MERCHANT_ACCOUNT_INFORMATION_ACQUIRING_BANK, acquireBank);
    }

    public final void setGloballyUniqueIdentifier(final String globallyUniqueIdentifier, final String tag, final String value) {
        this.globallyUniqueIdentifier = new TagLengthString(MERCHANT_ACCOUNT_INFORMATION_GLOBALLY_UNIQUE_IDENTIFIER, globallyUniqueIdentifier);
    }

    @Override
    public String toString() {

        final StringBuilder sb = new StringBuilder();

        if (globallyUniqueIdentifier != null) {
            sb.append(globallyUniqueIdentifier.toString());
        }
        if (merchantId != null) {
            sb.append(merchantId.toString());
        }
        if (accountInformation != null) {
            sb.append(accountInformation.toString());
        }
        if (acquiringBank != null) {
            sb.append(acquiringBank.toString());
        }

        final String string = sb.toString();

        if (StringUtils.isBlank(string)) {
            return StringUtils.EMPTY;
        }

        return string;
    }

}
