package kh.org.nbc.bakong_khqr.model;

import kh.org.nbc.bakong_khqr.core.TLV;
import kh.org.nbc.bakong_khqr.utils.StringUtils;


public class MerchantAccountInformationTemplate implements TLV<String, MerchantAccountInformation> {

    private String tag;

    private MerchantAccountInformation value;

    public MerchantAccountInformationTemplate() {
        super();
    }

    public MerchantAccountInformationTemplate(final String tag) {
        this.setTag(tag);
    }

    public MerchantAccountInformationTemplate(final String tag, final String globallyUniqueIdentifier) {
        this.setTag(tag);
        this.setValue(new MerchantAccountInformation(globallyUniqueIdentifier));
    }

    public void addPaymentNetworkSpecific(final String tag, final String value) {
        if (this.getValue() == null) {
            this.setValue(new MerchantAccountInformation());
        } else {
            this.setValue(this.getValue());
        }
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setValue(MerchantAccountInformation value) {
        this.value = value;
    }

    @Override
    public String getTag() {
        return tag;
    }

    @Override
    public MerchantAccountInformation getValue() {
        return value;
    }

    @Override
    public String toString() {

        if (value == null) {
            return StringUtils.EMPTY;
        }

        final String string = value.toString();

        if (StringUtils.isBlank(string)) {
            return StringUtils.EMPTY;
        }

        return String.format("%s%02d%s", tag, string.length(), string);
    }
}
