package kh.org.nbc.bakong_khqr.model;

import kh.org.nbc.bakong_khqr.core.TagLengthString;
import kh.org.nbc.bakong_khqr.utils.StringUtils;
import kh.org.nbc.bakong_khqr.utils.BakongKHQRUtils;

import java.io.Serializable;

import static kh.org.nbc.bakong_khqr.model.KHQRMerchantPresentedCodes.TIMESTAMP;

public class RfuForKhqr implements Serializable {

    // TimeStamp
    private TagLengthString timeStamp;


    public final void setTimeStamp(final String timeStamp) {
        this.timeStamp = new TagLengthString(TIMESTAMP, timeStamp);
    }

    @Override
    public String toString() {

        final StringBuilder sb = new StringBuilder();

        sb.append(BakongKHQRUtils.ofNullable(timeStamp));

        String string = sb.toString();
        if (StringUtils.isBlank(string)) {
            return StringUtils.EMPTY;
        }

        return string;
    }

}