package kh.org.nbc.bakong_khqr.model;

import kh.org.nbc.bakong_khqr.core.TLV;
import kh.org.nbc.bakong_khqr.utils.StringUtils;

import static kh.org.nbc.bakong_khqr.model.KHQRMerchantPresentedCodes.RFU_FOR_KHQR;

public class RfuForKhqrTemplate implements TLV<String, RfuForKhqr> {

    private RfuForKhqr value;

    @Override
    public String getTag() {
        return RFU_FOR_KHQR;
    }

    @Override
    public RfuForKhqr getValue() {
        return value;
    }

    @Override
    public String toString() {

        if (value == null) {
            return StringUtils.EMPTY;
        }

        final String string = value.toString();

        if (StringUtils.isBlank(string)) {
            return StringUtils.EMPTY;
        }

        return String.format("%s%02d%s", getTag(), string.length(), string);
    }

    public void setValue(RfuForKhqr value) {
        this.value = value;
    }

}
