package kh.org.nbc.bakong_khqr.presenter;

import kh.org.nbc.bakong_khqr.core.CRC;
import kh.org.nbc.bakong_khqr.core.TagLengthString;
import kh.org.nbc.bakong_khqr.model.*;
import kh.org.nbc.bakong_khqr.utils.StringUtils;
import kh.org.nbc.bakong_khqr.utils.BakongKHQRUtils;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;


public class MerchantPresentedMode implements Serializable {

    // Payload Format Indicator
    private TagLengthString payloadFormatIndicator;

    // Point of Initiation Method
    private TagLengthString pointOfInitiationMethod;

    // Merchant Account Information
    private final Map<String, MerchantAccountInformationTemplate> merchantAccountInformation = new LinkedHashMap<>();

    // Merchant Category Code
    private TagLengthString merchantCategoryCode;

    // Transaction Currency
    private TagLengthString transactionCurrency;

    // Transaction Amount
    private TagLengthString transactionAmount;

    private TagLengthString countryCode;

    // Merchant Name
    private TagLengthString merchantName;

    // Merchant City
    private TagLengthString merchantCity;

    // Additional Data Field Template
    private AdditionalDataFieldTemplate additionalDataField;

    // Additional Data Field Template
    private RfuForKhqrTemplate rfuForKhqr;


  
    public final void setPayloadFormatIndicator(final String payloadFormatIndicator) {
        this.payloadFormatIndicator = new TagLengthString(KHQRMerchantPresentedCodes.PAYLOAD_FORMAT_INDICATOR, payloadFormatIndicator);
    }

    public final void setPointOfInitiationMethod(final String pointOfInitiationMethod) {
        this.pointOfInitiationMethod = new TagLengthString(KHQRMerchantPresentedCodes.POINT_OF_INITIATION_METHOD, pointOfInitiationMethod);
    }

    public final void setMerchantCategoryCode(final String merchantCategoryCode) {
        this.merchantCategoryCode = new TagLengthString(KHQRMerchantPresentedCodes.MERCHANT_CATEGORY_CODE, merchantCategoryCode);
    }

    public final void setTransactionCurrency(final String transactionCurrency) {
        this.transactionCurrency = new TagLengthString(KHQRMerchantPresentedCodes.TRANSACTION_CURRENCY, transactionCurrency);
    }

    public final void setTransactionAmount(final String transactionAmount) {
        this.transactionAmount = new TagLengthString(KHQRMerchantPresentedCodes.TRANSACTION_AMOUNT, transactionAmount);
    }

    public final void setCountryCode(final String countryCode) {
        this.countryCode = new TagLengthString(KHQRMerchantPresentedCodes.COUNTRY_CODE, countryCode);
    }

    public final void setMerchantName(final String merchantName) {
        this.merchantName = new TagLengthString(KHQRMerchantPresentedCodes.MERCHANT_NAME, merchantName);
    }

    public final void setMerchantCity(final String merchantCity) {
        this.merchantCity = new TagLengthString(KHQRMerchantPresentedCodes.MERCHANT_CITY, merchantCity);
    }


    public final void addMerchantAccountInformation(final MerchantAccountInformationTemplate merchantAccountInformation) {
        this.merchantAccountInformation.put(merchantAccountInformation.getTag(), merchantAccountInformation);
    }

    public void setAdditionalDataField(final AdditionalDataFieldTemplate additionalDataField) {
        this.additionalDataField = additionalDataField;
    }

    private void setRfuForKhqr(){
        RfuForKhqr rfuForKhqr = new RfuForKhqr();
        rfuForKhqr.setTimeStamp(String.valueOf(Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTimeInMillis()));

        RfuForKhqrTemplate rfuForKhqrTemplate = new RfuForKhqrTemplate();
        rfuForKhqrTemplate.setValue(rfuForKhqr);
        this.rfuForKhqr =  rfuForKhqrTemplate;

    }


    @Override
    public String toString() {

        setRfuForKhqr();

        final StringBuilder sb = new StringBuilder(this.toStringWithoutCrc16());

        final String string = sb.toString();

        if (StringUtils.isBlank(string)) {
            return StringUtils.EMPTY;
        }

        final int crc16 = CRC.crc16(sb.toString().getBytes(StandardCharsets.UTF_8));

        sb.append(String.format("%04X", crc16));

        return sb.toString();
    }

    public String toStringWithoutCrc16() {
        final StringBuilder sb = new StringBuilder();

        sb.append(BakongKHQRUtils.ofNullable(payloadFormatIndicator));
        sb.append(BakongKHQRUtils.ofNullable(pointOfInitiationMethod));

        for (final Map.Entry<String, MerchantAccountInformationTemplate> entry : merchantAccountInformation.entrySet()) {
            sb.append(BakongKHQRUtils.ofNullable(entry.getValue()));
        }
        sb.append(BakongKHQRUtils.ofNullable(merchantCategoryCode));
        sb.append(BakongKHQRUtils.ofNullable(transactionCurrency));
        sb.append(BakongKHQRUtils.ofNullable(transactionAmount));
        sb.append(BakongKHQRUtils.ofNullable(countryCode));
        sb.append(BakongKHQRUtils.ofNullable(merchantName));
        sb.append(BakongKHQRUtils.ofNullable(merchantCity));
        sb.append(BakongKHQRUtils.ofNullable(additionalDataField));
        sb.append(BakongKHQRUtils.ofNullable(rfuForKhqr));

        final String string = sb.toString();

        if (StringUtils.isBlank(string)) {
            return StringUtils.EMPTY;
        }

        sb.append(String.format("%s%s", KHQRMerchantPresentedCodes.CRC, "04"));

        return sb.toString();
    }
}