package kh.org.nbc.bakong_khqr.utils;

import kh.org.nbc.bakong_khqr.core.CRC;

import java.nio.charset.StandardCharsets;

public class BakongKHQRUtils {
    public static String getChecksumResult(String dataPayload) {
        final byte[] buffer = dataPayload.getBytes();

        /* Note the change here */
        int crc = 0xFFFF;
        for (byte b : buffer) {
            crc = ((crc >>> 8) | (crc << 8)) & 0xffff;
            crc ^= (b & 0xff);//byte to int, trunc sign
            crc ^= ((crc & 0xff) >> 4);
            crc ^= (crc << 12) & 0xffff;
            crc ^= ((crc & 0xFF) << 5) & 0xffff;
        }
        crc &= 0xffff;
        return String.format("%4s", Integer.toHexString(crc).toUpperCase()).replace(' ', '0');
    }

    public static String ofNullable(Object object) {
        if (object == null) {
            return StringUtils.EMPTY;
        } else return object.toString();
    }

    public static String getCRC(String data) {
        //crc tag and length(6304)
        final int crc16 = CRC.crc16((data + "6304").getBytes(StandardCharsets.UTF_8));

        return String.format("%04X", crc16);
    }
}
