/*
 * Decompiled with CFR 0.152.
 */
package kr.bydelta.koala.data;

import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kr.bydelta.koala.POS;
import kr.bydelta.koala.Util;
import kr.bydelta.koala.data.AlreadySetIDException;
import kr.bydelta.koala.data.CanHaveProperty;
import kr.bydelta.koala.data.Entity;
import kr.bydelta.koala.data.Key;
import kr.bydelta.koala.data.ListProperty;
import kr.bydelta.koala.data.Property;
import kr.bydelta.koala.data.Word;
import kr.bydelta.koala.data.WordSense;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 12\u00020\u0001:\u00011B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0014\u001a\u00020\u0003H\u0086\u0002J\t\u0010\u0015\u001a\u00020\u0005H\u0086\u0002J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\u000e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0000J\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001dJ\b\u0010\u001f\u001a\u0004\u0018\u00010 J\b\u0010!\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u0003J\u000e\u0010$\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u0003J\u001f\u0010%\u001a\u00020\u00172\u0012\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030'\"\u00020\u0003\u00a2\u0006\u0002\u0010(J\b\u0010)\u001a\u00020\tH\u0016J\u0006\u0010*\u001a\u00020\u0017J\u0006\u0010+\u001a\u00020\u0017J\u0006\u0010,\u001a\u00020\u0017J\u0006\u0010-\u001a\u00020\u0017J\u000e\u0010.\u001a\u00020/2\u0006\u0010\n\u001a\u00020\u0003J\b\u00100\u001a\u00020\u0003H\u0016R$\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00062"}, d2={"Lkr/bydelta/koala/data/Morpheme;", "Lkr/bydelta/koala/data/CanHaveProperty;", "surface", "", "tag", "Lkr/bydelta/koala/POS;", "originalTag", "(Ljava/lang/String;Lkr/bydelta/koala/POS;Ljava/lang/String;)V", "value", "", "id", "getId", "()I", "setId$koalanlp_core", "(I)V", "getOriginalTag", "()Ljava/lang/String;", "getSurface", "getTag", "()Lkr/bydelta/koala/POS;", "component1", "component2", "equals", "", "other", "", "equalsWithoutTag", "another", "getEntities", "", "Lkr/bydelta/koala/data/Entity;", "getWord", "Lkr/bydelta/koala/data/Word;", "getWordSense", "hasOriginalTag", "partialTag", "hasTag", "hasTagOneOf", "tags", "", "([Ljava/lang/String;)Z", "hashCode", "isJosa", "isModifier", "isNoun", "isPredicate", "setWordSense", "", "toString", "Companion", "koalanlp-core"})
public final class Morpheme
extends CanHaveProperty {
    private int id;
    @NotNull
    private final String surface;
    @NotNull
    private final POS tag;
    @Nullable
    private final String originalTag;
    private static final long serialVersionUid = 512L;
    public static final Companion Companion = new Companion(null);

    public final int getId() {
        return this.id;
    }

    public final void setId$koalanlp_core(int value) throws AlreadySetIDException {
        if (this.id != -1) {
            throw (Throwable)new AlreadySetIDException();
        }
        this.id = value;
    }

    public final void setWordSense(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        this.setProperty$koalanlp_core(Key.WORD_SENSE, (Property)new WordSense(id));
    }

    @Nullable
    public final String getWordSense() {
        WordSense wordSense = (WordSense)this.getProperty$koalanlp_core(Key.WORD_SENSE);
        return wordSense != null ? wordSense.getId() : null;
    }

    @Nullable
    public final List<Entity> getEntities() {
        ListProperty listProperty = (ListProperty)this.getProperty$koalanlp_core(Key.NAMED_ENTITY);
        return listProperty != null ? listProperty.getValues$koalanlp_core() : null;
    }

    @Nullable
    public final Word getWord() {
        return (Word)this.getProperty$koalanlp_core(Key.WORD);
    }

    public final boolean isNoun() {
        return this.tag.isNoun();
    }

    public final boolean isPredicate() {
        return this.tag.isPredicate();
    }

    public final boolean isModifier() {
        return this.tag.isModifier();
    }

    public final boolean isJosa() {
        return this.tag.isPostPosition();
    }

    public final boolean hasTag(@NotNull String partialTag) {
        Intrinsics.checkParameterIsNotNull((Object)partialTag, (String)"partialTag");
        return this.tag.startsWith(partialTag);
    }

    public final boolean hasTagOneOf(String ... tags) {
        boolean bl;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)tags, (String)"tags");
            String[] $this$any$iv = tags;
            boolean $i$f$any = false;
            String[] stringArray = $this$any$iv;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = stringArray[i];
                boolean bl2 = false;
                if (!Util.contains(it, this.tag)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasOriginalTag(@NotNull String partialTag) {
        Intrinsics.checkParameterIsNotNull((Object)partialTag, (String)"partialTag");
        String string = this.originalTag;
        String string2 = string;
        if (string == null) return false;
        String string3 = string2;
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toUpperCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toUpperCase()");
        string2 = string5;
        if (string5 == null) return false;
        string3 = partialTag;
        String string6 = string2;
        bl = false;
        String string7 = string3.toUpperCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).toUpperCase()");
        String string8 = string7;
        boolean bl2 = StringsKt.startsWith$default((String)string6, (String)string8, (boolean)false, (int)2, null);
        return bl2;
    }

    public boolean equals(@Nullable Object other) {
        Object object = other;
        return object instanceof Morpheme ? Intrinsics.areEqual((Object)((Morpheme)other).surface, (Object)this.surface) && ((Morpheme)other).tag == this.tag : false;
    }

    public final boolean equalsWithoutTag(@NotNull Morpheme another) {
        Intrinsics.checkParameterIsNotNull((Object)another, (String)"another");
        return Intrinsics.areEqual((Object)another.surface, (Object)this.surface);
    }

    public int hashCode() {
        int n = this.surface.hashCode();
        boolean $i$f$getPOS_SIZE = false;
        int n2 = POS.values().length;
        return n * n2 + this.tag.hashCode();
    }

    @NotNull
    public String toString() {
        return this.originalTag != null ? this.surface + '/' + (Object)((Object)this.tag) + '(' + this.originalTag + ')' : this.surface + '/' + (Object)((Object)this.tag);
    }

    @NotNull
    public final String component1() {
        return this.surface;
    }

    @NotNull
    public final POS component2() {
        return this.tag;
    }

    @NotNull
    public final String getSurface() {
        return this.surface;
    }

    @NotNull
    public final POS getTag() {
        return this.tag;
    }

    @Nullable
    public final String getOriginalTag() {
        return this.originalTag;
    }

    public Morpheme(@NotNull String surface, @NotNull POS tag, @Nullable String originalTag) {
        Intrinsics.checkParameterIsNotNull((Object)surface, (String)"surface");
        Intrinsics.checkParameterIsNotNull((Object)((Object)tag), (String)"tag");
        this.surface = surface;
        this.tag = tag;
        this.originalTag = originalTag;
        this.id = -1;
    }

    public /* synthetic */ Morpheme(String string, POS pOS, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        this(string, pOS, string2);
    }

    static {
        serialVersionUid = 512L;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0002X\u0083D\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lkr/bydelta/koala/data/Morpheme$Companion;", "", "()V", "serialVersionUid", "", "serialVersionUid$annotations", "koalanlp-core"})
    public static final class Companion {
        @JvmStatic
        private static /* synthetic */ void serialVersionUid$annotations() {
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

