/*
 * Decompiled with CFR 0.152.
 */
package kr.co.linkhub.auth;

public class Base64 {
    private static final char[] encodeTable;
    private static final byte[] decodeTable;
    private static final byte PADDING = 127;

    public static char getEncode(int i) {
        return encodeTable[i & 0x3F];
    }

    public static String encode(byte[] input) {
        char[] result = new char[(input.length + 2) / 3 * 4];
        int resultIndex = 0;
        int checkLength = 0;
        for (int i = 0; i < input.length; i += 3) {
            checkLength = input.length - i;
            if (checkLength == 2) {
                result[resultIndex++] = Base64.getEncode(input[i] >> 2);
                result[resultIndex++] = Base64.getEncode((input[i] & 3) << 4 | input[i + 1] >> 4 & 0xF);
                result[resultIndex++] = Base64.getEncode((input[i + 1] & 0xF) << 2);
                result[resultIndex++] = 61;
                continue;
            }
            if (checkLength == 1) {
                result[resultIndex++] = Base64.getEncode(input[i] >> 2);
                result[resultIndex++] = Base64.getEncode((input[i] & 3) << 4);
                result[resultIndex++] = 61;
                result[resultIndex++] = 61;
                continue;
            }
            result[resultIndex++] = Base64.getEncode(input[i] >> 2);
            result[resultIndex++] = Base64.getEncode((input[i] & 3) << 4 | input[i + 1] >> 4 & 0xF);
            result[resultIndex++] = Base64.getEncode((input[i + 1] & 0xF) << 2 | input[i + 2] >> 6 & 3);
            result[resultIndex++] = Base64.getEncode(input[i + 2] & 0x3F);
        }
        return new String(result);
    }

    public static byte[] decode(String input) {
        int resultLength = Base64.getResultLength(input);
        byte[] result = new byte[resultLength];
        int resultIndex = 0;
        byte[] splitBuff = new byte[4];
        int bufIndex = 0;
        for (int i = 0; i < input.length(); ++i) {
            char inputChar = input.charAt(i);
            byte decodeValue = decodeTable[inputChar];
            if (decodeValue != -1) {
                splitBuff[bufIndex++] = decodeValue;
            }
            if (bufIndex != 4) continue;
            result[resultIndex++] = (byte)(splitBuff[0] << 2 | splitBuff[1] >> 4);
            if (splitBuff[2] != 127) {
                result[resultIndex++] = (byte)(splitBuff[1] << 4 | splitBuff[2] >> 2);
            }
            if (splitBuff[3] != 127) {
                result[resultIndex++] = (byte)(splitBuff[2] << 6 | splitBuff[3]);
            }
            bufIndex = 0;
        }
        return result;
    }

    private static int getResultLength(String input) {
        int paddingCheck;
        int inputLength = input.length();
        int paddingSize = 0;
        for (paddingCheck = inputLength - 1; paddingCheck >= 0; --paddingCheck) {
            byte code = decodeTable[input.charAt(paddingCheck)];
            if (code == 127) continue;
            if (code != -1) break;
            return input.length() / 4 * 3;
        }
        paddingSize = inputLength - ++paddingCheck;
        return input.length() / 4 * 3 - paddingSize;
    }

    static {
        int i;
        encodeTable = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        decodeTable = new byte[128];
        for (i = 0; i < decodeTable.length; ++i) {
            Base64.decodeTable[i] = -1;
        }
        for (i = 0; i < encodeTable.length; ++i) {
            Base64.decodeTable[Base64.encodeTable[i]] = (byte)i;
        }
        Base64.decodeTable[61] = 127;
    }
}

