/*
 * Decompiled with CFR 0.152.
 */
package kr.co.linkhub.auth;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import java.util.zip.GZIPInputStream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kr.co.linkhub.auth.Base64;
import kr.co.linkhub.auth.LinkhubException;
import kr.co.linkhub.auth.Token;

public class TokenBuilder {
    private static final String HMAC_SHA256_ALGORITHM = "HmacSHA256";
    private static final String APIVersion = "2.0";
    private static final String DefaultServiceURL = "https://auth.linkhub.co.kr";
    private String _ServiceURL;
    private String _ProxyIP;
    private Integer _ProxyPort;
    private String _LinkID;
    private String _SecretKey;
    private Gson _gsonParser = new Gson();
    private String _recentServiceID;
    private List<String> _recentScope;
    private boolean _useLocalTime;
    private static TokenBuilder _singleTone;

    private TokenBuilder() {
    }

    @Deprecated
    public static TokenBuilder getInstance(String LinkID, String SecretKey) {
        if (_singleTone == null) {
            _singleTone = new TokenBuilder();
        }
        TokenBuilder._singleTone._LinkID = LinkID;
        TokenBuilder._singleTone._SecretKey = SecretKey;
        TokenBuilder._singleTone._ServiceURL = DefaultServiceURL;
        return _singleTone;
    }

    public static TokenBuilder newInstance(String LinkID, String SecretKey) {
        TokenBuilder _singleTone = new TokenBuilder();
        _singleTone._LinkID = LinkID;
        _singleTone._SecretKey = SecretKey;
        _singleTone._ServiceURL = DefaultServiceURL;
        return _singleTone;
    }

    public void setServiceURL(String URL) {
        this._ServiceURL = URL;
    }

    public TokenBuilder ServiceID(String ServiceID) {
        this._recentServiceID = ServiceID;
        return this;
    }

    public void setProxyIP(String IP) {
        this._ProxyIP = IP;
    }

    public void setProxyPort(int PORT) {
        this._ProxyPort = PORT;
    }

    public TokenBuilder addScope(String scope) {
        if (this._recentScope == null) {
            this._recentScope = new ArrayList<String>();
        }
        if (!this._recentScope.contains(scope)) {
            this._recentScope.add(scope);
        }
        return this;
    }

    public TokenBuilder useLocalTimeYN(boolean useLocalTimeYN) {
        this._useLocalTime = useLocalTimeYN;
        return this;
    }

    public Token build() throws LinkhubException {
        return this.build(null, null);
    }

    public Token buildWithIP(String ForwardedIP) throws LinkhubException {
        return this.build(null, ForwardedIP);
    }

    public Token build(String AccessID) throws LinkhubException {
        return this.build(AccessID, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token build(String AccessID, String forwardedIP) throws LinkhubException {
        byte[] btSecetKey;
        HttpURLConnection httpURLConnection;
        if (this._recentServiceID == null || this._recentServiceID.isEmpty()) {
            throw new LinkhubException(-99999999L, "\uc11c\ube44\uc2a4\uc544\uc774\ub514\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String URI2 = "/" + this._recentServiceID + "/Token";
        try {
            URL url = new URL(this._ServiceURL + URI2);
            if (this._ProxyIP != null && this._ProxyPort != null) {
                Proxy prx = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this._ProxyIP, (int)this._ProxyPort));
                httpURLConnection = (HttpURLConnection)url.openConnection(prx);
            } else {
                httpURLConnection = (HttpURLConnection)url.openConnection();
            }
        }
        catch (Exception e) {
            throw new LinkhubException(-99999999L, "\ub9c1\ud06c\ud5c8\ube0c \uc11c\ubc84 \uc811\uc18d \uc2e4\ud328", e);
        }
        TokenRequest request = new TokenRequest();
        request.access_id = AccessID;
        request.scope = this._recentScope;
        String PostData = this._gsonParser.toJson((Object)request);
        byte[] btPostData = PostData.getBytes(Charset.forName("UTF-8"));
        String invokeTime = this.getTime();
        String signTarget = "POST\n";
        signTarget = signTarget + TokenBuilder.sha256Base64(btPostData) + "\n";
        signTarget = signTarget + invokeTime + "\n";
        if (forwardedIP != null && !forwardedIP.isEmpty()) {
            signTarget = signTarget + forwardedIP + "\n";
        }
        signTarget = signTarget + "2.0\n";
        signTarget = signTarget + URI2;
        try {
            btSecetKey = Base64.decode(this.getSecretKey());
        }
        catch (Exception e) {
            throw new LinkhubException(-99999999L, "Fail to decode SecretKey, Please check your SecretKey.", e);
        }
        String Signature = Base64.encode(TokenBuilder.HMacSha256(btSecetKey, signTarget.getBytes(Charset.forName("UTF-8"))));
        httpURLConnection.setRequestProperty("x-lh-date".toLowerCase(), invokeTime);
        httpURLConnection.setRequestProperty("x-lh-version".toLowerCase(), APIVersion);
        if (forwardedIP != null && !forwardedIP.isEmpty()) {
            httpURLConnection.setRequestProperty("x-lh-forwarded".toLowerCase(), forwardedIP);
        }
        httpURLConnection.setRequestProperty("Authorization", "LINKHUB " + this.getLinkID() + " " + Signature);
        httpURLConnection.setRequestProperty("Content-Type", "application/json; charset=utf8");
        httpURLConnection.setRequestProperty("Content-Length", String.valueOf(btPostData.length));
        FilterOutputStream output = null;
        try {
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setDoOutput(true);
            output = new DataOutputStream(httpURLConnection.getOutputStream());
            output.write(btPostData);
            ((DataOutputStream)output).flush();
        }
        catch (Exception e) {
            throw new LinkhubException(-99999999L, "Fail to POST data to Server.", e);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e1) {
                    throw new LinkhubException(-99999999L, "Linkhub TokenBuilder build func output stream close exception.", e1);
                }
            }
        }
        String Result = "";
        InputStream input = null;
        try {
            input = httpURLConnection.getInputStream();
            Result = null != httpURLConnection.getContentEncoding() && httpURLConnection.getContentEncoding().equals("gzip") ? TokenBuilder.fromGzipStream(input) : TokenBuilder.fromStream(input);
        }
        catch (IOException e) {
            Error error;
            block44: {
                error = null;
                InputStream is = null;
                try {
                    is = httpURLConnection.getErrorStream();
                    Result = TokenBuilder.fromStream(is);
                    error = (Error)this._gsonParser.fromJson(Result, Error.class);
                }
                catch (Exception e3) {
                    if (is == null) break block44;
                    try {
                        is.close();
                    }
                    catch (IOException e32) {
                        throw new LinkhubException(-99999999L, "Linkhub TokenBuilder build func Error inputstream close exception.", e32);
                    }
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e3) {
                            throw new LinkhubException(-99999999L, "Linkhub TokenBuilder build func Error inputstream close exception.", e3);
                        }
                    }
                }
            }
            if (error == null) {
                throw new LinkhubException(-99999999L, "Fail to receive data from Server.", e);
            }
            throw new LinkhubException(error.code, error.message);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e1) {
                    throw new LinkhubException(-99999999L, "Linkhub TokenBuilder build func input stream close exception.", e1);
                }
            }
        }
        return (Token)this._gsonParser.fromJson(Result, Token.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getBalance(String BearerToken) throws LinkhubException {
        HttpURLConnection httpURLConnection;
        if (BearerToken == null || BearerToken.isEmpty()) {
            throw new LinkhubException(-99999999L, "BearerToken\uc774 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (this._recentServiceID == null || this._recentServiceID.isEmpty()) {
            throw new LinkhubException(-99999999L, "\uc11c\ube44\uc2a4\uc544\uc774\ub514\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String URI2 = "/" + this._recentServiceID + "/Point";
        try {
            URL url = new URL(this._ServiceURL + URI2);
            if (this._ProxyIP != null && this._ProxyPort != null) {
                Proxy prx = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this._ProxyIP, (int)this._ProxyPort));
                httpURLConnection = (HttpURLConnection)url.openConnection(prx);
            } else {
                httpURLConnection = (HttpURLConnection)url.openConnection();
            }
        }
        catch (Exception e) {
            throw new LinkhubException(-99999999L, "\ub9c1\ud06c\ud5c8\ube0c \uc11c\ubc84 \uc811\uc18d \uc2e4\ud328", e);
        }
        httpURLConnection.setRequestProperty("Authorization", "Bearer " + BearerToken);
        String Result = "";
        InputStream input = null;
        try {
            input = httpURLConnection.getInputStream();
            Result = null != httpURLConnection.getContentEncoding() && httpURLConnection.getContentEncoding().equals("gzip") ? TokenBuilder.fromGzipStream(input) : TokenBuilder.fromStream(input);
        }
        catch (IOException e) {
            Error error;
            block30: {
                error = null;
                InputStream is = null;
                try {
                    is = httpURLConnection.getErrorStream();
                    Result = TokenBuilder.fromStream(is);
                    error = (Error)this._gsonParser.fromJson(Result, Error.class);
                }
                catch (Exception e1) {
                    if (is == null) break block30;
                    try {
                        is.close();
                    }
                    catch (IOException e12) {
                        throw new LinkhubException(-99999999L, "Linkhub getBalance func Error inputstream close exception.", e);
                    }
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e1) {
                            throw new LinkhubException(-99999999L, "Linkhub getBalance func Error inputstream close exception.", e);
                        }
                    }
                }
            }
            if (error == null) {
                throw new LinkhubException(-99999999L, "Fail to receive data from Server.", e);
            }
            throw new LinkhubException(error.code, error.message);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    throw new LinkhubException(-99999999L, "Linkhub getBalance func inputstream close exception.", e);
                }
            }
        }
        return ((PointResult)this._gsonParser.fromJson(Result, PointResult.class)).getRemainPoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getPartnerBalance(String BearerToken) throws LinkhubException {
        HttpURLConnection httpURLConnection;
        if (BearerToken == null || BearerToken.isEmpty()) {
            throw new LinkhubException(-99999999L, "BearerToken\uc774 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (this._recentServiceID == null || this._recentServiceID.isEmpty()) {
            throw new LinkhubException(-99999999L, "\uc11c\ube44\uc2a4\uc544\uc774\ub514\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String URI2 = "/" + this._recentServiceID + "/PartnerPoint";
        try {
            URL url = new URL(this._ServiceURL + URI2);
            if (this._ProxyIP != null && this._ProxyPort != null) {
                Proxy prx = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this._ProxyIP, (int)this._ProxyPort));
                httpURLConnection = (HttpURLConnection)url.openConnection(prx);
            } else {
                httpURLConnection = (HttpURLConnection)url.openConnection();
            }
        }
        catch (Exception e) {
            throw new LinkhubException(-99999999L, "\ub9c1\ud06c\ud5c8\ube0c \uc11c\ubc84 \uc811\uc18d \uc2e4\ud328", e);
        }
        httpURLConnection.setRequestProperty("Authorization", "Bearer " + BearerToken);
        String Result = "";
        InputStream input = null;
        try {
            input = httpURLConnection.getInputStream();
            Result = null != httpURLConnection.getContentEncoding() && httpURLConnection.getContentEncoding().equals("gzip") ? TokenBuilder.fromGzipStream(input) : TokenBuilder.fromStream(input);
        }
        catch (IOException e) {
            Error error;
            block30: {
                error = null;
                InputStream is = null;
                try {
                    is = httpURLConnection.getErrorStream();
                    Result = TokenBuilder.fromStream(is);
                    error = (Error)this._gsonParser.fromJson(Result, Error.class);
                }
                catch (Exception e1) {
                    if (is == null) break block30;
                    try {
                        is.close();
                    }
                    catch (IOException e12) {
                        throw new LinkhubException(-99999999L, "Linkhub getPartnerBalance func Error inputstream close exception.", e);
                    }
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e1) {
                            throw new LinkhubException(-99999999L, "Linkhub getPartnerBalance func Error inputstream close exception.", e);
                        }
                    }
                }
            }
            if (error == null) {
                throw new LinkhubException(-99999999L, "Fail to receive data from Server.", e);
            }
            throw new LinkhubException(error.code, error.message);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    throw new LinkhubException(-99999999L, "Linkhub getPartnerBalance func input stream close exception.", e);
                }
            }
        }
        return ((PointResult)this._gsonParser.fromJson(Result, PointResult.class)).getRemainPoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPartnerURL(String BearerToken, String TOGO) throws LinkhubException {
        HttpURLConnection httpURLConnection;
        String Result = "";
        InputStream input = null;
        String URI2 = "/" + this._recentServiceID + "/URL?TG=" + TOGO;
        try {
            URL url = new URL(this._ServiceURL + URI2);
            if (this._ProxyIP != null && this._ProxyPort != null) {
                Proxy prx = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this._ProxyIP, (int)this._ProxyPort));
                httpURLConnection = (HttpURLConnection)url.openConnection(prx);
            } else {
                httpURLConnection = (HttpURLConnection)url.openConnection();
            }
        }
        catch (Exception e) {
            throw new LinkhubException(-99999999L, "\ub9c1\ud06c\ud5c8\ube0c \uc11c\ubc84 \uc811\uc18d \uc2e4\ud328", e);
        }
        httpURLConnection.setRequestProperty("Authorization", "Bearer " + BearerToken);
        try {
            input = httpURLConnection.getInputStream();
            Result = null != httpURLConnection.getContentEncoding() && httpURLConnection.getContentEncoding().equals("gzip") ? TokenBuilder.fromGzipStream(input) : TokenBuilder.fromStream(input);
        }
        catch (IOException e) {
            Error error;
            block28: {
                error = null;
                InputStream is = null;
                try {
                    is = httpURLConnection.getErrorStream();
                    Result = TokenBuilder.fromStream(is);
                    error = (Error)this._gsonParser.fromJson(Result, Error.class);
                }
                catch (Exception e1) {
                    if (is == null) break block28;
                    try {
                        is.close();
                    }
                    catch (IOException e12) {
                        throw new LinkhubException(-99999999L, "Linkhub getPartnerURL func inputstream close exception.", e);
                    }
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e1) {
                            throw new LinkhubException(-99999999L, "Linkhub getPartnerURL func inputstream close exception.", e);
                        }
                    }
                }
            }
            if (error == null) {
                throw new LinkhubException(-99999999L, "Fail to receive getPartnerURL from Server.", e);
            }
            throw new LinkhubException(error.code, error.message);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    throw new LinkhubException(-99999999L, "Linkhub getPartnerURL func inputstream close exception.", e);
                }
            }
        }
        return ((URLResult)this._gsonParser.fromJson(Result, URLResult.class)).getURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTime() throws LinkhubException {
        HttpURLConnection httpURLConnection;
        if (this._useLocalTime) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            String localTime = format.format(System.currentTimeMillis());
            return localTime;
        }
        String URI2 = "/Time";
        try {
            URL url = new URL(this._ServiceURL + URI2);
            if (this._ProxyIP != null && this._ProxyPort != null) {
                Proxy prx = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this._ProxyIP, (int)this._ProxyPort));
                httpURLConnection = (HttpURLConnection)url.openConnection(prx);
            } else {
                httpURLConnection = (HttpURLConnection)url.openConnection();
            }
        }
        catch (Exception e) {
            throw new LinkhubException(-99999999L, "\ub9c1\ud06c\ud5c8\ube0c \uc11c\ubc84 \uc811\uc18d \uc2e4\ud328", e);
        }
        String Result = "";
        InputStream input = null;
        try {
            input = httpURLConnection.getInputStream();
            Result = null != httpURLConnection.getContentEncoding() && httpURLConnection.getContentEncoding().equals("gzip") ? TokenBuilder.fromGzipStream(input) : TokenBuilder.fromStream(input);
        }
        catch (IOException e) {
            Error error;
            block29: {
                error = null;
                InputStream is = null;
                try {
                    is = httpURLConnection.getErrorStream();
                    Result = TokenBuilder.fromStream(is);
                    error = (Error)this._gsonParser.fromJson(Result, Error.class);
                }
                catch (Exception e1) {
                    if (is == null) break block29;
                    try {
                        is.close();
                    }
                    catch (IOException e12) {
                        throw new LinkhubException(-99999999L, "Linkhub getTime func inputstream close exception.", e);
                    }
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e1) {
                            throw new LinkhubException(-99999999L, "Linkhub getTime func inputstream close exception.", e);
                        }
                    }
                }
            }
            if (error == null) {
                throw new LinkhubException(-99999999L, "Fail to receive UTC Time from Server.", e);
            }
            throw new LinkhubException(error.code, error.message);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    throw new LinkhubException(-99999999L, "Linkhub getTime func inputstream close exception.", e);
                }
            }
        }
        return Result;
    }

    private String getLinkID() throws LinkhubException {
        if (this._LinkID == null || this._LinkID.isEmpty()) {
            throw new LinkhubException(-99999999L, "\ub9c1\ud06c\uc544\uc774\ub514\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this._LinkID;
    }

    private String getSecretKey() throws LinkhubException {
        if (this._SecretKey == null || this._SecretKey.isEmpty()) {
            throw new LinkhubException(-99999999L, "\ube44\ubc00\ud0a4\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this._SecretKey;
    }

    private static String sha256Base64(byte[] input) throws LinkhubException {
        byte[] btResult = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            btResult = md.digest(input);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return Base64.encode(btResult);
    }

    private static byte[] HMacSha256(byte[] key, byte[] input) throws LinkhubException {
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key, HMAC_SHA256_ALGORITHM);
            Mac mac = Mac.getInstance(HMAC_SHA256_ALGORITHM);
            mac.init(signingKey);
            return mac.doFinal(input);
        }
        catch (Exception e) {
            throw new LinkhubException(-99999999L, "Fail to Calculate HMAC-SHA256, Please check your SecretKey.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String fromStream(InputStream input) throws LinkhubException {
        InputStreamReader is = null;
        BufferedReader br = null;
        StringBuilder sb = null;
        try {
            is = new InputStreamReader(input, Charset.forName("UTF-8"));
            sb = new StringBuilder();
            br = new BufferedReader(is);
            String read = br.readLine();
            while (read != null) {
                sb.append(read);
                read = br.readLine();
            }
        }
        catch (IOException e) {
            try {
                if (br != null) {
                    br.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e2) {
                throw new LinkhubException(-99999999L, "Linkhub fromStream func inputStream close exception.", e2);
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                throw new LinkhubException(-99999999L, "Linkhub fromStream func inputStream close exception.", e);
            }
        }
        return sb.toString();
    }

    private static String fromGzipStream(InputStream input) throws LinkhubException {
        GZIPInputStream zipReader = null;
        InputStreamReader is = null;
        BufferedReader br = null;
        StringBuilder sb = null;
        try {
            zipReader = new GZIPInputStream(input);
            is = new InputStreamReader((InputStream)zipReader, "UTF-8");
            br = new BufferedReader(is);
            sb = new StringBuilder();
            String read = br.readLine();
            while (read != null) {
                sb.append(read);
                read = br.readLine();
            }
        }
        catch (IOException e) {
            throw new LinkhubException(-99999999L, "Linkhub fromGzipStream func Exception", e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (is != null) {
                    is.close();
                }
                if (zipReader != null) {
                    zipReader.close();
                }
            }
            catch (IOException e) {
                throw new LinkhubException(-99999999L, "Linkhub fromGzipStream func finally close Exception", e);
            }
        }
        return sb.toString();
    }

    class TokenRequest {
        public String access_id;
        public List<String> scope = new ArrayList<String>();

        TokenRequest() {
        }
    }

    class Error {
        private long code;
        private String message;

        Error() {
        }

        public long getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }
    }

    class URLResult {
        private String url;

        URLResult() {
        }

        public String getURL() {
            return this.url;
        }
    }

    class PointResult {
        private double remainPoint;

        PointResult() {
        }

        public double getRemainPoint() {
            return this.remainPoint;
        }
    }
}

