/*
 * Decompiled with CFR 0.152.
 */
package com.popbill.api;

import com.google.gson.Gson;
import com.popbill.api.BaseService;
import com.popbill.api.ContactInfo;
import com.popbill.api.CorpInfo;
import com.popbill.api.JoinForm;
import com.popbill.api.PaymentForm;
import com.popbill.api.PaymentHistory;
import com.popbill.api.PaymentHistoryResult;
import com.popbill.api.PaymentResponse;
import com.popbill.api.PopbillException;
import com.popbill.api.RefundForm;
import com.popbill.api.RefundHistory;
import com.popbill.api.RefundHistoryResult;
import com.popbill.api.RefundResponse;
import com.popbill.api.RefundableBalance;
import com.popbill.api.Response;
import com.popbill.api.UseHistoryResult;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.zip.GZIPInputStream;
import kr.co.linkhub.auth.Base64;
import kr.co.linkhub.auth.LinkhubException;
import kr.co.linkhub.auth.Token;
import kr.co.linkhub.auth.TokenBuilder;

public abstract class BaseServiceImp
implements BaseService {
    private static final String ServiceID_REAL = "POPBILL";
    private static final String ServiceID_TEST = "POPBILL_TEST";
    private static final String Auth_Static_URL = "https://static-auth.linkhub.co.kr";
    private static final String Auth_GA_URL = "https://ga-auth.linkhub.co.kr";
    private static final String ServiceURL_REAL = "https://popbill.linkhub.co.kr";
    private static final String ServiceURL_TEST = "https://popbill-test.linkhub.co.kr";
    private static final String ServiceURL_Static_REAL = "https://static-popbill.linkhub.co.kr";
    private static final String ServiceURL_Static_TEST = "https://static-popbill-test.linkhub.co.kr";
    private static final String ServiceURL_GA_REAL = "https://ga-popbill.linkhub.co.kr";
    private static final String ServiceURL_GA_TEST = "https://ga-popbill-test.linkhub.co.kr";
    private final String APIVersion = "1.0";
    private String ServiceURL = null;
    private String TestServiceURL = null;
    private String AuthURL = null;
    private String ProxyIP = null;
    private Integer ProxyPort = null;
    private TokenBuilder tokenBuilder;
    private boolean isTest;
    private boolean isIPRestrictOnOff = true;
    private boolean useStaticIP = false;
    private boolean useGAIP = false;
    private boolean useLocalTimeYN = true;
    private String linkID;
    private String secretKey;
    private Gson _gsonParser = new Gson();
    private Map<String, Token> tokenTable = new HashMap<String, Token>();
    private static final String boundary = "--u489jwe98j3498j394r23450--";
    private static final String CRLF = "\r\n";

    public boolean isTest() {
        return this.isTest;
    }

    public boolean isIPRestrictOnOff() {
        return this.isIPRestrictOnOff;
    }

    public boolean isUseStaticIP() {
        return this.useStaticIP;
    }

    public boolean isUseLocalTimeYN() {
        return this.useLocalTimeYN;
    }

    public boolean isUseGAIP() {
        return this.useGAIP;
    }

    public void setTest(boolean isTest) {
        this.isTest = isTest;
    }

    public void setIPRestrictOnOff(boolean isIPRestrictOnOff) {
        this.isIPRestrictOnOff = isIPRestrictOnOff;
    }

    public void setUseStaticIP(boolean useStaticIP) {
        this.useStaticIP = useStaticIP;
    }

    public void setUseGAIP(boolean useGAIP) {
        this.useGAIP = useGAIP;
    }

    public void setUseLocalTimeYN(boolean useLocalTimeYN) {
        this.useLocalTimeYN = useLocalTimeYN;
    }

    protected String getLinkID() {
        return this.linkID;
    }

    public void setLinkID(String linkID) {
        this.linkID = linkID;
    }

    public void setAuthURL(String authURL) {
        this.AuthURL = authURL;
    }

    public void setServiceURL(String serviceURL) {
        this.ServiceURL = serviceURL;
    }

    public void setProxyIP(String proxyIP) {
        this.ProxyIP = proxyIP;
    }

    public void setProxyPort(Integer proxyPort) {
        this.ProxyPort = proxyPort;
    }

    public void setTestServiceURL(String testServiceURL) {
        this.TestServiceURL = testServiceURL;
    }

    protected String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    protected String getServiceID() {
        return this.isTest ? ServiceID_TEST : ServiceID_REAL;
    }

    protected String getServiceURL() {
        if (this.isTest) {
            if (this.TestServiceURL != null) {
                return this.TestServiceURL;
            }
        } else if (this.ServiceURL != null) {
            return this.ServiceURL;
        }
        if (this.useGAIP) {
            return this.isTest ? ServiceURL_GA_TEST : ServiceURL_GA_REAL;
        }
        if (this.useStaticIP) {
            return this.isTest ? ServiceURL_Static_TEST : ServiceURL_Static_REAL;
        }
        return this.isTest ? ServiceURL_TEST : ServiceURL_REAL;
    }

    private TokenBuilder getTokenbuilder() {
        if (this.tokenBuilder == null) {
            this.tokenBuilder = TokenBuilder.newInstance((String)this.getLinkID(), (String)this.getSecretKey()).ServiceID(this.isTest ? ServiceID_TEST : ServiceID_REAL).addScope("member").useLocalTimeYN(this.useLocalTimeYN);
            if (this.AuthURL != null) {
                this.tokenBuilder.setServiceURL(this.AuthURL);
            } else if (this.useGAIP) {
                this.tokenBuilder.setServiceURL(Auth_GA_URL);
            } else if (this.useStaticIP) {
                this.tokenBuilder.setServiceURL(Auth_Static_URL);
            }
            if (this.ProxyIP != null && this.ProxyPort != null) {
                this.tokenBuilder.setProxyIP(this.ProxyIP);
                this.tokenBuilder.setProxyPort(this.ProxyPort.intValue());
            }
            for (String scope : this.getScopes()) {
                this.tokenBuilder.addScope(scope);
            }
        }
        return this.tokenBuilder;
    }

    private String getSessionToken(String CorpNum, String ForwardIP) throws PopbillException {
        if (CorpNum == null || CorpNum.isEmpty()) {
            throw new PopbillException(-99999999L, "\ud68c\uc6d0 \uc0ac\uc5c5\uc790\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        Token token = null;
        Date UTCTime = null;
        if (this.tokenTable.containsKey(CorpNum)) {
            token = this.tokenTable.get(CorpNum);
        }
        boolean expired = true;
        if (token != null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            SimpleDateFormat subFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            subFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            try {
                Date expiration = format.parse(token.getExpiration());
                UTCTime = subFormat.parse(this.getTokenbuilder().getTime());
                expired = expiration.before(UTCTime);
            }
            catch (LinkhubException le) {
                throw new PopbillException(le);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (expired) {
            if (this.tokenTable.containsKey(CorpNum)) {
                this.tokenTable.remove(CorpNum);
            }
            try {
                token = this.isIPRestrictOnOff ? this.getTokenbuilder().build(CorpNum, ForwardIP) : this.getTokenbuilder().build(CorpNum, "*");
                this.tokenTable.put(CorpNum, token);
            }
            catch (LinkhubException le) {
                throw new PopbillException(le);
            }
        }
        return token.getSession_token();
    }

    @Override
    public String getPartnerURL(String CorpNum, String TOGO) throws PopbillException {
        try {
            return this.getTokenbuilder().getPartnerURL(this.getSessionToken(CorpNum, null), TOGO);
        }
        catch (LinkhubException le) {
            throw new PopbillException(le);
        }
    }

    @Override
    public double getBalance(String CorpNum) throws PopbillException {
        try {
            return this.getTokenbuilder().getBalance(this.getSessionToken(CorpNum, null));
        }
        catch (LinkhubException le) {
            throw new PopbillException(le);
        }
    }

    @Override
    public double getPartnerBalance(String CorpNum) throws PopbillException {
        try {
            return this.getTokenbuilder().getPartnerBalance(this.getSessionToken(CorpNum, null));
        }
        catch (LinkhubException le) {
            throw new PopbillException(le);
        }
    }

    @Override
    public Response joinMember(JoinForm joinInfo) throws PopbillException {
        String postData = this.toJsonString(joinInfo);
        return this.httppost("/Join", null, postData, null, Response.class);
    }

    @Override
    public String getPopbillURL(String CorpNum, String TOGO) throws PopbillException {
        URLResponse response = this.httpget("/?TG=" + TOGO, CorpNum, null, URLResponse.class);
        return response.url;
    }

    @Override
    public String getPopbillURL(String CorpNum, String UserID, String TOGO) throws PopbillException {
        URLResponse response = this.httpget("/?TG=" + TOGO, CorpNum, UserID, URLResponse.class);
        return response.url;
    }

    @Override
    public UseHistoryResult getUseHistory(String CorpNum, String SDate, String EDate, Integer Page, Integer PerPage, String Order) throws PopbillException {
        return this.getUseHistory(CorpNum, SDate, EDate, Page, PerPage, Order, null);
    }

    @Override
    public UseHistoryResult getUseHistory(String CorpNum, String SDate, String EDate, Integer Page, Integer PerPage, String Order, String UserID) throws PopbillException {
        String url = "/UseHistory";
        url = url + "?SDate=" + (SDate != null ? SDate : "");
        url = url + "&EDate=" + (EDate != null ? EDate : "");
        url = url + "&Page=" + (Page != null ? Page : "");
        url = url + "&PerPage=" + (PerPage != null ? PerPage : "");
        url = url + "&Order=" + (Order != null ? Order : "");
        return this.httpget(url, CorpNum, UserID, UseHistoryResult.class);
    }

    @Override
    public PaymentHistoryResult getPaymentHistory(String CorpNum, String SDate, String EDate, Integer Page, Integer PerPage) throws PopbillException {
        return this.getPaymentHistory(CorpNum, SDate, EDate, Page, PerPage, null);
    }

    @Override
    public PaymentHistoryResult getPaymentHistory(String CorpNum, String SDate, String EDate, Integer Page, Integer PerPage, String UserID) throws PopbillException {
        String url = "/PaymentHistory";
        url = url + "?SDate=" + (SDate != null ? SDate : "");
        url = url + "&EDate=" + (EDate != null ? EDate : "");
        url = url + "&Page=" + (Page != null ? Page : "");
        url = url + "&PerPage=" + (PerPage != null ? PerPage : "");
        return this.httpget(url, CorpNum, UserID, PaymentHistoryResult.class);
    }

    @Override
    public RefundHistoryResult getRefundHistory(String CorpNum, Integer Page, Integer PerPage) throws PopbillException {
        return this.getRefundHistory(CorpNum, Page, PerPage, null);
    }

    @Override
    public RefundHistoryResult getRefundHistory(String CorpNum, Integer Page, Integer PerPage, String UserID) throws PopbillException {
        String url = "/RefundHistory";
        url = url + "?Page=" + (Page != null ? Page : "");
        url = url + "&PerPage=" + (PerPage != null ? PerPage : "");
        return this.httpget(url, CorpNum, UserID, RefundHistoryResult.class);
    }

    @Override
    public RefundResponse refund(String CorpNum, RefundForm refundForm) throws PopbillException {
        return this.refund(CorpNum, refundForm, null);
    }

    @Override
    public RefundResponse refund(String CorpNum, RefundForm refundForm, String UserID) throws PopbillException {
        String postData = this.toJsonString(refundForm);
        return this.httppost("/Refund", CorpNum, postData, UserID, RefundResponse.class);
    }

    @Override
    public RefundHistory getRefundInfo(String CorpNum, String RefundCode) throws PopbillException {
        return this.getRefundInfo(CorpNum, RefundCode, null);
    }

    @Override
    public RefundHistory getRefundInfo(String CorpNum, String RefundCode, String UserID) throws PopbillException {
        if (RefundCode == null || RefundCode.equals("")) {
            throw new PopbillException(-99999999L, "\uc870\ud68c\ud560 \ud658\ubd88\ucf54\ub4dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/Refund/" + RefundCode, CorpNum, UserID, RefundHistory.class);
    }

    @Override
    public double getRefundableBalance(String CorpNum) throws PopbillException {
        return this.getRefundableBalance(CorpNum, null);
    }

    @Override
    public double getRefundableBalance(String CorpNum, String UserID) throws PopbillException {
        RefundableBalance rfn = this.httpget("/RefundPoint", CorpNum, UserID, RefundableBalance.class);
        return rfn.getRefundableBalance();
    }

    @Override
    public PaymentResponse paymentRequest(String CorpNum, PaymentForm paymentForm) throws PopbillException {
        return this.paymentRequest(CorpNum, paymentForm, null);
    }

    @Override
    public PaymentResponse paymentRequest(String CorpNum, PaymentForm paymentForm, String UserID) throws PopbillException {
        String postData = this.toJsonString(paymentForm);
        return this.httppost("/Payment", CorpNum, postData, UserID, PaymentResponse.class);
    }

    @Override
    public PaymentHistory getSettleResult(String CorpNum, String settleCode) throws PopbillException {
        return this.getSettleResult(CorpNum, settleCode, null);
    }

    @Override
    public PaymentHistory getSettleResult(String CorpNum, String settleCode, String UserID) throws PopbillException {
        return this.httpget("/Payment/" + settleCode, CorpNum, null, PaymentHistory.class);
    }

    @Override
    public Response checkIsMember(String CorpNum, String LinkID) throws PopbillException {
        return this.httpget("/Join?CorpNum=" + CorpNum + "&LID=" + LinkID, null, null, Response.class);
    }

    @Override
    public ContactInfo getContactInfo(String CorpNum, String ContactID) throws PopbillException {
        return this.getContactInfo(CorpNum, ContactID, null);
    }

    @Override
    public ContactInfo getContactInfo(String CorpNum, String ContactID, String UserID) throws PopbillException {
        String postData = "{'id' :'" + ContactID + "'}";
        return this.httppost("/Contact", CorpNum, postData, UserID, ContactInfo.class);
    }

    @Override
    public ContactInfo[] listContact(String CorpNum) throws PopbillException {
        return this.httpget("/IDs", CorpNum, null, ContactInfo[].class);
    }

    @Override
    public ContactInfo[] listContact(String CorpNum, String UserID) throws PopbillException {
        return this.httpget("/IDs", CorpNum, UserID, ContactInfo[].class);
    }

    @Override
    public Response updateContact(String CorpNum, ContactInfo contactInfo, String UserID) throws PopbillException {
        String postData = this.toJsonString(contactInfo);
        return this.httppost("/IDs", CorpNum, postData, UserID, Response.class);
    }

    @Override
    public Response quitMember(String CorpNum, String quitReason) throws PopbillException {
        return this.quitMember(CorpNum, quitReason, null);
    }

    @Override
    public Response quitMember(String CorpNum, String quitReason, String UserID) throws PopbillException {
        if (quitReason == null || quitReason.isEmpty()) {
            throw new PopbillException(-99999999L, "\ud0c8\ud1f4\uc0ac\uc720\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String postData = "{'quitReason' :'" + quitReason + "'}";
        return this.httppost("/QuitRequest", CorpNum, postData, UserID, Response.class);
    }

    @Override
    public Response registContact(String CorpNum, ContactInfo contactInfo) throws PopbillException {
        String postData = this.toJsonString(contactInfo);
        return this.httppost("/IDs/New", CorpNum, postData, null, Response.class);
    }

    @Override
    public Response registContact(String CorpNum, ContactInfo contactInfo, String UserID) throws PopbillException {
        String postData = this.toJsonString(contactInfo);
        return this.httppost("/IDs/New", CorpNum, postData, UserID, Response.class);
    }

    @Override
    public Response checkID(String CheckID) throws PopbillException {
        return this.httpget("/IDCheck?ID=" + CheckID, null, null, Response.class);
    }

    @Override
    public CorpInfo getCorpInfo(String CorpNum) throws PopbillException {
        return this.httpget("/CorpInfo", CorpNum, null, CorpInfo.class);
    }

    @Override
    public CorpInfo getCorpInfo(String CorpNum, String UserID) throws PopbillException {
        return this.httpget("/CorpInfo", CorpNum, UserID, CorpInfo.class);
    }

    @Override
    public Response updateCorpInfo(String CorpNum, CorpInfo corpInfo) throws PopbillException {
        String postData = this.toJsonString(corpInfo);
        return this.httppost("/CorpInfo", CorpNum, postData, null, Response.class);
    }

    @Override
    public Response updateCorpInfo(String CorpNum, CorpInfo corpInfo, String UserID) throws PopbillException {
        String postData = this.toJsonString(corpInfo);
        return this.httppost("/CorpInfo", CorpNum, postData, UserID, Response.class);
    }

    @Override
    public String getAccessURL(String CorpNum, String UserID) throws PopbillException {
        URLResponse response = this.httpget("/?TG=LOGIN", CorpNum, UserID, URLResponse.class);
        return response.url;
    }

    @Override
    public String getChargeURL(String CorpNum, String UserID) throws PopbillException {
        URLResponse response = this.httpget("/?TG=CHRG", CorpNum, UserID, URLResponse.class);
        return response.url;
    }

    @Override
    public String getPaymentURL(String CorpNum, String UserID) throws PopbillException {
        URLResponse response = this.httpget("/?TG=PAYMENT", CorpNum, UserID, URLResponse.class);
        return response.url;
    }

    @Override
    public String getUseHistoryURL(String CorpNum, String UserID) throws PopbillException {
        URLResponse response = this.httpget("/?TG=USEHISTORY", CorpNum, UserID, URLResponse.class);
        return response.url;
    }

    protected String toJsonString(Object Graph) {
        return this._gsonParser.toJson(Graph);
    }

    protected <T> T fromJsonString(String json, Class<T> clazz) {
        return (T)this._gsonParser.fromJson(json, clazz);
    }

    protected <T> T httppost(String url, String CorpNum, String PostData, String UserID, Class<T> clazz) throws PopbillException {
        return this.httppost(url, CorpNum, PostData, UserID, null, clazz);
    }

    protected <T> T httppost(String url, String CorpNum, String PostData, String UserID, String Action, Class<T> clazz) throws PopbillException {
        return this.httppost(url, CorpNum, PostData, UserID, Action, clazz, null);
    }

    private static byte[] encryptSHA1(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] messageDigest = md.digest(input.getBytes(Charset.forName("UTF-8")));
            return messageDigest;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    protected <T> T httpBulkPost(String url, String CorpNum, String SubmitID, String PostData, String UserID, String Action, Class<T> clazz) throws PopbillException {
        HttpURLConnection httpURLConnection;
        try {
            URL uri = new URL(this.getServiceURL() + url);
            if (this.ProxyIP != null && this.ProxyPort != null) {
                Proxy prx = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.ProxyIP, (int)this.ProxyPort));
                httpURLConnection = (HttpURLConnection)uri.openConnection(prx);
            } else {
                httpURLConnection = (HttpURLConnection)uri.openConnection();
            }
        }
        catch (Exception e) {
            throw new PopbillException(-99999999L, "\ud31d\ube4c API \uc11c\ubc84 \uc811\uc18d \uc2e4\ud328", e);
        }
        if (CorpNum != null && !CorpNum.isEmpty()) {
            httpURLConnection.setRequestProperty("Authorization", "Bearer " + this.getSessionToken(CorpNum, null));
        }
        httpURLConnection.setRequestProperty("x-pb-message-digest", Base64.encode((byte[])BaseServiceImp.encryptSHA1(PostData)));
        httpURLConnection.setRequestProperty("x-pb-submit-id", SubmitID);
        httpURLConnection.setRequestProperty("x-pb-version".toLowerCase(), "1.0");
        if (Action != null && !Action.isEmpty()) {
            httpURLConnection.setRequestProperty("X-HTTP-Method-Override", Action);
        }
        httpURLConnection.setRequestProperty("Content-Type", "application/json; charset=utf8");
        httpURLConnection.setRequestProperty("Accept-Encoding", "gzip");
        if (UserID != null && !UserID.isEmpty()) {
            httpURLConnection.setRequestProperty("x-pb-userid", UserID);
        }
        try {
            httpURLConnection.setRequestMethod("POST");
        }
        catch (ProtocolException e) {
            // empty catch block
        }
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setDoOutput(true);
        if (!(PostData == null || PostData.isEmpty())) {
            byte[] btPostData = PostData.getBytes(Charset.forName("UTF-8"));
            httpURLConnection.setRequestProperty("Content-Length", String.valueOf(btPostData.length));
            DataOutputStream output = null;
            try {
                output = new DataOutputStream(httpURLConnection.getOutputStream());
                output.write(btPostData);
                output.flush();
            }
            catch (Exception e) {
                throw new PopbillException(-99999999L, "Fail to POST data to Server.", e);
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException e1) {
                    throw new PopbillException(-99999999L, "Popbill httppost func DataOutputStream close() Exception", e1);
                }
            }
        }
        String Result = this.parseResponse(httpURLConnection);
        return this.fromJsonString(Result, clazz);
    }

    protected <T> T httppost(String url, String CorpNum, String PostData, String UserID, String Action, Class<T> clazz, String ContentType) throws PopbillException {
        HttpURLConnection httpURLConnection;
        try {
            URL uri = new URL(this.getServiceURL() + url);
            if (this.ProxyIP != null && this.ProxyPort != null) {
                Proxy prx = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.ProxyIP, (int)this.ProxyPort));
                httpURLConnection = (HttpURLConnection)uri.openConnection(prx);
            } else {
                httpURLConnection = (HttpURLConnection)uri.openConnection();
            }
        }
        catch (Exception e) {
            throw new PopbillException(-99999999L, "\ud31d\ube4c API \uc11c\ubc84 \uc811\uc18d \uc2e4\ud328", e);
        }
        if (CorpNum != null && !CorpNum.isEmpty()) {
            httpURLConnection.setRequestProperty("Authorization", "Bearer " + this.getSessionToken(CorpNum, null));
        }
        httpURLConnection.setRequestProperty("x-pb-version".toLowerCase(), "1.0");
        if (Action != null && !Action.isEmpty()) {
            httpURLConnection.setRequestProperty("X-HTTP-Method-Override", Action);
        }
        if (ContentType != null && !ContentType.isEmpty()) {
            httpURLConnection.setRequestProperty("Content-Type", ContentType);
        } else {
            httpURLConnection.setRequestProperty("Content-Type", "application/json; charset=utf8");
        }
        httpURLConnection.setRequestProperty("Accept-Encoding", "gzip");
        if (UserID != null && !UserID.isEmpty()) {
            httpURLConnection.setRequestProperty("x-pb-userid", UserID);
        }
        try {
            httpURLConnection.setRequestMethod("POST");
        }
        catch (ProtocolException e) {
            // empty catch block
        }
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setDoOutput(true);
        if (!(PostData == null || PostData.isEmpty())) {
            byte[] btPostData = PostData.getBytes(Charset.forName("UTF-8"));
            httpURLConnection.setRequestProperty("Content-Length", String.valueOf(btPostData.length));
            DataOutputStream output = null;
            try {
                output = new DataOutputStream(httpURLConnection.getOutputStream());
                output.write(btPostData);
                output.flush();
            }
            catch (Exception e) {
                throw new PopbillException(-99999999L, "Fail to POST data to Server.", e);
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException e1) {
                    throw new PopbillException(-99999999L, "Popbill httppost func DataOutputStream close() Exception", e1);
                }
            }
        }
        String Result = this.parseResponse(httpURLConnection);
        return this.fromJsonString(Result, clazz);
    }

    protected <T> T httppostFiles(String url, String CorpNum, String form, List<UploadFile> files, String UserID, Class<T> clazz) throws PopbillException {
        HttpURLConnection httpURLConnection;
        try {
            URL uri = new URL(this.getServiceURL() + url);
            if (this.ProxyIP != null && this.ProxyPort != null) {
                Proxy prx = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.ProxyIP, (int)this.ProxyPort));
                httpURLConnection = (HttpURLConnection)uri.openConnection(prx);
            } else {
                httpURLConnection = (HttpURLConnection)uri.openConnection();
            }
        }
        catch (Exception e) {
            throw new PopbillException(-99999999L, "\ud31d\ube4c API \uc11c\ubc84 \uc811\uc18d \uc2e4\ud328", e);
        }
        if (CorpNum != null && !CorpNum.isEmpty()) {
            httpURLConnection.setRequestProperty("Authorization", "Bearer " + this.getSessionToken(CorpNum, null));
        }
        httpURLConnection.setRequestProperty("x-pb-version".toLowerCase(), "1.0");
        httpURLConnection.setRequestProperty("Connection", "Keep-Alive");
        httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data;boundary=--u489jwe98j3498j394r23450--");
        if (UserID != null && !UserID.isEmpty()) {
            httpURLConnection.setRequestProperty("x-pb-userid", UserID);
        }
        httpURLConnection.setRequestProperty("Accept-Encoding", "gzip");
        try {
            httpURLConnection.setRequestMethod("POST");
        }
        catch (ProtocolException e) {
            // empty catch block
        }
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setDoOutput(true);
        DataOutputStream output = null;
        try {
            output = new DataOutputStream(httpURLConnection.getOutputStream());
            if (!(form == null || form.isEmpty())) {
                Object formBody = "----u489jwe98j3498j394r23450--\r\n";
                formBody = (String)formBody + "content-disposition: form-data; name=\"form\"\r\n";
                formBody = (String)formBody + "content-type: Application/json; charset=utf-8\r\n\r\n";
                formBody = (String)formBody + form + CRLF;
                byte[] btFormBody = ((String)formBody).getBytes(Charset.forName("UTF-8"));
                output.write(btFormBody);
            }
            for (UploadFile f : files) {
                int read;
                String fileHeader = "----u489jwe98j3498j394r23450--\r\n";
                fileHeader = fileHeader + "content-disposition: form-data; name=\"" + f.fieldName + "\"; filename=\"" + f.fileName + "\"" + CRLF;
                fileHeader = fileHeader + "content-type: Application/octet-stream\r\n\r\n";
                byte[] btFileHeader = fileHeader.getBytes(Charset.forName("UTF-8"));
                output.write(btFileHeader);
                byte[] buffer = new byte[32768];
                while ((read = f.fileData.read(buffer, 0, buffer.length)) > 0) {
                    output.write(buffer, 0, read);
                }
                output.write(CRLF.getBytes(Charset.forName("UTF-8")));
            }
            String boundaryFooter = "----u489jwe98j3498j394r23450----\r\n";
            byte[] btboundaryFooter = boundaryFooter.getBytes(Charset.forName("UTF-8"));
            output.write(btboundaryFooter);
            output.flush();
        }
        catch (Exception e) {
            throw new PopbillException(-99999999L, "Fail to POST data to Server.", e);
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException e1) {
                throw new PopbillException(-99999999L, "Popbill httppostFiles func DataOutputStream close() Exception", e1);
            }
        }
        String Result = this.parseResponse(httpURLConnection);
        return this.fromJsonString(Result, clazz);
    }

    protected <T> T httpget(String url, String CorpNum, String UserID, Class<T> clazz) throws PopbillException {
        HttpURLConnection httpURLConnection;
        try {
            URL uri = new URL(this.getServiceURL() + url);
            if (this.ProxyIP != null && this.ProxyPort != null) {
                Proxy prx = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.ProxyIP, (int)this.ProxyPort));
                httpURLConnection = (HttpURLConnection)uri.openConnection(prx);
            } else {
                httpURLConnection = (HttpURLConnection)uri.openConnection();
            }
        }
        catch (Exception e) {
            throw new PopbillException(-99999999L, "\ud31d\ube4c API \uc11c\ubc84 \uc811\uc18d \uc2e4\ud328", e);
        }
        if (CorpNum != null && !CorpNum.isEmpty()) {
            httpURLConnection.setRequestProperty("Authorization", "Bearer " + this.getSessionToken(CorpNum, null));
        }
        httpURLConnection.setRequestProperty("x-pb-version".toLowerCase(), "1.0");
        if (UserID != null && !UserID.isEmpty()) {
            httpURLConnection.setRequestProperty("x-pb-userid", UserID);
        }
        httpURLConnection.setRequestProperty("Accept-Encoding", "gzip");
        if (httpURLConnection.getContentType().toLowerCase().equals("application/pdf;charset=utf-8")) {
            byte[] ResultArray = this.parseResponseByte(httpURLConnection);
            return clazz.cast(ResultArray);
        }
        String Result = this.parseResponse(httpURLConnection);
        return this.fromJsonString(Result, clazz);
    }

    protected abstract List<String> getScopes();

    private static String fromStream(InputStream input) throws PopbillException {
        InputStreamReader is = null;
        BufferedReader br = null;
        StringBuilder sb = null;
        try {
            is = new InputStreamReader(input, Charset.forName("UTF-8"));
            br = new BufferedReader(is);
            sb = new StringBuilder();
            String read = br.readLine();
            while (read != null) {
                sb.append(read);
                read = br.readLine();
            }
        }
        catch (IOException e) {
            throw new PopbillException(-99999999L, "Popbill fromStream func Exception", e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                throw new PopbillException(-99999999L, "Popbill fromStream func finally close Exception", e);
            }
        }
        return sb.toString();
    }

    private static String fromGzipStream(InputStream input) throws PopbillException {
        GZIPInputStream zipReader = null;
        InputStreamReader is = null;
        BufferedReader br = null;
        StringBuilder sb = null;
        try {
            zipReader = new GZIPInputStream(input);
            is = new InputStreamReader((InputStream)zipReader, "UTF-8");
            br = new BufferedReader(is);
            sb = new StringBuilder();
            String read = br.readLine();
            while (read != null) {
                sb.append(read);
                read = br.readLine();
            }
        }
        catch (IOException e) {
            throw new PopbillException(-99999999L, "Popbill fromGzipStream func Exception", e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (is != null) {
                    is.close();
                }
                if (zipReader != null) {
                    zipReader.close();
                }
            }
            catch (IOException e) {
                throw new PopbillException(-99999999L, "Popbill fromGzipStream func finally close Exception", e);
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String parseResponse(HttpURLConnection httpURLConnection) throws PopbillException {
        String result = "";
        InputStream input = null;
        PopbillException exception = null;
        try {
            input = httpURLConnection.getInputStream();
            result = null != httpURLConnection.getContentEncoding() && httpURLConnection.getContentEncoding().equals("gzip") ? BaseServiceImp.fromGzipStream(input) : BaseServiceImp.fromStream(input);
        }
        catch (IOException e) {
            InputStream errorIs = null;
            ErrorResponse error = null;
            try {
                errorIs = httpURLConnection.getErrorStream();
                result = BaseServiceImp.fromStream(errorIs);
                error = this.fromJsonString(result, ErrorResponse.class);
            }
            catch (Exception e1) {
                try {
                    if (errorIs != null) {
                        errorIs.close();
                    }
                }
                catch (IOException e12) {
                    throw new PopbillException(-99999999L, "Popbill parseResponse func InputStream close() Exception", e12);
                }
            }
            finally {
                try {
                    if (errorIs != null) {
                        errorIs.close();
                    }
                }
                catch (IOException e1) {
                    throw new PopbillException(-99999999L, "Popbill parseResponse func InputStream close() Exception", e1);
                }
            }
            exception = error == null ? new PopbillException(-99999999L, "Fail to receive data from Server.", e) : new PopbillException(error.getCode(), error.getMessage());
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e2) {
                throw new PopbillException(-99999999L, "Popbill parseResponse func InputStream close() Exception", e2);
            }
        }
        if (exception != null) {
            throw exception;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] parseResponseByte(HttpURLConnection httpURLConnection) throws PopbillException {
        byte[] result = null;
        InputStream input = null;
        PopbillException exception = null;
        String errorResult = null;
        try {
            input = httpURLConnection.getInputStream();
            result = null != httpURLConnection.getContentEncoding() && httpURLConnection.getContentEncoding().equals("gzip") ? this.fromGzipStreamByte(input) : this.fromStreamByte(input);
        }
        catch (IOException e) {
            InputStream errorIs = null;
            ErrorResponse error = null;
            try {
                errorIs = httpURLConnection.getErrorStream();
                errorResult = BaseServiceImp.fromStream(errorIs);
                error = this.fromJsonString(errorResult, ErrorResponse.class);
            }
            catch (Exception e1) {
                try {
                    if (errorIs != null) {
                        errorIs.close();
                    }
                }
                catch (IOException e12) {
                    throw new PopbillException(-99999999L, "Popbill parseResponseByte func InputStream close() Exception", e12);
                }
            }
            finally {
                try {
                    if (errorIs != null) {
                        errorIs.close();
                    }
                }
                catch (IOException e1) {
                    throw new PopbillException(-99999999L, "Popbill parseResponseByte func InputStream close() Exception", e1);
                }
            }
            exception = error == null ? new PopbillException(-99999999L, "Fail to receive data from Server.", e) : new PopbillException(error.getCode(), error.getMessage());
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e2) {
                throw new PopbillException(-99999999L, "Popbill parseResponseByte func InputStream close() Exception", e2);
            }
        }
        if (exception != null) {
            throw exception;
        }
        return result;
    }

    private byte[] fromStreamByte(InputStream input) throws PopbillException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int nRead = 0;
        try {
            while ((nRead = input.read(buffer)) > 0) {
                byteArrayOutputStream.write(buffer, 0, nRead);
            }
        }
        catch (IOException e) {
            throw new PopbillException(-99999999L, "Popbill fromStreamByte func Exception", e);
        }
        finally {
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
            catch (IOException e) {
                throw new PopbillException(-99999999L, "Popbill fromStreamByte func finally close Exception", e);
            }
        }
        byte[] Result = byteArrayOutputStream.toByteArray();
        return Result;
    }

    private byte[] fromGzipStreamByte(InputStream input) throws PopbillException {
        GZIPInputStream zipReader = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int nRead = 0;
        try {
            zipReader = new GZIPInputStream(input);
            while ((nRead = zipReader.read(buffer)) > 0) {
                byteArrayOutputStream.write(buffer, 0, nRead);
            }
        }
        catch (IOException e) {
            throw new PopbillException(-99999999L, "Popbill fromGzipStreamByte func Exception", e);
        }
        finally {
            try {
                if (zipReader != null) {
                    zipReader.close();
                }
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new PopbillException(-99999999L, "Popbill fromGzipStreamByte func finally close Exception", e);
            }
        }
        byte[] Result = byteArrayOutputStream.toByteArray();
        return Result;
    }

    protected class URLResponse {
        public String url;

        protected URLResponse() {
        }
    }

    protected class UploadFile {
        public String fieldName;
        public String fileName;
        public InputStream fileData;
    }

    protected class UnitCostResponse {
        public float unitCost;

        protected UnitCostResponse() {
        }
    }

    private class ErrorResponse {
        private long code;
        private String message;

        private ErrorResponse() {
        }

        public long getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

