/*
 * Decompiled with CFR 0.152.
 */
package com.popbill.api.accountcheck;

import com.popbill.api.AccountCheckInfo;
import com.popbill.api.AccountCheckService;
import com.popbill.api.BaseServiceImp;
import com.popbill.api.ChargeInfo;
import com.popbill.api.DepositorCheckInfo;
import com.popbill.api.PopbillException;
import java.util.Arrays;
import java.util.List;

public class AccountCheckServiceImp
extends BaseServiceImp
implements AccountCheckService {
    @Override
    protected List<String> getScopes() {
        return Arrays.asList("182", "183");
    }

    @Override
    @Deprecated
    public float getUnitCost(String CorpNum) throws PopbillException {
        BaseServiceImp.UnitCostResponse response = this.httpget("/EasyFin/AccountCheck/UnitCost", CorpNum, null, BaseServiceImp.UnitCostResponse.class);
        return response.unitCost;
    }

    @Override
    @Deprecated
    public ChargeInfo getChargeInfo(String CorpNum) throws PopbillException {
        return this.httpget("/EasyFin/AccountCheck/ChargeInfo", CorpNum, null, ChargeInfo.class);
    }

    @Override
    public float getUnitCost(String CorpNum, String serviceType) throws PopbillException {
        BaseServiceImp.UnitCostResponse response = this.httpget("/EasyFin/AccountCheck/UnitCost?serviceType=" + serviceType, CorpNum, null, BaseServiceImp.UnitCostResponse.class);
        return response.unitCost;
    }

    @Override
    public ChargeInfo getChargeInfo(String CorpNum, String serviceType) throws PopbillException {
        return this.httpget("/EasyFin/AccountCheck/ChargeInfo?serviceType=" + serviceType, CorpNum, null, ChargeInfo.class);
    }

    @Override
    public AccountCheckInfo CheckAccountInfo(String MemberCorpNum, String BankCode, String AccountNumber) throws PopbillException {
        return this.CheckAccountInfo(MemberCorpNum, BankCode, AccountNumber, null);
    }

    @Override
    public AccountCheckInfo CheckAccountInfo(String MemberCorpNum, String BankCode, String AccountNumber, String UserID) throws PopbillException {
        if (BankCode == null || BankCode.isEmpty()) {
            throw new PopbillException(-99999999L, "\uae30\uad00\ucf54\ub4dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (BankCode.length() != 4) {
            throw new PopbillException(-99999999L, "\uae30\uad00\ucf54\ub4dc\uac00 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
        }
        if (AccountNumber == null || AccountNumber.isEmpty()) {
            throw new PopbillException(-99999999L, "\uacc4\uc88c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String uri = "/EasyFin/AccountCheck";
        uri = uri + "?c=" + BankCode;
        uri = uri + "&n=" + AccountNumber;
        return this.httppost(uri, MemberCorpNum, null, UserID, AccountCheckInfo.class);
    }

    @Override
    public DepositorCheckInfo CheckDepositorInfo(String MemberCorpNum, String BankCode, String AccountNumber, String IdentityNumType, String IdentityNum) throws PopbillException {
        return this.CheckDepositorInfo(MemberCorpNum, BankCode, AccountNumber, IdentityNumType, IdentityNum, null);
    }

    @Override
    public DepositorCheckInfo CheckDepositorInfo(String MemberCorpNum, String BankCode, String AccountNumber, String IdentityNumType, String IdentityNum, String UserID) throws PopbillException {
        if (BankCode == null || BankCode.isEmpty()) {
            throw new PopbillException(-99999999L, "\uae30\uad00\ucf54\ub4dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (BankCode.length() != 4) {
            throw new PopbillException(-99999999L, "\uae30\uad00\ucf54\ub4dc\uac00 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
        }
        if (AccountNumber == null || AccountNumber.isEmpty()) {
            throw new PopbillException(-99999999L, "\uacc4\uc88c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (IdentityNumType == null || IdentityNumType.isEmpty()) {
            throw new PopbillException(-99999999L, "\ub4f1\ub85d\ubc88\ud638 \uc720\ud615\uc774 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (!IdentityNumType.matches("^[PB]$")) {
            throw new PopbillException(-99999999L, "\uc62c\ubc14\ub978 \ub4f1\ub85d\ubc88\ud638 \uc720\ud615\uc774 \uc544\ub2d9\ub2c8\ub2e4.");
        }
        if (IdentityNum == null || IdentityNum.isEmpty()) {
            throw new PopbillException(-99999999L, "\ub4f1\ub85d\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (!IdentityNum.matches("^\\d+$")) {
            throw new PopbillException(-99999999L, "\ub4f1\ub85d\ubc88\ud638\ub294 \uc22b\uc790\ub9cc \uc785\ub825\ud569\ub2c8\ub2e4.");
        }
        String uri = "/EasyFin/DepositorCheck";
        uri = uri + "?c=" + BankCode;
        uri = uri + "&n=" + AccountNumber;
        uri = uri + "&t=" + IdentityNumType;
        uri = uri + "&p=" + IdentityNum;
        return this.httppost(uri, MemberCorpNum, null, UserID, DepositorCheckInfo.class);
    }
}

