/*
 * Decompiled with CFR 0.152.
 */
package com.popbill.api.cashbill;

import com.popbill.api.BaseServiceImp;
import com.popbill.api.BulkResponse;
import com.popbill.api.CBIssueResponse;
import com.popbill.api.CashbillService;
import com.popbill.api.ChargeInfo;
import com.popbill.api.EmailSendConfig;
import com.popbill.api.PopbillException;
import com.popbill.api.Response;
import com.popbill.api.cashbill.BulkCashbillResult;
import com.popbill.api.cashbill.BulkCashbillSubmit;
import com.popbill.api.cashbill.CBSearchResult;
import com.popbill.api.cashbill.Cashbill;
import com.popbill.api.cashbill.CashbillInfo;
import com.popbill.api.cashbill.CashbillLog;
import java.util.Arrays;
import java.util.List;

public class CashbillServiceImp
extends BaseServiceImp
implements CashbillService {
    @Override
    protected List<String> getScopes() {
        return Arrays.asList("140");
    }

    @Override
    public String getURL(String CorpNum, String TOGO) throws PopbillException {
        return this.getURL(CorpNum, null, TOGO);
    }

    @Override
    public String getURL(String CorpNum, String UserID, String TOGO) throws PopbillException {
        BaseServiceImp.URLResponse response = this.httpget("/Cashbill?TG=" + TOGO, CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public float getUnitCost(String CorpNum) throws PopbillException {
        BaseServiceImp.UnitCostResponse response = this.httpget("/Cashbill?cfg=UNITCOST", CorpNum, null, BaseServiceImp.UnitCostResponse.class);
        return response.unitCost;
    }

    @Override
    public boolean checkMgtKeyInUse(String CorpNum, String MgtKey) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        try {
            CashbillInfo info = this.httpget("/Cashbill/" + MgtKey, CorpNum, null, CashbillInfo.class);
            return !(info.getItemKey() == null || info.getItemKey().isEmpty());
        }
        catch (PopbillException PE) {
            if (PE.getCode() == -14000003L) {
                return false;
            }
            throw PE;
        }
    }

    @Override
    public Response register(String CorpNum, Cashbill cashbill) throws PopbillException {
        return this.register(CorpNum, cashbill, null);
    }

    @Override
    public Response register(String CorpNum, Cashbill cashbill, String UserID) throws PopbillException {
        if (cashbill == null) {
            throw new PopbillException(-99999999L, "\ud604\uae08\uc601\uc218\uc99d\uc815\ubcf4\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String PostData = this.toJsonString(cashbill);
        return this.httppost("/Cashbill", CorpNum, PostData, UserID, Response.class);
    }

    @Override
    public Response update(String CorpNum, String MgtKey, Cashbill cashbill) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.update(CorpNum, MgtKey, cashbill, null);
    }

    @Override
    public Response update(String CorpNum, String MgtKey, Cashbill cashbill, String UserID) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String PostData = this.toJsonString(cashbill);
        return this.httppost("/Cashbill/" + MgtKey, CorpNum, PostData, UserID, "PATCH", Response.class);
    }

    @Override
    public Response delete(String CorpNum, String MgtKey) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.delete(CorpNum, MgtKey, null);
    }

    @Override
    public Response delete(String CorpNum, String MgtKey, String UserID) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httppost("/Cashbill/" + MgtKey, CorpNum, null, UserID, "DELETE", Response.class);
    }

    @Override
    public CBIssueResponse issue(String CorpNum, String MgtKey, String Memo) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.issue(CorpNum, MgtKey, Memo, null);
    }

    @Override
    public CBIssueResponse issue(String CorpNum, String MgtKey, String Memo, String UserID) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String PostData = this.toJsonString(new MemoRequest(Memo));
        return this.httppost("/Cashbill/" + MgtKey, CorpNum, PostData, UserID, "ISSUE", CBIssueResponse.class);
    }

    @Override
    public Response cancelIssue(String CorpNum, String MgtKey, String Memo) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.cancelIssue(CorpNum, MgtKey, Memo, null);
    }

    @Override
    public Response cancelIssue(String CorpNum, String MgtKey, String Memo, String UserID) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String PostData = this.toJsonString(new MemoRequest(Memo));
        return this.httppost("/Cashbill/" + MgtKey, CorpNum, PostData, UserID, "CANCELISSUE", Response.class);
    }

    @Override
    public Response sendEmail(String CorpNum, String MgtKey, String Receiver2) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.sendEmail(CorpNum, MgtKey, Receiver2, null);
    }

    @Override
    public Response sendEmail(String CorpNum, String MgtKey, String Receiver2, String UserID) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        ResendRequest request = new ResendRequest();
        request.receiver = Receiver2;
        String PostData = this.toJsonString(request);
        return this.httppost("/Cashbill/" + MgtKey, CorpNum, PostData, UserID, "EMAIL", Response.class);
    }

    @Override
    public Response sendSMS(String CorpNum, String MgtKey, String Sender, String Receiver2, String Contents) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.sendSMS(CorpNum, MgtKey, Sender, Receiver2, Contents, null);
    }

    @Override
    public Response sendSMS(String CorpNum, String MgtKey, String Sender, String Receiver2, String Contents, String UserID) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        ResendRequest request = new ResendRequest();
        request.sender = Sender;
        request.receiver = Receiver2;
        request.contents = Contents;
        String PostData = this.toJsonString(request);
        return this.httppost("/Cashbill/" + MgtKey, CorpNum, PostData, UserID, "SMS", Response.class);
    }

    @Override
    public Response sendFAX(String CorpNum, String MgtKey, String Sender, String Receiver2) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.sendFAX(CorpNum, MgtKey, Sender, Receiver2, null);
    }

    @Override
    public Response sendFAX(String CorpNum, String MgtKey, String Sender, String Receiver2, String UserID) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        ResendRequest request = new ResendRequest();
        request.sender = Sender;
        request.receiver = Receiver2;
        String PostData = this.toJsonString(request);
        return this.httppost("/Cashbill/" + MgtKey, CorpNum, PostData, UserID, "FAX", Response.class);
    }

    @Override
    public Cashbill getDetailInfo(String CorpNum, String MgtKey) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/Cashbill/" + MgtKey + "?Detail", CorpNum, null, Cashbill.class);
    }

    @Override
    public CashbillInfo getInfo(String CorpNum, String MgtKey) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/Cashbill/" + MgtKey, CorpNum, null, CashbillInfo.class);
    }

    @Override
    public CashbillInfo[] getInfos(String CorpNum, String[] MgtKeyList) throws PopbillException {
        if (MgtKeyList == null || MgtKeyList.length == 0) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\ubc30\uc5f4\uc774 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String PostData = this.toJsonString(MgtKeyList);
        return this.httppost("/Cashbill/States", CorpNum, PostData, null, CashbillInfo[].class);
    }

    @Override
    public CashbillLog[] getLogs(String CorpNum, String MgtKey) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/Cashbill/" + MgtKey + "/Logs", CorpNum, null, CashbillLog[].class);
    }

    @Override
    public Response assignMgtKey(String corpNum, String itemKey, String mgtKey) throws PopbillException {
        return this.assignMgtKey(corpNum, itemKey, mgtKey, null);
    }

    @Override
    public Response assignMgtKey(String corpNum, String itemKey, String mgtKey, String userID) throws PopbillException {
        if (itemKey == null || itemKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\uc544\uc774\ud15c\ud0a4(ItemKey)\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (mgtKey == null || mgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638(MgtKey)\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String PostData = "MgtKey=" + mgtKey;
        return this.httppost("/Cashbill/" + itemKey, corpNum, PostData, userID, "", Response.class, "application/x-www-form-urlencoded; charset=utf-8");
    }

    @Override
    public String getPDFURL(String CorpNum, String MgtKey) throws PopbillException {
        return this.getPDFURL(CorpNum, MgtKey, null);
    }

    @Override
    public String getPDFURL(String CorpNum, String MgtKey, String UserID) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        BaseServiceImp.URLResponse response = this.httpget("/Cashbill/" + MgtKey + "?TG=PDF", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public byte[] getPDF(String CorpNum, String MgtKey) throws PopbillException {
        return this.getPDF(CorpNum, MgtKey, null);
    }

    @Override
    public byte[] getPDF(String CorpNum, String MgtKey, String UserID) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        byte[] result = this.httpget("/Cashbill/" + MgtKey + "?PDF", CorpNum, UserID, byte[].class);
        return result;
    }

    @Override
    public String getPrintURL(String CorpNum, String MgtKey) throws PopbillException {
        return this.getPrintURL(CorpNum, MgtKey, null);
    }

    @Override
    public String getPrintURL(String CorpNum, String MgtKey, String UserID) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        BaseServiceImp.URLResponse response = this.httpget("/Cashbill/" + MgtKey + "?TG=PRINT", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public String getEPrintURL(String CorpNum, String MgtKey) throws PopbillException {
        return this.getEPrintURL(CorpNum, MgtKey, null);
    }

    @Override
    public String getEPrintURL(String CorpNum, String MgtKey, String UserID) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        BaseServiceImp.URLResponse response = this.httpget("/Cashbill/" + MgtKey + "?TG=EPRINT", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public String getMassPrintURL(String CorpNum, String[] MgtKeyList) throws PopbillException {
        return this.getMassPrintURL(CorpNum, MgtKeyList, null);
    }

    @Override
    public String getMassPrintURL(String CorpNum, String[] MgtKeyList, String UserID) throws PopbillException {
        if (MgtKeyList == null || MgtKeyList.length == 0) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\ubc30\uc5f4\uc774 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String PostData = this.toJsonString(MgtKeyList);
        BaseServiceImp.URLResponse response = this.httppost("/Cashbill/Prints", CorpNum, PostData, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public String getMailURL(String CorpNum, String MgtKey) throws PopbillException {
        return this.getMailURL(CorpNum, MgtKey, null);
    }

    @Override
    public String getMailURL(String CorpNum, String MgtKey, String UserID) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        BaseServiceImp.URLResponse response = this.httpget("/Cashbill/" + MgtKey + "?TG=MAIL", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public String getPopUpURL(String CorpNum, String MgtKey) throws PopbillException {
        return this.getPopUpURL(CorpNum, MgtKey, null);
    }

    @Override
    public String getPopUpURL(String CorpNum, String MgtKey, String UserID) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        BaseServiceImp.URLResponse response = this.httpget("/Cashbill/" + MgtKey + "?TG=POPUP", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public String getViewURL(String CorpNum, String MgtKey) throws PopbillException {
        return this.getViewURL(CorpNum, MgtKey, null);
    }

    @Override
    public String getViewURL(String CorpNum, String MgtKey, String UserID) throws PopbillException {
        if (MgtKey == null || MgtKey.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        BaseServiceImp.URLResponse response = this.httpget("/Cashbill/" + MgtKey + "?TG=VIEW", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public CBIssueResponse registIssue(String CorpNum, Cashbill cashbill) throws PopbillException {
        return this.registIssue(CorpNum, cashbill, null, null);
    }

    @Override
    public CBIssueResponse registIssue(String CorpNum, Cashbill cashbill, String memo) throws PopbillException {
        return this.registIssue(CorpNum, cashbill, memo, null);
    }

    @Override
    public CBIssueResponse registIssue(String CorpNum, Cashbill cashbill, String memo, String UserID) throws PopbillException {
        return this.registIssue(CorpNum, cashbill, memo, null, null);
    }

    @Override
    public CBIssueResponse registIssue(String CorpNum, Cashbill cashbill, String memo, String UserID, String emailSubject) throws PopbillException {
        if (cashbill == null) {
            throw new PopbillException(-99999999L, "\ud604\uae08\uc601\uc218\uc99d\uc815\ubcf4\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (memo != null) {
            cashbill.setMemo(memo);
        }
        if (emailSubject != null) {
            cashbill.setEmailSubject(emailSubject);
        }
        String PostData = this.toJsonString(cashbill);
        return this.httppost("/Cashbill", CorpNum, PostData, UserID, "ISSUE", CBIssueResponse.class);
    }

    @Override
    public BulkResponse bulkSubmit(String CorpNum, String SubmitID, List<Cashbill> cashbillList) throws PopbillException {
        return this.bulkSubmit(CorpNum, SubmitID, cashbillList, null);
    }

    @Override
    public BulkResponse bulkSubmit(String CorpNum, String SubmitID, List<Cashbill> cashbillList, String UserID) throws PopbillException {
        if (SubmitID == null || SubmitID.equals("")) {
            throw new PopbillException(-99999999L, "\uc81c\ucd9c\uc544\uc774\ub514(SubmitID)\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (cashbillList == null) {
            throw new PopbillException(-99999999L, "\ud604\uae08\uc601\uc218\uc99d \uc815\ubcf4\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        BulkCashbillSubmit cs = new BulkCashbillSubmit();
        cs.setCashList(cashbillList);
        String PostData = this.toJsonString(cs);
        return this.httpBulkPost("/Cashbill", CorpNum, SubmitID, PostData, UserID, "BULKISSUE", BulkResponse.class);
    }

    @Override
    public BulkCashbillResult getBulkResult(String CorpNum, String SubmitID) throws PopbillException {
        return this.getBulkResult(CorpNum, SubmitID, null);
    }

    @Override
    public BulkCashbillResult getBulkResult(String CorpNum, String SubmitID, String UserID) throws PopbillException {
        if (SubmitID == null || SubmitID.equals("")) {
            throw new PopbillException(-99999999L, "\uc81c\ucd9c\uc544\uc774\ub514(SubmitID)\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/Cashbill/BULK/" + SubmitID + "/State", CorpNum, UserID, BulkCashbillResult.class);
    }

    @Override
    public CBSearchResult search(String CorpNum, String DType, String SDate, String EDate, String[] State, String[] TradeType, String[] TradeUsage, String[] TaxationType, int Page, int PerPage, String Order) throws PopbillException {
        return this.search(CorpNum, DType, SDate, EDate, State, TradeType, TradeUsage, null, TaxationType, null, Page, PerPage, Order, null);
    }

    @Override
    public CBSearchResult search(String CorpNum, String DType, String SDate, String EDate, String[] State, String[] TradeType, String[] TradeUsage, String[] TaxationType, String QString, int Page, int PerPage, String Order) throws PopbillException {
        return this.search(CorpNum, DType, SDate, EDate, State, TradeType, TradeUsage, null, TaxationType, QString, Page, PerPage, Order, null);
    }

    @Override
    public CBSearchResult search(String CorpNum, String DType, String SDate, String EDate, String[] State, String[] TradeType, String[] TradeUsage, String[] TradeOpt, String[] TaxationType, String QString, int Page, int PerPage, String Order) throws PopbillException {
        return this.search(CorpNum, DType, SDate, EDate, State, TradeType, TradeUsage, TradeOpt, TaxationType, QString, Page, PerPage, Order, null);
    }

    @Override
    public CBSearchResult search(String CorpNum, String DType, String SDate, String EDate, String[] State, String[] TradeType, String[] TradeUsage, String[] TradeOpt, String[] TaxationType, String QString, int Page, int PerPage, String Order, String FranchiseTaxRegID) throws PopbillException {
        if (DType == null || DType.isEmpty()) {
            throw new PopbillException(-99999999L, "\uac80\uc0c9\uc77c\uc790\uc720\ud615\uc774  \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (SDate == null || SDate.isEmpty()) {
            throw new PopbillException(-99999999L, "\uc2dc\uc791\uc77c\uc790\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (EDate == null || EDate.isEmpty()) {
            throw new PopbillException(-99999999L, "\uc885\ub8cc\uc77c\uc790\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String uri = "/Cashbill/Search?DType=" + DType;
        uri = uri + "&SDate=" + SDate;
        uri = uri + "&EDate=" + EDate;
        uri = uri + "&State=" + Arrays.toString(State).replaceAll("\\[|\\]|\\s", "");
        uri = uri + "&TradeType=" + Arrays.toString(TradeType).replaceAll("\\[|\\]|\\s", "");
        uri = uri + "&TradeUsage=" + Arrays.toString(TradeUsage).replaceAll("\\[|\\]|\\s", "");
        if (TradeOpt != null) {
            uri = uri + "&TradeOpt=" + Arrays.toString(TradeOpt).replaceAll("\\[|\\]|\\s", "");
        }
        uri = uri + "&TaxationType=" + Arrays.toString(TaxationType).replaceAll("\\[|\\]|\\s", "");
        if (QString != null && QString != "") {
            uri = uri + "&QString=" + QString;
        }
        uri = uri + "&Page=" + Integer.toString(Page);
        uri = uri + "&PerPage=" + Integer.toString(PerPage);
        uri = uri + "&Order=" + Order;
        if (FranchiseTaxRegID != null && FranchiseTaxRegID != "") {
            uri = uri + "&FranchiseTaxRegID=" + FranchiseTaxRegID;
        }
        return this.httpget(uri, CorpNum, null, CBSearchResult.class);
    }

    @Override
    public ChargeInfo getChargeInfo(String CorpNum) throws PopbillException {
        return this.httpget("/Cashbill/ChargeInfo", CorpNum, null, ChargeInfo.class);
    }

    @Override
    public Response revokeRegister(String CorpNum, String mgtKey, String orgConfirmNum, String orgTradeDate) throws PopbillException {
        return this.revokeRegister(CorpNum, mgtKey, orgConfirmNum, orgTradeDate, false, false, null, null, null, null, null, null);
    }

    @Override
    public Response revokeRegister(String CorpNum, String mgtKey, String orgConfirmNum, String orgTradeDate, Boolean smssendYN) throws PopbillException {
        return this.revokeRegister(CorpNum, mgtKey, orgConfirmNum, orgTradeDate, smssendYN, false, null, null, null, null, null, null);
    }

    @Override
    public Response revokeRegister(String CorpNum, String mgtKey, String orgConfirmNum, String orgTradeDate, Boolean smssendYN, String UserID) throws PopbillException {
        return this.revokeRegister(CorpNum, mgtKey, orgConfirmNum, orgTradeDate, smssendYN, false, null, null, null, null, null, UserID);
    }

    @Override
    public Response revokeRegister(String CorpNum, String mgtKey, String orgConfirmNum, String orgTradeDate, Boolean smssendYN, Boolean isPartCancel, Integer cancelType, String supplyCost, String tax, String serviceFee, String totalAmount) throws PopbillException {
        return this.revokeRegister(CorpNum, mgtKey, orgConfirmNum, orgTradeDate, smssendYN, isPartCancel, cancelType, supplyCost, tax, serviceFee, totalAmount, null);
    }

    @Override
    public Response revokeRegister(String CorpNum, String mgtKey, String orgConfirmNum, String orgTradeDate, Boolean smssendYN, Boolean isPartCancel, Integer cancelType, String supplyCost, String tax, String serviceFee, String totalAmount, String UserID) throws PopbillException {
        if (mgtKey == null) {
            throw new PopbillException(-99999999L, "\ucde8\uc18c\ud604\uae08\uc601\uc218\uc99d \ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        RevokeRequest request = new RevokeRequest();
        request.mgtKey = mgtKey;
        request.orgConfirmNum = orgConfirmNum;
        request.orgTradeDate = orgTradeDate;
        request.smssendYN = smssendYN;
        request.isPartCancel = isPartCancel;
        request.cancelType = cancelType;
        request.supplyCost = supplyCost;
        request.tax = tax;
        request.serviceFee = serviceFee;
        request.totalAmount = totalAmount;
        String PostData = this.toJsonString(request);
        return this.httppost("/Cashbill", CorpNum, PostData, UserID, "REVOKE", Response.class);
    }

    @Override
    public CBIssueResponse revokeRegistIssue(String CorpNum, String mgtKey, String orgConfirmNum, String orgTradeDate) throws PopbillException {
        return this.revokeRegistIssue(CorpNum, mgtKey, orgConfirmNum, orgTradeDate, false, null, false, null, null, null, null, null, null, null, null);
    }

    @Override
    public CBIssueResponse revokeRegistIssue(String CorpNum, String mgtKey, String orgConfirmNum, String orgTradeDate, Boolean smssendYN) throws PopbillException {
        return this.revokeRegistIssue(CorpNum, mgtKey, orgConfirmNum, orgTradeDate, smssendYN, null, false, null, null, null, null, null, null, null, null);
    }

    @Override
    public CBIssueResponse revokeRegistIssue(String CorpNum, String mgtKey, String orgConfirmNum, String orgTradeDate, Boolean smssendYN, String memo) throws PopbillException {
        return this.revokeRegistIssue(CorpNum, mgtKey, orgConfirmNum, orgTradeDate, smssendYN, memo, false, null, null, null, null, null, null, null, null);
    }

    @Override
    public CBIssueResponse revokeRegistIssue(String CorpNum, String mgtKey, String orgConfirmNum, String orgTradeDate, Boolean smssendYN, String memo, String userID) throws PopbillException {
        return this.revokeRegistIssue(CorpNum, mgtKey, orgConfirmNum, orgTradeDate, smssendYN, memo, false, null, null, null, null, null, userID, null, null);
    }

    @Override
    public CBIssueResponse revokeRegistIssue(String CorpNum, String mgtKey, String orgConfirmNum, String orgTradeDate, Boolean smssendYN, String memo, String userID, String emailSubject) throws PopbillException {
        return this.revokeRegistIssue(CorpNum, mgtKey, orgConfirmNum, orgTradeDate, smssendYN, memo, false, null, null, null, null, null, userID, emailSubject, null);
    }

    @Override
    public CBIssueResponse revokeRegistIssue(String CorpNum, String mgtKey, String orgConfirmNum, String orgTradeDate, Boolean smssendYN, String memo, Boolean isPartCancel, Integer cancelType, String supplyCost, String tax, String serviceFee, String totalAmount) throws PopbillException {
        return this.revokeRegistIssue(CorpNum, mgtKey, orgConfirmNum, orgTradeDate, smssendYN, memo, isPartCancel, cancelType, supplyCost, tax, serviceFee, totalAmount, null, null, null);
    }

    @Override
    public CBIssueResponse revokeRegistIssue(String CorpNum, String mgtKey, String orgConfirmNum, String orgTradeDate, Boolean smssendYN, String memo, Boolean isPartCancel, Integer cancelType, String supplyCost, String tax, String serviceFee, String totalAmount, String userID) throws PopbillException {
        return this.revokeRegistIssue(CorpNum, mgtKey, orgConfirmNum, orgTradeDate, smssendYN, memo, isPartCancel, cancelType, supplyCost, tax, serviceFee, totalAmount, null, null, null);
    }

    @Override
    public CBIssueResponse revokeRegistIssue(String CorpNum, String mgtKey, String orgConfirmNum, String orgTradeDate, Boolean smssendYN, String memo, Boolean isPartCancel, Integer cancelType, String supplyCost, String tax, String serviceFee, String totalAmount, String userID, String emailSubject) throws PopbillException {
        return this.revokeRegistIssue(CorpNum, mgtKey, orgConfirmNum, orgTradeDate, smssendYN, memo, isPartCancel, cancelType, supplyCost, tax, serviceFee, totalAmount, null, null, null);
    }

    @Override
    public CBIssueResponse revokeRegistIssue(String CorpNum, String mgtKey, String orgConfirmNum, String orgTradeDate, Boolean smssendYN, String memo, Boolean isPartCancel, Integer cancelType, String supplyCost, String tax, String serviceFee, String totalAmount, String userID, String emailSubject, String tradeDT) throws PopbillException {
        if (mgtKey == null) {
            throw new PopbillException(-99999999L, "\ucde8\uc18c\ud604\uae08\uc601\uc218\uc99d \ubb38\uc11c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        RevokeRequest request = new RevokeRequest();
        if (emailSubject != null) {
            request.emailSubject = emailSubject;
        }
        request.mgtKey = mgtKey;
        request.orgConfirmNum = orgConfirmNum;
        request.orgTradeDate = orgTradeDate;
        request.smssendYN = smssendYN;
        request.memo = memo;
        request.isPartCancel = isPartCancel;
        request.cancelType = cancelType;
        request.supplyCost = supplyCost;
        request.serviceFee = serviceFee;
        request.tax = tax;
        request.totalAmount = totalAmount;
        request.tradeDT = tradeDT;
        String PostData = this.toJsonString(request);
        return this.httppost("/Cashbill", CorpNum, PostData, userID, "REVOKEISSUE", CBIssueResponse.class);
    }

    @Override
    public Response updateEmailConfig(String CorpNum, String EmailType, Boolean SendYN) throws PopbillException {
        return this.updateEmailConfig(CorpNum, EmailType, SendYN, null);
    }

    @Override
    public Response updateEmailConfig(String CorpNum, String EmailType, Boolean SendYN, String UserID) throws PopbillException {
        if (SendYN == null) {
            throw new PopbillException(-99999999L, "\uba54\uc77c\uc804\uc1a1\uc5ec\ubd80(SendYN)\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (EmailType == null || EmailType.isEmpty()) {
            throw new PopbillException(-99999999L, "\uba54\uc77c\uc804\uc1a1\uc720\ud615(EmailType)\uc774 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httppost("/Cashbill/EmailSendConfig?EmailType=" + EmailType + "&SendYN=" + String.valueOf(SendYN), CorpNum, null, UserID, "", Response.class);
    }

    @Override
    public EmailSendConfig[] listEmailConfig(String CorpNum) throws PopbillException {
        return this.httpget("/Cashbill/EmailSendConfig", CorpNum, null, EmailSendConfig[].class);
    }

    @Override
    public EmailSendConfig[] listEmailConfig(String CorpNum, String UserID) throws PopbillException {
        return this.httpget("/Cashbill/EmailSendConfig", CorpNum, UserID, EmailSendConfig[].class);
    }

    protected class RevokeRequest {
        public String mgtKey;
        public String orgTradeDate;
        public String orgConfirmNum;
        public Boolean smssendYN;
        public String memo;
        public Boolean isPartCancel;
        public Integer cancelType;
        public String supplyCost;
        public String tax;
        public String serviceFee;
        public String totalAmount;
        public String emailSubject;
        public String tradeDT;

        protected RevokeRequest() {
        }
    }

    protected class ResendRequest {
        public String receiver;
        public String sender = null;
        public String contents = null;

        protected ResendRequest() {
        }
    }

    protected class MemoRequest {
        public String memo;

        public MemoRequest(String memo) {
            this.memo = memo;
        }
    }
}

