/*
 * Decompiled with CFR 0.152.
 */
package com.popbill.api.easyfin;

import com.popbill.api.BaseServiceImp;
import com.popbill.api.ChargeInfo;
import com.popbill.api.EasyFinBankService;
import com.popbill.api.FlatRateState;
import com.popbill.api.PopbillException;
import com.popbill.api.Response;
import com.popbill.api.easyfin.EasyFinBankAccount;
import com.popbill.api.easyfin.EasyFinBankAccountForm;
import com.popbill.api.easyfin.EasyFinBankJobState;
import com.popbill.api.easyfin.EasyFinBankSearchResult;
import com.popbill.api.easyfin.EasyFinBankSummary;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;

public class EasyFinBankServiceImp
extends BaseServiceImp
implements EasyFinBankService {
    @Override
    protected List<String> getScopes() {
        return Arrays.asList("180");
    }

    @Override
    public String getBankAccountMgtURL(String CorpNum) throws PopbillException {
        return this.getBankAccountMgtURL(CorpNum, null);
    }

    @Override
    public String getBankAccountMgtURL(String CorpNum, String UserID) throws PopbillException {
        BaseServiceImp.URLResponse response = this.httpget("/EasyFin/Bank?TG=BankAccount", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public Response registBankAccount(String CorpNum, EasyFinBankAccountForm form) throws PopbillException {
        return this.registBankAccount(CorpNum, form, null);
    }

    @Override
    public Response registBankAccount(String CorpNum, EasyFinBankAccountForm form, String UserID) throws PopbillException {
        if (form == null) {
            throw new PopbillException(-99999999L, "\uc740\ud589 \uacc4\uc88c\uc815\ubcf4\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (form.getBankCode() == null || form.getBankCode().isEmpty()) {
            throw new PopbillException(-99999999L, "\uae30\uad00\ucf54\ub4dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (form.getBankCode().length() != 4) {
            throw new PopbillException(-99999999L, "\uae30\uad00\ucf54\ub4dc\uac00 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
        }
        if (form.getAccountNumber() == null || form.getAccountNumber().isEmpty()) {
            throw new PopbillException(-99999999L, "\uacc4\uc88c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (form.getAccountPWD() == null || form.getAccountPWD().isEmpty()) {
            throw new PopbillException(-99999999L, "\uacc4\uc88c \ube44\ubc00\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (form.getAccountType() == null || form.getAccountType().isEmpty()) {
            throw new PopbillException(-99999999L, "\uacc4\uc88c\uc720\ud615\uc774 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (!form.getAccountType().equals("\uac1c\uc778") && !form.getAccountType().equals("\ubc95\uc778")) {
            throw new PopbillException(-99999999L, "\uacc4\uc88c\uc720\ud615\uc774 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
        }
        if (form.getIdentityNumber() == null || form.getIdentityNumber().isEmpty()) {
            throw new PopbillException(-99999999L, "\uc608\uae08\uc8fc \uc2dd\ubcc4\uc815\ubcf4\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String uri = "/EasyFin/Bank/BankAccount/Regist";
        if (null != form.getUsePeriod()) {
            uri = uri + "?UsePeriod=" + form.getUsePeriod();
        }
        String PostData = this.toJsonString(form);
        return this.httppost(uri, CorpNum, PostData, UserID, Response.class);
    }

    @Override
    public Response closeBankAccount(String CorpNum, String BankCode, String AccountNumber, String CloseType) throws PopbillException {
        return this.closeBankAccount(CorpNum, BankCode, AccountNumber, CloseType, null);
    }

    @Override
    public Response closeBankAccount(String CorpNum, String BankCode, String AccountNumber, String CloseType, String UserID) throws PopbillException {
        if (BankCode == null || BankCode.isEmpty()) {
            throw new PopbillException(-99999999L, "\uae30\uad00\ucf54\ub4dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (BankCode.length() != 4) {
            throw new PopbillException(-99999999L, "\uae30\uad00\ucf54\ub4dc\uac00 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
        }
        if (AccountNumber == null || AccountNumber.isEmpty()) {
            throw new PopbillException(-99999999L, "\uacc4\uc88c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (CloseType == null || CloseType.isEmpty()) {
            throw new PopbillException(-99999999L, "\uc815\uc561\uc81c \ud574\uc9c0\uc720\ud615\uc774 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (!CloseType.equals("\uc911\ub3c4") && !CloseType.equals("\uc77c\ubc18")) {
            throw new PopbillException(-99999999L, "\uc815\uc561\uc81c \ud574\uc9c0\uc720\ud615\uc774 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
        }
        String uri = "/EasyFin/Bank/BankAccount/Close";
        uri = uri + "?BankCode=" + BankCode;
        uri = uri + "&AccountNumber=" + AccountNumber;
        uri = uri + "&CloseType=" + CloseType;
        return this.httppost(uri, CorpNum, null, UserID, Response.class);
    }

    @Override
    public Response revokeCloseBankAccount(String CorpNum, String BankCode, String AccountNumber) throws PopbillException {
        return this.revokeCloseBankAccount(CorpNum, BankCode, AccountNumber, null);
    }

    @Override
    public Response revokeCloseBankAccount(String CorpNum, String BankCode, String AccountNumber, String UserID) throws PopbillException {
        if (BankCode == null || BankCode.isEmpty()) {
            throw new PopbillException(-99999999L, "\uae30\uad00\ucf54\ub4dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (BankCode.length() != 4) {
            throw new PopbillException(-99999999L, "\uae30\uad00\ucf54\ub4dc\uac00 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
        }
        if (AccountNumber == null || AccountNumber.isEmpty()) {
            throw new PopbillException(-99999999L, "\uacc4\uc88c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String uri = "/EasyFin/Bank/BankAccount/RevokeClose";
        uri = uri + "?BankCode=" + BankCode;
        uri = uri + "&AccountNumber=" + AccountNumber;
        return this.httppost(uri, CorpNum, null, UserID, Response.class);
    }

    @Override
    public Response deleteBankAccount(String CorpNum, String BankCode, String AccountNumber) throws PopbillException {
        return this.deleteBankAccount(CorpNum, BankCode, AccountNumber, null);
    }

    @Override
    public Response deleteBankAccount(String CorpNum, String BankCode, String AccountNumber, String UserID) throws PopbillException {
        if (BankCode == null || BankCode.isEmpty()) {
            throw new PopbillException(-99999999L, "\uae30\uad00\ucf54\ub4dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (BankCode.length() != 4) {
            throw new PopbillException(-99999999L, "\uae30\uad00\ucf54\ub4dc\uac00 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
        }
        if (AccountNumber == null || AccountNumber.isEmpty()) {
            throw new PopbillException(-99999999L, "\uacc4\uc88c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String uri = "/EasyFin/Bank/BankAccount/Delete";
        String PostData = "{'BankCode':" + BankCode + ", 'AccountNumber':" + AccountNumber + "}";
        return this.httppost(uri, CorpNum, PostData, UserID, Response.class);
    }

    @Override
    public Response updateBankAccount(String CorpNum, EasyFinBankAccountForm form) throws PopbillException {
        return this.updateBankAccount(CorpNum, form, null);
    }

    @Override
    public Response updateBankAccount(String CorpNum, EasyFinBankAccountForm form, String UserID) throws PopbillException {
        if (form == null) {
            throw new PopbillException(-99999999L, "\uc740\ud589 \uacc4\uc88c\uc815\ubcf4\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (form.getBankCode() == null || form.getBankCode().isEmpty()) {
            throw new PopbillException(-99999999L, "\uae30\uad00\ucf54\ub4dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (form.getBankCode().length() != 4) {
            throw new PopbillException(-99999999L, "\uae30\uad00\ucf54\ub4dc\uac00 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
        }
        if (form.getAccountNumber() == null || form.getAccountNumber().isEmpty()) {
            throw new PopbillException(-99999999L, "\uacc4\uc88c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (form.getAccountPWD() == null || form.getAccountPWD().isEmpty()) {
            throw new PopbillException(-99999999L, "\uacc4\uc88c \ube44\ubc00\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String uri = "/EasyFin/Bank/BankAccount/" + form.getBankCode() + "/" + form.getAccountNumber() + "/Update";
        String PostData = this.toJsonString(form);
        return this.httppost(uri, CorpNum, PostData, UserID, Response.class);
    }

    @Override
    public EasyFinBankAccount getBankAccountInfo(String CorpNum, String BankCode, String AccountNumber) throws PopbillException {
        return this.getBankAccountInfo(CorpNum, BankCode, AccountNumber, null);
    }

    @Override
    public EasyFinBankAccount getBankAccountInfo(String CorpNum, String BankCode, String AccountNumber, String UserID) throws PopbillException {
        if (BankCode == null || BankCode.isEmpty()) {
            throw new PopbillException(-99999999L, "\uae30\uad00\ucf54\ub4dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (BankCode.length() != 4) {
            throw new PopbillException(-99999999L, "\uae30\uad00\ucf54\ub4dc\uac00 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
        }
        if (AccountNumber == null || AccountNumber.isEmpty()) {
            throw new PopbillException(-99999999L, "\uacc4\uc88c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/EasyFin/Bank/BankAccount/" + BankCode + "/" + AccountNumber, CorpNum, UserID, EasyFinBankAccount.class);
    }

    @Override
    public EasyFinBankAccount[] listBankAccount(String CorpNum) throws PopbillException {
        return this.listBankAccount(CorpNum, null);
    }

    @Override
    public EasyFinBankAccount[] listBankAccount(String CorpNum, String UserID) throws PopbillException {
        return this.httpget("/EasyFin/Bank/ListBankAccount", CorpNum, UserID, EasyFinBankAccount[].class);
    }

    @Override
    public String requestJob(String CorpNum, String BankCode, String AccountNumber, String SDate, String EDate) throws PopbillException {
        return this.requestJob(CorpNum, BankCode, AccountNumber, SDate, EDate, null);
    }

    @Override
    public String requestJob(String CorpNum, String BankCode, String AccountNumber, String SDate, String EDate, String UserID) throws PopbillException {
        if (BankCode == null || BankCode.isEmpty()) {
            throw new PopbillException(-99999999L, "\uae30\uad00\ucf54\ub4dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (AccountNumber == null || AccountNumber.isEmpty()) {
            throw new PopbillException(-99999999L, "\uacc4\uc88c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (SDate == null || SDate.isEmpty()) {
            throw new PopbillException(-99999999L, "\uc870\ud68c \uc2dc\uc791\uc77c\uc790\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (EDate == null || EDate.isEmpty()) {
            throw new PopbillException(-99999999L, "\uc870\ud68c \uc885\ub8cc\uc77c\uc790\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        JobIDResponse response = this.httppost("/EasyFin/Bank/BankAccount?AccountNumber=" + AccountNumber + "&BankCode=" + BankCode + "&SDate=" + SDate + "&EDate=" + EDate, CorpNum, null, UserID, JobIDResponse.class);
        return response.jobID;
    }

    @Override
    public EasyFinBankJobState getJobState(String CorpNum, String JobID) throws PopbillException {
        return this.getJobState(CorpNum, JobID, null);
    }

    @Override
    public EasyFinBankJobState getJobState(String CorpNum, String JobID, String UserID) throws PopbillException {
        if (JobID == null || JobID.isEmpty()) {
            throw new PopbillException(-99999999L, "\uc791\uc5c5\uc544\uc774\ub514\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/EasyFin/Bank/" + JobID + "/State", CorpNum, UserID, EasyFinBankJobState.class);
    }

    @Override
    public EasyFinBankJobState[] listActiveJob(String CorpNum) throws PopbillException {
        return this.listActiveJob(CorpNum, null);
    }

    @Override
    public EasyFinBankJobState[] listActiveJob(String CorpNum, String UserID) throws PopbillException {
        return this.httpget("/EasyFin/Bank/JobList", CorpNum, UserID, EasyFinBankJobState[].class);
    }

    @Override
    public EasyFinBankSearchResult search(String CorpNum, String JobID, String[] TradeType, String SearchString, Integer Page, Integer PerPage, String Order) throws PopbillException {
        return this.search(CorpNum, JobID, TradeType, SearchString, Page, PerPage, Order, null);
    }

    @Override
    public EasyFinBankSearchResult search(String CorpNum, String JobID, String[] TradeType, String SearchString, Integer Page, Integer PerPage, String Order, String UserID) throws PopbillException {
        if (JobID.length() != 18) {
            throw new PopbillException(-99999999L, "\uc791\uc5c5\uc544\uc774\ub514\uac00 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
        }
        String uri = "/EasyFin/Bank/" + JobID;
        uri = uri + "?TradeType=" + Arrays.toString(TradeType).replaceAll("\\[|\\]|\\s", "");
        if (SearchString != "" && SearchString != null) {
            try {
                uri = uri + "&SearchString=" + URLEncoder.encode(SearchString, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new PopbillException(-99999999L, "\uac80\uc0c9\uc5b4(SearchString) \uc778\ucf54\ub529 \uc624\ub958");
            }
        }
        uri = uri + "&Page=" + Integer.toString(Page);
        uri = uri + "&PerPage=" + Integer.toString(PerPage);
        uri = uri + "&Order=" + Order;
        return this.httpget(uri, CorpNum, UserID, EasyFinBankSearchResult.class);
    }

    @Override
    public EasyFinBankSummary summary(String CorpNum, String JobID, String[] TradeType, String SearchString) throws PopbillException {
        return this.summary(CorpNum, JobID, TradeType, SearchString, null);
    }

    @Override
    public EasyFinBankSummary summary(String CorpNum, String JobID, String[] TradeType, String SearchString, String UserID) throws PopbillException {
        if (JobID.length() != 18) {
            throw new PopbillException(-99999999L, "\uc791\uc5c5\uc544\uc774\ub514\uac00 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
        }
        String uri = "/EasyFin/Bank/" + JobID + "/Summary";
        uri = uri + "?TradeType=" + Arrays.toString(TradeType).replaceAll("\\[|\\]|\\s", "");
        if (SearchString != "" && SearchString != null) {
            try {
                uri = uri + "&SearchString=" + URLEncoder.encode(SearchString, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new PopbillException(-99999999L, "\uac80\uc0c9\uc5b4(SearchString) \uc778\ucf54\ub529 \uc624\ub958");
            }
        }
        return this.httpget(uri, CorpNum, UserID, EasyFinBankSummary.class);
    }

    @Override
    public Response saveMemo(String CorpNum, String TID, String Memo) throws PopbillException {
        return this.saveMemo(CorpNum, TID, Memo, null);
    }

    @Override
    public Response saveMemo(String CorpNum, String TID, String Memo, String UserID) throws PopbillException {
        if (TID == null || TID.isEmpty()) {
            throw new PopbillException(-99999999L, "\uac70\ub798\ub0b4\uc5ed \uc544\uc774\ub514\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (Memo == null) {
            throw new PopbillException(-99999999L, "\uba54\ubaa8\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String uri = "/EasyFin/Bank/SaveMemo";
        uri = uri + "?TID=" + TID;
        if (Memo != "" && Memo != null) {
            try {
                uri = uri + "&Memo=" + URLEncoder.encode(Memo, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new PopbillException(-99999999L, "\uba54\ubaa8(Memo) \uc778\ucf54\ub529 \uc624\ub958");
            }
        }
        return this.httppost(uri, CorpNum, null, UserID, Response.class);
    }

    @Override
    public FlatRateState getFlatRateState(String CorpNum, String BankCode, String AccountNumber) throws PopbillException {
        return this.getFlatRateState(CorpNum, BankCode, AccountNumber, null);
    }

    @Override
    public FlatRateState getFlatRateState(String CorpNum, String BankCode, String AccountNumber, String UserID) throws PopbillException {
        if (BankCode == null || BankCode.isEmpty()) {
            throw new PopbillException(-99999999L, "\uae30\uad00\ucf54\ub4dc\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (AccountNumber == null || AccountNumber.isEmpty()) {
            throw new PopbillException(-99999999L, "\uacc4\uc88c\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/EasyFin/Bank/Contract/" + BankCode + "/" + AccountNumber, CorpNum, UserID, FlatRateState.class);
    }

    @Override
    public String getFlatRatePopUpURL(String CorpNum) throws PopbillException {
        return this.getFlatRatePopUpURL(CorpNum, null);
    }

    @Override
    public String getFlatRatePopUpURL(String CorpNum, String UserID) throws PopbillException {
        BaseServiceImp.URLResponse response = this.httpget("/EasyFin/Bank?TG=CHRG", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public ChargeInfo getChargeInfo(String CorpNum) throws PopbillException {
        return this.httpget("/EasyFin/Bank/ChargeInfo", CorpNum, null, ChargeInfo.class);
    }

    protected class TIDMemoRequest {
        public String tID;
        public String memo;

        protected TIDMemoRequest() {
        }
    }

    protected class JobIDResponse {
        public String jobID;

        protected JobIDResponse() {
        }
    }
}

