/*
 * Decompiled with CFR 0.152.
 */
package com.popbill.api.fax;

import com.popbill.api.BaseServiceImp;
import com.popbill.api.ChargeInfo;
import com.popbill.api.FaxService;
import com.popbill.api.FaxUploadFile;
import com.popbill.api.PopbillException;
import com.popbill.api.Response;
import com.popbill.api.fax.FAXSearchResult;
import com.popbill.api.fax.FaxResult;
import com.popbill.api.fax.Receiver;
import com.popbill.api.fax.SenderNumber;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class FaxServiceImp
extends BaseServiceImp
implements FaxService {
    @Override
    protected List<String> getScopes() {
        return Arrays.asList("160", "161");
    }

    @Override
    public float getUnitCost(String corpNum) throws PopbillException {
        BaseServiceImp.UnitCostResponse response = this.httpget("/FAX/UnitCost", corpNum, null, BaseServiceImp.UnitCostResponse.class);
        return response.unitCost;
    }

    @Override
    public float getUnitCost(String corpNum, String receiveNumType) throws PopbillException {
        BaseServiceImp.UnitCostResponse response = this.httpget("/FAX/UnitCost?receiveNumType=" + receiveNumType, corpNum, null, BaseServiceImp.UnitCostResponse.class);
        return response.unitCost;
    }

    @Override
    public String getURL(String corpNum, String TOGO) throws PopbillException {
        return this.getURL(corpNum, null, TOGO);
    }

    @Override
    public String getURL(String corpNum, String userID, String TOGO) throws PopbillException {
        BaseServiceImp.URLResponse response = this.httpget("/FAX/?TG=" + TOGO, corpNum, userID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, String receiveNum, String receiveName, File file, Date reserveDT) throws PopbillException {
        Receiver receiver = new Receiver();
        receiver.setReceiveNum(receiveNum);
        receiver.setReceiveName(receiveName);
        return this.requestFax(corpNum, sendNum, null, new Receiver[]{receiver}, new File[]{file}, reserveDT, null, null, null, null);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, String receiveNum, String receiveName, FaxUploadFile file, Date reserveDT) throws PopbillException {
        Receiver receiver = new Receiver();
        receiver.setReceiveNum(receiveNum);
        receiver.setReceiveName(receiveName);
        return this.requestFaxBinary(corpNum, sendNum, null, new Receiver[]{receiver}, new FaxUploadFile[]{file}, reserveDT, null, null, null, null);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, String receiveNum, String receiveName, File file, Date reserveDT, Boolean adsYN) throws PopbillException {
        Receiver receiver = null;
        receiver = new Receiver();
        receiver.setReceiveNum(receiveNum);
        receiver.setReceiveName(receiveName);
        return this.requestFax(corpNum, sendNum, null, new Receiver[]{receiver}, new File[]{file}, reserveDT, null, adsYN, null, null);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, String receiveNum, String receiveName, FaxUploadFile file, Date reserveDT, Boolean adsYN) throws PopbillException {
        Receiver receiver = null;
        receiver = new Receiver();
        receiver.setReceiveNum(receiveNum);
        receiver.setReceiveName(receiveName);
        return this.requestFaxBinary(corpNum, sendNum, null, new Receiver[]{receiver}, new FaxUploadFile[]{file}, reserveDT, null, adsYN, null, null);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, String receiveNum, String receiveName, File file, Date reserveDT, Boolean adsYN, String requestNum) throws PopbillException {
        Receiver receiver = null;
        receiver = new Receiver();
        receiver.setReceiveNum(receiveNum);
        receiver.setReceiveName(receiveName);
        return this.requestFax(corpNum, sendNum, null, new Receiver[]{receiver}, new File[]{file}, reserveDT, null, adsYN, null, requestNum);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, String receiveNum, String receiveName, FaxUploadFile file, Date reserveDT, Boolean adsYN, String requestNum) throws PopbillException {
        Receiver receiver = null;
        receiver = new Receiver();
        receiver.setReceiveNum(receiveNum);
        receiver.setReceiveName(receiveName);
        return this.requestFaxBinary(corpNum, sendNum, null, new Receiver[]{receiver}, new FaxUploadFile[]{file}, reserveDT, null, adsYN, null, requestNum);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, String receiveNum, String receiveName, File file, Date reserveDT, String userID) throws PopbillException {
        Receiver receiver = new Receiver();
        receiver.setReceiveNum(receiveNum);
        receiver.setReceiveName(receiveName);
        return this.requestFax(corpNum, sendNum, null, new Receiver[]{receiver}, new File[]{file}, reserveDT, userID, null, null, null);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, String receiveNum, String receiveName, FaxUploadFile file, Date reserveDT, String userID) throws PopbillException {
        Receiver receiver = new Receiver();
        receiver.setReceiveNum(receiveNum);
        receiver.setReceiveName(receiveName);
        return this.requestFaxBinary(corpNum, sendNum, null, new Receiver[]{receiver}, new FaxUploadFile[]{file}, reserveDT, userID, null, null, null);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, String receiveNum, String receiveName, File file, Date reserveDT, String userID, Boolean adsYN) throws PopbillException {
        Receiver receiver = new Receiver();
        receiver.setReceiveNum(receiveNum);
        receiver.setReceiveName(receiveName);
        return this.requestFax(corpNum, sendNum, null, new Receiver[]{receiver}, new File[]{file}, reserveDT, userID, adsYN, null, null);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, String receiveNum, String receiveName, FaxUploadFile file, Date reserveDT, String userID, Boolean adsYN) throws PopbillException {
        Receiver receiver = new Receiver();
        receiver.setReceiveNum(receiveNum);
        receiver.setReceiveName(receiveName);
        return this.requestFaxBinary(corpNum, sendNum, null, new Receiver[]{receiver}, new FaxUploadFile[]{file}, reserveDT, userID, adsYN, null, null);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, String receiveNum, String receiveName, File file, Date reserveDT, String userID, Boolean adsYN, String title) throws PopbillException {
        Receiver receiver = new Receiver();
        receiver.setReceiveNum(receiveNum);
        receiver.setReceiveName(receiveName);
        return this.requestFax(corpNum, sendNum, null, new Receiver[]{receiver}, new File[]{file}, reserveDT, userID, adsYN, title, null);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, String receiveNum, String receiveName, FaxUploadFile file, Date reserveDT, String userID, Boolean adsYN, String title) throws PopbillException {
        Receiver receiver = new Receiver();
        receiver.setReceiveNum(receiveNum);
        receiver.setReceiveName(receiveName);
        return this.requestFaxBinary(corpNum, sendNum, null, new Receiver[]{receiver}, new FaxUploadFile[]{file}, reserveDT, userID, adsYN, title, null);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, String receiveNum, String receiveName, File file, Date reserveDT, String userID, Boolean adsYN, String title, String requestNum) throws PopbillException {
        Receiver receiver = new Receiver();
        receiver.setReceiveNum(receiveNum);
        receiver.setReceiveName(receiveName);
        return this.requestFax(corpNum, sendNum, null, new Receiver[]{receiver}, new File[]{file}, reserveDT, userID, adsYN, title, requestNum);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, String receiveNum, String receiveName, FaxUploadFile file, Date reserveDT, String userID, Boolean adsYN, String title, String requestNum) throws PopbillException {
        Receiver receiver = new Receiver();
        receiver.setReceiveNum(receiveNum);
        receiver.setReceiveName(receiveName);
        return this.requestFaxBinary(corpNum, sendNum, null, new Receiver[]{receiver}, new FaxUploadFile[]{file}, reserveDT, userID, adsYN, title, requestNum);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, Receiver[] receivers, File file, Date reserveDT) throws PopbillException {
        return this.requestFax(corpNum, sendNum, null, receivers, new File[]{file}, reserveDT, null, null, null, null);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, Receiver[] receivers, FaxUploadFile file, Date reserveDT) throws PopbillException {
        return this.requestFaxBinary(corpNum, sendNum, null, receivers, new FaxUploadFile[]{file}, reserveDT, null, null, null, null);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, Receiver[] receivers, File file, Date reserveDT, Boolean adsYN) throws PopbillException {
        return this.requestFax(corpNum, sendNum, null, receivers, new File[]{file}, reserveDT, null, adsYN, null, null);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, Receiver[] receivers, FaxUploadFile file, Date reserveDT, Boolean adsYN) throws PopbillException {
        return this.requestFaxBinary(corpNum, sendNum, null, receivers, new FaxUploadFile[]{file}, reserveDT, null, adsYN, null, null);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, Receiver[] receivers, File file, Date reserveDT, Boolean adsYN, String title) throws PopbillException {
        return this.requestFax(corpNum, sendNum, null, receivers, new File[]{file}, reserveDT, null, adsYN, title, null);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, Receiver[] receivers, FaxUploadFile file, Date reserveDT, Boolean adsYN, String title) throws PopbillException {
        return this.requestFaxBinary(corpNum, sendNum, null, receivers, new FaxUploadFile[]{file}, reserveDT, null, adsYN, title, null);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, Receiver[] receivers, File file, Date reserveDT, Boolean adsYN, String title, String requestNum) throws PopbillException {
        return this.requestFax(corpNum, sendNum, null, receivers, new File[]{file}, reserveDT, null, adsYN, title, requestNum);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, Receiver[] receivers, FaxUploadFile file, Date reserveDT, Boolean adsYN, String title, String requestNum) throws PopbillException {
        return this.requestFaxBinary(corpNum, sendNum, null, receivers, new FaxUploadFile[]{file}, reserveDT, null, adsYN, title, requestNum);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, Receiver[] receivers, File file, Date reserveDT, String userID) throws PopbillException {
        return this.requestFax(corpNum, sendNum, null, receivers, new File[]{file}, reserveDT, userID, null, null, null);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, Receiver[] receivers, FaxUploadFile file, Date reserveDT, String userID) throws PopbillException {
        return this.requestFaxBinary(corpNum, sendNum, null, receivers, new FaxUploadFile[]{file}, reserveDT, userID, null, null, null);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, Receiver[] receivers, File file, Date reserveDT, String userID, String title) throws PopbillException {
        return this.requestFax(corpNum, sendNum, null, receivers, new File[]{file}, reserveDT, userID, false, title, null);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, Receiver[] receivers, FaxUploadFile file, Date reserveDT, String userID, String title) throws PopbillException {
        return this.requestFaxBinary(corpNum, sendNum, null, receivers, new FaxUploadFile[]{file}, reserveDT, userID, false, title, null);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, Receiver[] receivers, File file, Date reserveDT, String userID, String title, String requestNum) throws PopbillException {
        return this.requestFax(corpNum, sendNum, null, receivers, new File[]{file}, reserveDT, userID, false, title, requestNum);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, Receiver[] receivers, FaxUploadFile file, Date reserveDT, String userID, String title, String requestNum) throws PopbillException {
        return this.requestFaxBinary(corpNum, sendNum, null, receivers, new FaxUploadFile[]{file}, reserveDT, userID, false, title, requestNum);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, Receiver[] receivers, File file, Date reserveDT, String userID, Boolean adsYN) throws PopbillException {
        return this.requestFax(corpNum, sendNum, null, receivers, new File[]{file}, reserveDT, userID, adsYN, null, null);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, Receiver[] receivers, FaxUploadFile file, Date reserveDT, String userID, Boolean adsYN) throws PopbillException {
        return this.requestFaxBinary(corpNum, sendNum, null, receivers, new FaxUploadFile[]{file}, reserveDT, userID, adsYN, null, null);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, Receiver[] receivers, File file, Date reserveDT, String userID, Boolean adsYN, String title) throws PopbillException {
        return this.requestFax(corpNum, sendNum, null, receivers, new File[]{file}, reserveDT, userID, adsYN, title, null);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, Receiver[] receivers, FaxUploadFile file, Date reserveDT, String userID, Boolean adsYN, String title) throws PopbillException {
        return this.requestFaxBinary(corpNum, sendNum, null, receivers, new FaxUploadFile[]{file}, reserveDT, userID, adsYN, title, null);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, Receiver[] receivers, File file, Date reserveDT, String userID, Boolean adsYN, String title, String requestNum) throws PopbillException {
        return this.requestFax(corpNum, sendNum, null, receivers, new File[]{file}, reserveDT, userID, adsYN, title, requestNum);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, Receiver[] receivers, FaxUploadFile file, Date reserveDT, String userID, Boolean adsYN, String title, String requestNum) throws PopbillException {
        return this.requestFaxBinary(corpNum, sendNum, null, receivers, new FaxUploadFile[]{file}, reserveDT, userID, adsYN, title, requestNum);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, String receiveNum, String receiveName, File[] files, Date reserveDT) throws PopbillException {
        Receiver receiver = new Receiver();
        receiver.setReceiveNum(receiveNum);
        receiver.setReceiveName(receiveName);
        return this.requestFax(corpNum, sendNum, null, new Receiver[]{receiver}, files, reserveDT, null, null, null, null);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, String receiveNum, String receiveName, FaxUploadFile[] files, Date reserveDT) throws PopbillException {
        Receiver receiver = new Receiver();
        receiver.setReceiveNum(receiveNum);
        receiver.setReceiveName(receiveName);
        return this.requestFaxBinary(corpNum, sendNum, null, new Receiver[]{receiver}, files, reserveDT, null, null, null, null);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, String receiveNum, String receiveName, File[] files, Date reserveDT, Boolean adsYN) throws PopbillException {
        Receiver receiver = new Receiver();
        receiver.setReceiveNum(receiveNum);
        receiver.setReceiveName(receiveName);
        return this.requestFax(corpNum, sendNum, null, new Receiver[]{receiver}, files, reserveDT, null, adsYN, null, null);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, String receiveNum, String receiveName, FaxUploadFile[] files, Date reserveDT, Boolean adsYN) throws PopbillException {
        Receiver receiver = new Receiver();
        receiver.setReceiveNum(receiveNum);
        receiver.setReceiveName(receiveName);
        return this.requestFaxBinary(corpNum, sendNum, null, new Receiver[]{receiver}, files, reserveDT, null, adsYN, null, null);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, String receiveNum, String receiveName, File[] files, Date reserveDT, Boolean adsYN, String title) throws PopbillException {
        Receiver receiver = new Receiver();
        receiver.setReceiveNum(receiveNum);
        receiver.setReceiveName(receiveName);
        return this.requestFax(corpNum, sendNum, null, new Receiver[]{receiver}, files, reserveDT, null, adsYN, title, null);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, String receiveNum, String receiveName, FaxUploadFile[] files, Date reserveDT, Boolean adsYN, String title) throws PopbillException {
        Receiver receiver = new Receiver();
        receiver.setReceiveNum(receiveNum);
        receiver.setReceiveName(receiveName);
        return this.requestFaxBinary(corpNum, sendNum, null, new Receiver[]{receiver}, files, reserveDT, null, adsYN, title, null);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, String receiveNum, String receiveName, File[] files, Date reserveDT, Boolean adsYN, String title, String requestNum) throws PopbillException {
        Receiver receiver = new Receiver();
        receiver.setReceiveNum(receiveNum);
        receiver.setReceiveName(receiveName);
        return this.requestFax(corpNum, sendNum, null, new Receiver[]{receiver}, files, reserveDT, null, adsYN, title, requestNum);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, String receiveNum, String receiveName, FaxUploadFile[] files, Date reserveDT, Boolean adsYN, String title, String requestNum) throws PopbillException {
        Receiver receiver = new Receiver();
        receiver.setReceiveNum(receiveNum);
        receiver.setReceiveName(receiveName);
        return this.requestFaxBinary(corpNum, sendNum, null, new Receiver[]{receiver}, files, reserveDT, null, adsYN, title, requestNum);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, String receiveNum, String receiveName, File[] files, Date reserveDT, String userID) throws PopbillException {
        Receiver receiver = new Receiver();
        receiver.setReceiveNum(receiveNum);
        receiver.setReceiveName(receiveName);
        return this.requestFax(corpNum, sendNum, null, new Receiver[]{receiver}, files, reserveDT, userID, null, null, null);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, String receiveNum, String receiveName, FaxUploadFile[] files, Date reserveDT, String userID) throws PopbillException {
        Receiver receiver = new Receiver();
        receiver.setReceiveNum(receiveNum);
        receiver.setReceiveName(receiveName);
        return this.requestFaxBinary(corpNum, sendNum, null, new Receiver[]{receiver}, files, reserveDT, userID, null, null, null);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, String receiveNum, String receiveName, File[] files, Date reserveDT, String userID, String title) throws PopbillException {
        Receiver receiver = new Receiver();
        receiver.setReceiveNum(receiveNum);
        receiver.setReceiveName(receiveName);
        return this.requestFax(corpNum, sendNum, null, new Receiver[]{receiver}, files, reserveDT, userID, false, title, null);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, String receiveNum, String receiveName, FaxUploadFile[] files, Date reserveDT, String userID, String title) throws PopbillException {
        Receiver receiver = new Receiver();
        receiver.setReceiveNum(receiveNum);
        receiver.setReceiveName(receiveName);
        return this.requestFaxBinary(corpNum, sendNum, null, new Receiver[]{receiver}, files, reserveDT, userID, false, title, null);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, String receiveNum, String receiveName, File[] files, Date reserveDT, String userID, String title, String requestNum) throws PopbillException {
        Receiver receiver = new Receiver();
        receiver.setReceiveNum(receiveNum);
        receiver.setReceiveName(receiveName);
        return this.requestFax(corpNum, sendNum, null, new Receiver[]{receiver}, files, reserveDT, userID, false, title, requestNum);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, String receiveNum, String receiveName, FaxUploadFile[] files, Date reserveDT, String userID, String title, String requestNum) throws PopbillException {
        Receiver receiver = new Receiver();
        receiver.setReceiveNum(receiveNum);
        receiver.setReceiveName(receiveName);
        return this.requestFaxBinary(corpNum, sendNum, null, new Receiver[]{receiver}, files, reserveDT, userID, false, title, requestNum);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, String receiveNum, String receiveName, File[] files, Date reserveDT, String userID, Boolean adsYN) throws PopbillException {
        Receiver receiver = new Receiver();
        receiver.setReceiveNum(receiveNum);
        receiver.setReceiveName(receiveName);
        return this.requestFax(corpNum, sendNum, null, new Receiver[]{receiver}, files, reserveDT, userID, adsYN, null, null);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, String receiveNum, String receiveName, FaxUploadFile[] files, Date reserveDT, String userID, Boolean adsYN) throws PopbillException {
        Receiver receiver = new Receiver();
        receiver.setReceiveNum(receiveNum);
        receiver.setReceiveName(receiveName);
        return this.requestFaxBinary(corpNum, sendNum, null, new Receiver[]{receiver}, files, reserveDT, userID, adsYN, null, null);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, String receiveNum, String receiveName, File[] files, Date reserveDT, String userID, Boolean adsYN, String title) throws PopbillException {
        Receiver receiver = new Receiver();
        receiver.setReceiveNum(receiveNum);
        receiver.setReceiveName(receiveName);
        return this.requestFax(corpNum, sendNum, null, new Receiver[]{receiver}, files, reserveDT, userID, adsYN, title, null);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, String receiveNum, String receiveName, FaxUploadFile[] files, Date reserveDT, String userID, Boolean adsYN, String title) throws PopbillException {
        Receiver receiver = new Receiver();
        receiver.setReceiveNum(receiveNum);
        receiver.setReceiveName(receiveName);
        return this.requestFaxBinary(corpNum, sendNum, null, new Receiver[]{receiver}, files, reserveDT, userID, adsYN, title, null);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, String receiveNum, String receiveName, File[] files, Date reserveDT, String userID, Boolean adsYN, String title, String requestNum) throws PopbillException {
        Receiver receiver = new Receiver();
        receiver.setReceiveNum(receiveNum);
        receiver.setReceiveName(receiveName);
        return this.requestFax(corpNum, sendNum, null, new Receiver[]{receiver}, files, reserveDT, userID, adsYN, title, requestNum);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, String receiveNum, String receiveName, FaxUploadFile[] files, Date reserveDT, String userID, Boolean adsYN, String title, String requestNum) throws PopbillException {
        Receiver receiver = new Receiver();
        receiver.setReceiveNum(receiveNum);
        receiver.setReceiveName(receiveName);
        return this.requestFaxBinary(corpNum, sendNum, null, new Receiver[]{receiver}, files, reserveDT, userID, adsYN, title, requestNum);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, Receiver[] receivers, File[] files, Date reserveDT, String userID) throws PopbillException {
        return this.requestFax(corpNum, sendNum, null, receivers, files, reserveDT, userID, null, null, null);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, Receiver[] receivers, FaxUploadFile[] files, Date reserveDT, String userID) throws PopbillException {
        return this.requestFaxBinary(corpNum, sendNum, null, receivers, files, reserveDT, userID, null, null, null);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, Receiver[] receivers, File[] files, Date reserveDT, String userID, String title) throws PopbillException {
        return this.requestFax(corpNum, sendNum, null, receivers, files, reserveDT, userID, false, title, null);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, Receiver[] receivers, FaxUploadFile[] files, Date reserveDT, String userID, String title) throws PopbillException {
        return this.requestFaxBinary(corpNum, sendNum, null, receivers, files, reserveDT, userID, false, title, null);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, Receiver[] receivers, File[] files, Date reserveDT, String userID, String title, String reqestNum) throws PopbillException {
        return this.requestFax(corpNum, sendNum, null, receivers, files, reserveDT, userID, false, title, reqestNum);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, Receiver[] receivers, FaxUploadFile[] files, Date reserveDT, String userID, String title, String reqestNum) throws PopbillException {
        return this.requestFaxBinary(corpNum, sendNum, null, receivers, files, reserveDT, userID, false, title, reqestNum);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, Receiver[] receivers, File[] files, Date reserveDT, String userID, Boolean adsYN) throws PopbillException {
        return this.requestFax(corpNum, sendNum, null, receivers, files, reserveDT, userID, adsYN, null, null);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, Receiver[] receivers, FaxUploadFile[] files, Date reserveDT, String userID, Boolean adsYN) throws PopbillException {
        return this.requestFaxBinary(corpNum, sendNum, null, receivers, files, reserveDT, userID, adsYN, null, null);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, Receiver[] receivers, File[] files, Date reserveDT, String userID, Boolean adsYN, String title) throws PopbillException {
        return this.requestFax(corpNum, sendNum, null, receivers, files, reserveDT, userID, adsYN, title, null);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, Receiver[] receivers, FaxUploadFile[] files, Date reserveDT, String userID, Boolean adsYN, String title) throws PopbillException {
        return this.requestFaxBinary(corpNum, sendNum, null, receivers, files, reserveDT, userID, adsYN, title, null);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, Receiver[] receivers, File[] files, Date reserveDT, String userID, Boolean adsYN, String title, String requestNum) throws PopbillException {
        return this.requestFax(corpNum, sendNum, null, receivers, files, reserveDT, userID, adsYN, title, requestNum);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, Receiver[] receivers, FaxUploadFile[] files, Date reserveDT, String userID, Boolean adsYN, String title, String requestNum) throws PopbillException {
        return this.requestFaxBinary(corpNum, sendNum, null, receivers, files, reserveDT, userID, adsYN, title, requestNum);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, String senderName, Receiver[] receivers, File[] files, Date reserveDT) throws PopbillException {
        return this.requestFax(corpNum, sendNum, senderName, receivers, files, reserveDT, null, null, null, null);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, String senderName, Receiver[] receivers, FaxUploadFile[] files, Date reserveDT) throws PopbillException {
        return this.requestFaxBinary(corpNum, sendNum, senderName, receivers, files, reserveDT, null, null, null, null);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, String senderName, Receiver[] receivers, File[] files, Date reserveDT, Boolean adsYN) throws PopbillException {
        return this.requestFax(corpNum, sendNum, senderName, receivers, files, reserveDT, null, adsYN, null, null);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, String senderName, Receiver[] receivers, FaxUploadFile[] files, Date reserveDT, Boolean adsYN) throws PopbillException {
        return this.requestFaxBinary(corpNum, sendNum, senderName, receivers, files, reserveDT, null, adsYN, null, null);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, String senderName, Receiver[] receivers, File[] files, Date reserveDT, Boolean adsYN, String requestNum) throws PopbillException {
        return this.requestFax(corpNum, sendNum, senderName, receivers, files, reserveDT, null, adsYN, null, requestNum);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, String senderName, Receiver[] receivers, FaxUploadFile[] files, Date reserveDT, Boolean adsYN, String requestNum) throws PopbillException {
        return this.requestFaxBinary(corpNum, sendNum, senderName, receivers, files, reserveDT, null, adsYN, null, requestNum);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, String senderName, Receiver[] receivers, File[] files, Date reserveDT, String userID) throws PopbillException {
        return this.requestFax(corpNum, sendNum, senderName, receivers, files, reserveDT, userID, false, null, null);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, String senderName, Receiver[] receivers, FaxUploadFile[] files, Date reserveDT, String userID) throws PopbillException {
        return this.requestFaxBinary(corpNum, sendNum, senderName, receivers, files, reserveDT, userID, false, null, null);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, String senderName, Receiver[] receivers, File[] files, Date reserveDT, String userID, String title) throws PopbillException {
        return this.requestFax(corpNum, sendNum, senderName, receivers, files, reserveDT, userID, false, title, null);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, String senderName, Receiver[] receivers, FaxUploadFile[] files, Date reserveDT, String userID, String title) throws PopbillException {
        return this.requestFaxBinary(corpNum, sendNum, senderName, receivers, files, reserveDT, userID, false, title, null);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, String senderName, Receiver[] receivers, File[] files, Date reserveDT, String userID, String title, String requestNum) throws PopbillException {
        return this.requestFax(corpNum, sendNum, senderName, receivers, files, reserveDT, userID, false, title, requestNum);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, String senderName, Receiver[] receivers, FaxUploadFile[] files, Date reserveDT, String userID, String title, String requestNum) throws PopbillException {
        return this.requestFaxBinary(corpNum, sendNum, senderName, receivers, files, reserveDT, userID, false, title, requestNum);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, String senderName, Receiver[] receivers, File[] files, Date reserveDT, String userID, Boolean adsYN) throws PopbillException {
        return this.requestFax(corpNum, sendNum, senderName, receivers, files, reserveDT, userID, adsYN, null, null);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, String senderName, Receiver[] receivers, FaxUploadFile[] files, Date reserveDT, String userID, Boolean adsYN) throws PopbillException {
        return this.requestFaxBinary(corpNum, sendNum, senderName, receivers, files, reserveDT, userID, adsYN, null, null);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, String senderName, Receiver[] receivers, File[] files, Date reserveDT, String userID, Boolean adsYN, String title) throws PopbillException {
        return this.requestFax(corpNum, sendNum, senderName, receivers, files, reserveDT, userID, adsYN, title, null);
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, String senderName, Receiver[] receivers, FaxUploadFile[] files, Date reserveDT, String userID, Boolean adsYN, String title) throws PopbillException {
        return this.requestFaxBinary(corpNum, sendNum, senderName, receivers, files, reserveDT, userID, adsYN, title, null);
    }

    @Override
    public String sendFAX(String corpNum, String sendNum, String senderName, Receiver[] receivers, File[] files, Date reserveDT, String userID, Boolean adsYN, String title, String requestNum) throws PopbillException {
        return this.requestFax(corpNum, sendNum, senderName, receivers, files, reserveDT, userID, adsYN, title, requestNum);
    }

    private String requestFax(String corpNum, String sendNum, String senderName, Receiver[] receivers, File[] files, Date reserveDT, String userID, Boolean adsYN, String title, String requestNum) throws PopbillException {
        if (sendNum == null || sendNum.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubc1c\uc2e0\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (receivers == null || receivers.length == 0) {
            throw new PopbillException(-99999999L, "\uc218\uc2e0\ucc98 \uc815\ubcf4\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (files == null || files.length == 0) {
            throw new PopbillException(-99999999L, "\ubc1c\uc2e0\ud30c\uc77c \uc815\ubcf4\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (files.length > 20) {
            throw new PopbillException(-99999999L, "\ub3d9\ubcf4\ubc1c\uc2e0 \ucd5c\ub300 \ud30c\uc77c\uac2f\uc218\ub294 20\uac1c \uc785\ub2c8\ub2e4.");
        }
        SendRequest request = new SendRequest();
        request.snd = sendNum;
        request.rcvs = receivers;
        if (senderName != null) {
            request.sndnm = senderName;
        }
        if (reserveDT != null) {
            request.sndDT = new SimpleDateFormat("yyyyMMddHHmmss", Locale.KOREA).format(reserveDT);
        }
        if (adsYN != null && adsYN.booleanValue()) {
            request.adsYN = true;
        }
        if (title != null) {
            request.title = title;
        }
        if (requestNum != null) {
            request.requestNum = requestNum;
        }
        request.fCnt = files.length;
        String PostData = this.toJsonString(request);
        ArrayList<BaseServiceImp.UploadFile> uploadFiles = new ArrayList<BaseServiceImp.UploadFile>();
        for (File f : files) {
            BaseServiceImp.UploadFile uf = new BaseServiceImp.UploadFile(this);
            uf.fieldName = "file";
            uf.fileName = f.getName();
            try {
                uf.fileData = new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                throw new PopbillException(-99999999L, "\uc804\uc1a1\ud560 \ud30c\uc77c\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.", e);
            }
            uploadFiles.add(uf);
        }
        ReceiptResponse response = this.httppostFiles("/FAX", corpNum, PostData, uploadFiles, userID, ReceiptResponse.class);
        for (BaseServiceImp.UploadFile uf : uploadFiles) {
            if (uf.fileData == null) continue;
            try {
                uf.fileData.close();
            }
            catch (IOException iOException) {}
        }
        return response.receiptNum;
    }

    @Override
    public String sendFAXBinary(String corpNum, String sendNum, String senderName, Receiver[] receivers, FaxUploadFile[] files, Date reserveDT, String userID, Boolean adsYN, String title, String requestNum) throws PopbillException {
        return this.requestFaxBinary(corpNum, sendNum, senderName, receivers, files, reserveDT, userID, adsYN, title, requestNum);
    }

    private String requestFaxBinary(String corpNum, String sendNum, String senderName, Receiver[] receivers, FaxUploadFile[] files, Date reserveDT, String userID, Boolean adsYN, String title, String requestNum) throws PopbillException {
        if (sendNum == null || sendNum.isEmpty()) {
            throw new PopbillException(-99999999L, "\ubc1c\uc2e0\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (receivers == null || receivers.length == 0) {
            throw new PopbillException(-99999999L, "\uc218\uc2e0\ucc98 \uc815\ubcf4\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (files == null || files.length == 0) {
            throw new PopbillException(-99999999L, "\ubc1c\uc2e0\ud30c\uc77c \uc815\ubcf4\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (files.length > 20) {
            throw new PopbillException(-99999999L, "\ub3d9\ubcf4\ubc1c\uc2e0 \ucd5c\ub300 \ud30c\uc77c\uac2f\uc218\ub294 20\uac1c \uc785\ub2c8\ub2e4.");
        }
        SendRequest request = new SendRequest();
        request.snd = sendNum;
        request.rcvs = receivers;
        if (senderName != null) {
            request.sndnm = senderName;
        }
        if (reserveDT != null) {
            request.sndDT = new SimpleDateFormat("yyyyMMddHHmmss", Locale.KOREA).format(reserveDT);
        }
        if (adsYN != null && adsYN.booleanValue()) {
            request.adsYN = true;
        }
        if (title != null) {
            request.title = title;
        }
        if (requestNum != null) {
            request.requestNum = requestNum;
        }
        request.fCnt = files.length;
        String PostData = this.toJsonString(request);
        ArrayList<BaseServiceImp.UploadFile> uploadFiles = new ArrayList<BaseServiceImp.UploadFile>();
        for (FaxUploadFile f : files) {
            BaseServiceImp.UploadFile uf = new BaseServiceImp.UploadFile(this);
            uf.fieldName = "file";
            uf.fileName = f.fileName;
            uf.fileData = f.fileData;
            uploadFiles.add(uf);
        }
        ReceiptResponse response = this.httppostFiles("/FAX", corpNum, PostData, uploadFiles, userID, ReceiptResponse.class);
        for (BaseServiceImp.UploadFile uf : uploadFiles) {
            if (uf.fileData == null) continue;
            try {
                uf.fileData.close();
            }
            catch (IOException iOException) {}
        }
        return response.receiptNum;
    }

    @Override
    public String resendFAX(String corpNum, String receiptNum, String sendNum, String senderName, String receiveNum, String receiveName, Date reserveDT, String userID) throws PopbillException {
        Receiver receiver = null;
        if (!receiveNum.isEmpty() || !receiveName.isEmpty()) {
            receiver = new Receiver();
            receiver.setReceiveNum(receiveNum);
            receiver.setReceiveName(receiveName);
            return this.resendFAX(corpNum, receiptNum, sendNum, senderName, new Receiver[]{receiver}, reserveDT, userID, null);
        }
        return this.resendFAX(corpNum, receiptNum, sendNum, senderName, null, reserveDT, userID, null);
    }

    @Override
    public String resendFAX(String corpNum, String receiptNum, String sendNum, String senderName, String receiveNum, String receiveName, Date reserveDT, String userID, String title) throws PopbillException {
        Receiver receiver = null;
        if (!receiveNum.isEmpty() || !receiveName.isEmpty()) {
            receiver = new Receiver();
            receiver.setReceiveNum(receiveNum);
            receiver.setReceiveName(receiveName);
            return this.resendFAX(corpNum, receiptNum, sendNum, senderName, new Receiver[]{receiver}, reserveDT, userID, title);
        }
        return this.resendFAX(corpNum, receiptNum, sendNum, senderName, null, reserveDT, userID, title);
    }

    @Override
    public String resendFAX(String corpNum, String receiptNum, String sendNum, String senderName, String receiveNum, String receiveName, Date reserveDT, String userID, String title, String requestNum) throws PopbillException {
        Receiver receiver = null;
        if (!receiveNum.isEmpty() || !receiveName.isEmpty()) {
            receiver = new Receiver();
            receiver.setReceiveNum(receiveNum);
            receiver.setReceiveName(receiveName);
            return this.resendFAX(corpNum, receiptNum, sendNum, senderName, new Receiver[]{receiver}, reserveDT, userID, title, requestNum);
        }
        return this.resendFAX(corpNum, receiptNum, sendNum, senderName, null, reserveDT, userID, title, requestNum);
    }

    @Override
    public String resendFAX(String corpNum, String receiptNum, String sendNum, String senderName, Receiver[] receivers, Date reserveDT) throws PopbillException {
        return this.resendFAX(corpNum, receiptNum, sendNum, senderName, receivers, reserveDT, null, null);
    }

    @Override
    public String resendFAX(String corpNum, String receiptNum, String sendNum, String senderName, Receiver[] receivers, Date reserveDT, String userID) throws PopbillException {
        return this.resendFAX(corpNum, receiptNum, sendNum, senderName, receivers, reserveDT, userID, null);
    }

    @Override
    public String resendFAX(String corpNum, String receiptNum, String sendNum, String senderName, Receiver[] receivers, Date reserveDT, String userID, String title) throws PopbillException {
        return this.resendFAX(corpNum, receiptNum, sendNum, senderName, receivers, reserveDT, userID, title, null);
    }

    @Override
    public String resendFAX(String corpNum, String receiptNum, String sendNum, String senderName, Receiver[] receivers, Date reserveDT, String userID, String title, String requestNum) throws PopbillException {
        if (receiptNum == null) {
            throw new PopbillException(-99999999L, "\ud329\uc2a4 \uc811\uc218\ubc88\ud638(receiptNum)\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (receiptNum.length() != 18) {
            throw new PopbillException(-99999999L, "\uc811\uc218\ubc88\ud638\uac00 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        SendRequest request = new SendRequest();
        if (sendNum != null) {
            request.snd = sendNum;
        }
        if (senderName != null) {
            request.sndnm = senderName;
        }
        if (title != null) {
            request.title = title;
        }
        if (receivers != null) {
            request.rcvs = receivers;
        }
        if (reserveDT != null) {
            request.sndDT = new SimpleDateFormat("yyyyMMddHHmmss", Locale.KOREA).format(reserveDT);
        }
        if (requestNum != null) {
            request.requestNum = requestNum;
        }
        String PostData = this.toJsonString(request);
        ReceiptResponse response = this.httppost("/FAX/" + receiptNum, corpNum, PostData, userID, ReceiptResponse.class);
        return response.receiptNum;
    }

    @Override
    public String resendFAXRN(String corpNum, String requestNum, String sendNum, String senderName, String receiveNum, String receiveName, Date reserveDT, String userID, String title, String originalFAXrequestNum) throws PopbillException {
        Receiver receiver = null;
        if (!receiveNum.isEmpty() || !receiveName.isEmpty()) {
            receiver = new Receiver();
            receiver.setReceiveNum(receiveNum);
            receiver.setReceiveName(receiveName);
            return this.resendFAXRN(corpNum, requestNum, sendNum, senderName, new Receiver[]{receiver}, reserveDT, userID, title, originalFAXrequestNum);
        }
        return this.resendFAXRN(corpNum, requestNum, sendNum, senderName, null, reserveDT, userID, title, originalFAXrequestNum);
    }

    @Override
    public String resendFAXRN(String corpNum, String requestNum, String sendNum, String senderName, Receiver[] receivers, Date reserveDT, String userID, String title, String originalFAXrequestNum) throws PopbillException {
        if (requestNum == null) {
            throw new PopbillException(-99999999L, "\uc7ac\uc804\uc1a1 \ud329\uc2a4\uc758 \uc804\uc1a1\uc694\uccad\ubc88\ud638(requestNum)\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (originalFAXrequestNum == null) {
            throw new PopbillException(-99999999L, "\uc6d0\ubcf8 \ud329\uc2a4 \uc804\uc1a1\uc2dc \ud560\ub2f9\ud55c \uc804\uc1a1\uc694\uccad\ubc88\ud638(originalFAXrequestNum)\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        SendRequest request = new SendRequest();
        if (sendNum != null) {
            request.snd = sendNum;
        }
        if (senderName != null) {
            request.sndnm = senderName;
        }
        if (title != null) {
            request.title = title;
        }
        if (receivers != null) {
            request.rcvs = receivers;
        }
        if (reserveDT != null) {
            request.sndDT = new SimpleDateFormat("yyyyMMddHHmmss", Locale.KOREA).format(reserveDT);
        }
        if (requestNum != null) {
            request.requestNum = requestNum;
        }
        String PostData = this.toJsonString(request);
        ReceiptResponse response = this.httppost("/FAX/Resend/" + originalFAXrequestNum, corpNum, PostData, userID, ReceiptResponse.class);
        return response.receiptNum;
    }

    @Override
    public FaxResult[] getFaxResult(String corpNum, String receiptNum) throws PopbillException {
        if (receiptNum == null) {
            throw new PopbillException(-99999999L, "\uc811\uc218\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (receiptNum.length() != 18) {
            throw new PopbillException(-99999999L, "\uc811\uc218\ubc88\ud638\uac00 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/FAX/" + receiptNum, corpNum, null, FaxResult[].class);
    }

    @Override
    public FaxResult[] getFaxResultRN(String corpNum, String requestNum) throws PopbillException {
        if (requestNum == null) {
            throw new PopbillException(-99999999L, "\uc804\uc1a1\uc694\uccad\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/FAX/Get/" + requestNum, corpNum, null, FaxResult[].class);
    }

    @Override
    public Response cancelReserve(String corpNum, String receiptNum) throws PopbillException {
        return this.cancelReserve(corpNum, receiptNum, null);
    }

    @Override
    public Response cancelReserve(String corpNum, String receiptNum, String userID) throws PopbillException {
        if (receiptNum == null) {
            throw new PopbillException(-99999999L, "\uc811\uc218\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (receiptNum.length() != 18) {
            throw new PopbillException(-99999999L, "\uc811\uc218\ubc88\ud638\uac00 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/FAX/" + receiptNum + "/Cancel", corpNum, userID, Response.class);
    }

    @Override
    public Response cancelReserveRN(String corpNum, String requestNum) throws PopbillException {
        return this.cancelReserveRN(corpNum, requestNum, null);
    }

    @Override
    public Response cancelReserveRN(String corpNum, String requestNum, String userID) throws PopbillException {
        if (requestNum == null) {
            throw new PopbillException(-99999999L, "\uc804\uc1a1\uc694\uccad\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/FAX/Cancel/" + requestNum, corpNum, userID, Response.class);
    }

    @Override
    public FAXSearchResult search(String corpNum, String sDate, String eDate, String[] state, Boolean reserveYN, Boolean senderOnly, int page, int perPage, String order) throws PopbillException {
        return this.search(corpNum, sDate, eDate, state, reserveYN, senderOnly, page, perPage, order, null);
    }

    @Override
    public FAXSearchResult search(String corpNum, String sDate, String eDate, String[] state, Boolean reserveYN, Boolean senderOnly, int page, int perPage, String order, String qString) throws PopbillException {
        if (sDate == null) {
            throw new PopbillException(-99999999L, "\uc2dc\uc791\uc77c\uc790\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (eDate == null) {
            throw new PopbillException(-99999999L, "\uc885\ub8cc\uc77c\uc790\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        String uri = "/FAX/Search?SDate=" + sDate;
        uri = uri + "&EDate=" + eDate;
        uri = uri + "&State=" + Arrays.toString(state).replaceAll("\\[|\\]|\\s", "");
        uri = reserveYN != false ? uri + "&ReserveYN=1" : uri + "&ReserveYN=0";
        uri = senderOnly != false ? uri + "&SenderOnly=1" : uri + "&SenderOnly=0";
        uri = uri + "&Page=" + Integer.toString(page);
        uri = uri + "&PerPage=" + Integer.toString(perPage);
        uri = uri + "&Order=" + order;
        if (qString != null && qString != "") {
            try {
                uri = uri + "&QString=" + URLEncoder.encode(qString, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new PopbillException(-99999999L, "\uac80\uc0c9\uc5b4(qString) \uc778\ucf54\ub529 \uc624\ub958");
            }
        }
        return this.httpget(uri, corpNum, null, FAXSearchResult.class);
    }

    @Override
    public ChargeInfo getChargeInfo(String corpNum) throws PopbillException {
        return this.httpget("/FAX/ChargeInfo", corpNum, null, ChargeInfo.class);
    }

    @Override
    public ChargeInfo getChargeInfo(String corpNum, String receiveNumType) throws PopbillException {
        return this.httpget("/FAX/ChargeInfo?receiveNumType=" + receiveNumType, corpNum, null, ChargeInfo.class);
    }

    @Override
    public SenderNumber[] getSenderNumberList(String corpNum) throws PopbillException {
        return this.getSenderNumberList(corpNum, null);
    }

    @Override
    public SenderNumber[] getSenderNumberList(String corpNum, String userID) throws PopbillException {
        return this.httpget("/FAX/SenderNumber", corpNum, userID, SenderNumber[].class);
    }

    @Override
    public String getPreviewURL(String corpNum, String receiptNum) throws PopbillException {
        return this.getPreviewURL(corpNum, receiptNum, null);
    }

    @Override
    public String getPreviewURL(String corpNum, String receiptNum, String userID) throws PopbillException {
        if (receiptNum == null || receiptNum.equals("")) {
            throw new PopbillException(-99999999L, "\uc811\uc218\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (receiptNum.length() != 18) {
            throw new PopbillException(-99999999L, "\uc811\uc218\ubc88\ud638\uac00 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        BaseServiceImp.URLResponse response = this.httpget("/FAX/Preview/" + receiptNum, corpNum, userID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public String getSenderNumberMgtURL(String CorpNum, String UserID) throws PopbillException {
        BaseServiceImp.URLResponse response = this.httpget("/FAX/?TG=SENDER", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public String getSentListURL(String CorpNum, String UserID) throws PopbillException {
        BaseServiceImp.URLResponse response = this.httpget("/FAX/?TG=BOX", CorpNum, UserID, BaseServiceImp.URLResponse.class);
        return response.url;
    }

    @Override
    public Response checkSenderNumber(String CorpNum, String SenderNumber2) throws PopbillException {
        return this.checkSenderNumber(CorpNum, SenderNumber2, null);
    }

    @Override
    public Response checkSenderNumber(String CorpNum, String SenderNumber2, String UserID) throws PopbillException {
        if (SenderNumber2 == null || SenderNumber2.equals("")) {
            throw new PopbillException(-99999999L, "\ubc1c\uc2e0\ubc88\ud638\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        return this.httpget("/FAX/CheckSenderNumber/" + SenderNumber2, CorpNum, UserID, Response.class);
    }

    protected class ReceiptResponse {
        public String receiptNum;

        protected ReceiptResponse() {
        }
    }

    protected class SendRequest {
        public String snd;
        public String sndnm;
        public String sndDT;
        public String title;
        public Integer fCnt;
        public Boolean adsYN;
        public String requestNum;
        public Receiver[] rcvs;

        protected SendRequest() {
        }
    }
}

